/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.swing.JComponent;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.SignatureProvider;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.feature.d;

public class FormBlankSignatureWidgetFactory
extends d {
    public FormBlankSignatureWidgetFactory() {
        super("FormBlankSignatureWidgetFactory");
    }

    public boolean matches(PDFAnnotation pDFAnnotation) {
        return pDFAnnotation instanceof WidgetAnnotation && ((WidgetAnnotation)pDFAnnotation).getField() instanceof FormSignature && ((FormSignature)((WidgetAnnotation)pDFAnnotation).getField()).getState() == 2;
    }

    public JComponent createComponent(PagePanel pagePanel, PDFAnnotation pDFAnnotation) {
        final WidgetAnnotation widgetAnnotation = (WidgetAnnotation)pDFAnnotation;
        final DocumentPanel documentPanel = pagePanel.getDocumentPanel();
        final FormSignature formSignature = (FormSignature)widgetAnnotation.getField();
        final JComponent jComponent = this.a(pagePanel, pDFAnnotation, null);
        jComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!formSignature.isReadOnly()) {
                    SignatureProvider.selectSignProvider(documentPanel, formSignature, jComponent, mouseEvent.getPoint(), new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SignatureProvider signatureProvider = (SignatureProvider)actionEvent.getSource();
                            try {
                                FormBlankSignatureWidgetFactory.this.sign(formSignature, documentPanel, signatureProvider);
                            }
                            catch (Exception exception) {
                                Util.displayThrowable(exception, documentPanel);
                            }
                        }
                    });
                }
            }
        });
        jComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jComponent.repaint();
                documentPanel.runAction(widgetAnnotation.getAction(Event.FOCUS));
            }

            public void focusLost(FocusEvent focusEvent) {
                if (jComponent.isValid()) {
                    jComponent.repaint();
                    documentPanel.runAction(widgetAnnotation.getAction(Event.BLUR));
                }
            }
        });
        return jComponent;
    }

    public void sign(FormSignature formSignature, DocumentPanel documentPanel, SignatureProvider signatureProvider) throws IOException, GeneralSecurityException {
        signatureProvider.showSignDialog(documentPanel, formSignature);
    }
}

