/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.faceless.pdf2.FDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.viewer2.ActionHandler;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.Util;

public class FormImportDataActionHandler
extends ActionHandler {
    public static FormImportDataActionHandler getInstance() {
        return new FormImportDataActionHandler();
    }

    public FormImportDataActionHandler() {
        super("FormImportDataActionHandler");
    }

    public boolean matches(DocumentPanel documentPanel, PDFAction pDFAction) {
        return pDFAction.getType().equals("FormImportData");
    }

    public void run(final DocumentPanel documentPanel, final PDFAction pDFAction) {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                InputStream inputStream = null;
                try {
                    URL uRL = Util.toURL(documentPanel, pDFAction.getURL());
                    inputStream = uRL.openConnection().getInputStream();
                    FDF fDF = new FDF(inputStream);
                    documentPanel.getPDF().importFDF(fDF);
                }
                catch (Exception exception) {
                    Util.displayThrowable(exception, documentPanel.getViewer());
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
        });
    }
}

