/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.SignatureProvider;
import org.faceless.pdf2.viewer2.feature.d;

public class FormSignedSignatureWidgetFactory
extends d {
    public FormSignedSignatureWidgetFactory() {
        super("FormSignedSignatureWidgetFactory");
    }

    public boolean matches(PDFAnnotation pDFAnnotation) {
        return pDFAnnotation instanceof WidgetAnnotation && ((WidgetAnnotation)pDFAnnotation).getField() instanceof FormSignature && ((FormSignature)((WidgetAnnotation)pDFAnnotation).getField()).getState() == 0;
    }

    protected void paintComponentAnnotations(JComponent jComponent, Graphics graphics) {
        super.paintComponentAnnotations(jComponent, graphics);
        WidgetAnnotation widgetAnnotation = (WidgetAnnotation)jComponent.getClientProperty("pdf.annotation");
        DocumentPanel documentPanel = (DocumentPanel)SwingUtilities.getAncestorOfClass(DocumentPanel.class, jComponent);
        ImageIcon imageIcon = SignatureProvider.getIcon(documentPanel, (FormSignature)widgetAnnotation.getField());
        imageIcon.paintIcon(jComponent, graphics, 0, 0);
    }

    public JComponent createComponent(PagePanel pagePanel, PDFAnnotation pDFAnnotation) {
        final WidgetAnnotation widgetAnnotation = (WidgetAnnotation)pDFAnnotation;
        final DocumentPanel documentPanel = pagePanel.getDocumentPanel();
        final FormSignature formSignature = (FormSignature)widgetAnnotation.getField();
        final JComponent jComponent = this.a(pagePanel, pDFAnnotation, null);
        jComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SignatureProvider.selectVerifyProvider(documentPanel, formSignature, jComponent, mouseEvent.getPoint(), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SignatureProvider signatureProvider = (SignatureProvider)actionEvent.getSource();
                        FormSignedSignatureWidgetFactory.this.verify(formSignature, documentPanel, signatureProvider);
                        jComponent.repaint();
                    }
                });
            }
        });
        jComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jComponent.repaint();
                documentPanel.runAction(widgetAnnotation.getAction(Event.FOCUS));
            }

            public void focusLost(FocusEvent focusEvent) {
                if (jComponent.isValid()) {
                    jComponent.repaint();
                    documentPanel.runAction(widgetAnnotation.getAction(Event.BLUR));
                }
            }
        });
        return jComponent;
    }

    public void verify(FormSignature formSignature, DocumentPanel documentPanel, SignatureProvider signatureProvider) {
        signatureProvider.showVerifyDialog(documentPanel, formSignature);
    }
}

