/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFImage;
import org.faceless.pdf2.PDFImageSet;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.hc;
import org.faceless.pdf2.viewer2.Importer;
import org.faceless.pdf2.viewer2.PDFViewer;

public class ImageImporter
extends Importer {
    private final FileFilter b = new FileFilter(){

        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return file.isDirectory() || string.endsWith(".png") || string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jp2") || string.endsWith(".tif") || string.endsWith(".bmp") || string.endsWith(".pnm") || string.endsWith(".ppm") || string.endsWith(".pbm") || string.endsWith(".pgm");
        }

        public String getDescription() {
            return UIManager.getString("PDFViewer.FilesBitmap");
        }
    };
    private static final byte[][] c = new byte[][]{{-1, -40}, {-119, 80, 78, 71, 13}, {73, 73, 42, 0}, {77, 77, 0, 42}, {71, 73, 70, 56}, {80, 52}, {80, 53}, {80, 54}, {66, 77}, {0, 0, 0, 12, 106, 80, 32, 32, 13}};

    public ImageImporter() {
        super("ImageImporter");
    }

    public FileFilter getFileFilter() {
        return this.b;
    }

    public boolean matches(final File file) throws IOException {
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws IOException {
                    if (file.length() > 10L) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 10);
                        byte[] byArray = new byte[10];
                        bufferedInputStream.read(byArray);
                        bufferedInputStream.close();
                        for (int n2 = 0; n2 < c.length; ++n2) {
                            int n3;
                            if (byArray.length <= c[n2].length) continue;
                            for (n3 = 0; n3 < c[n2].length && byArray[n3] == c[n2][n3]; ++n3) {
                            }
                            if (n3 != c[n2].length) continue;
                            return Boolean.TRUE;
                        }
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public Importer.ImporterTask getImporter(PDFViewer pDFViewer, File file) {
        return this.getImporter(pDFViewer, null, file.getName(), file);
    }

    public Importer.ImporterTask getImporter(PDFViewer pDFViewer, InputStream inputStream, String string, File file) {
        return new Importer.ImporterTask(pDFViewer, inputStream, string, file){
            private int j;
            private int k;

            public float getProgress() {
                return (float)this.j / (float)this.k;
            }

            public PDF loadPDF() throws IOException {
                final InputStream inputStream = this.in;
                try {
                    return (PDF)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws IOException {
                            InputStream inputStream2 = inputStream;
                            if (inputStream2 == null) {
                                inputStream2 = new FileInputStream(file);
                            }
                            try {
                                hc hc2;
                                PDF pDF = new PDF();
                                PDFImageSet pDFImageSet = new PDFImageSet(inputStream2);
                                k = pDFImageSet.getNumImages();
                                j = 0;
                                while (j < k) {
                                    hc2 = pDFImageSet.getImage(j);
                                    PDFPage pDFPage = pDF.newPage((int)hc2.getWidth(), (int)hc2.getHeight());
                                    pDFPage.drawImage((PDFImage)hc2, 0.0f, 0.0f, pDFPage.getWidth(), pDFPage.getHeight());
                                    j++;
                                }
                                pDF.setInfo("Title", "Converted from " + title);
                                hc2 = pDF;
                                return hc2;
                            }
                            finally {
                                inputStream2.close();
                            }
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
        };
    }
}

