/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PublicKeyEncryptionHandler;
import org.faceless.pdf2.StandardEncryptionHandler;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;
import org.faceless.pdf2.viewer2.util.DialogPanel;

public class Info
extends ViewerWidget {
    public Info() {
        super("GeneralInfo");
        this.setButton("Document", "resources/icons/info.png", "PDFViewer.tt.GeneralInfo");
        this.setMenu("File\tDocumentProperties", 'd');
    }

    public void action(ViewerEvent viewerEvent) {
        PDF pDF = viewerEvent.getPDF();
        if (pDF != null) {
            this.displayInfoPanel(pDF, viewerEvent.getViewer());
        }
    }

    public void displayInfoPanel(PDF pDF, PDFViewer pDFViewer) {
        DialogPanel dialogPanel = new DialogPanel(false);
        DocumentPanel documentPanel = pDFViewer.getActiveDocumentPanel();
        JTabbedPane jTabbedPane = new JTabbedPane(2);
        jTabbedPane.setTabPlacement(1);
        JComponent jComponent = this.getInfoPanel(pDF, documentPanel.getPage(), (File)documentPanel.getClientProperty("file"));
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Info"), new JScrollPane(jComponent));
        if (pDF.getEncryptionHandler() instanceof StandardEncryptionHandler) {
            jComponent = this.getStandardEncryptionPanel(pDF);
            jTabbedPane.addTab(UIManager.getString("PDFViewer.Encryption"), new JScrollPane(jComponent));
        } else if (pDF.getEncryptionHandler() instanceof PublicKeyEncryptionHandler) {
            jComponent = this.getPublicKeyEncryptionPanel(pDF);
            jTabbedPane.addTab(UIManager.getString("PDFViewer.Encryption"), new JScrollPane(jComponent));
        }
        jComponent = this.getProfilePanel(pDF);
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Features"), new JScrollPane(jComponent));
        jTabbedPane.setSelectedIndex(0);
        dialogPanel.addComponent(jTabbedPane);
        dialogPanel.showDialog(pDFViewer, UIManager.getString("PDFViewer.About"));
    }

    private void a(JPanel jPanel, String string, Object object, GridBagConstraints gridBagConstraints, GridBagConstraints gridBagConstraints2) {
        object = object == null ? "" : (object instanceof Date ? DateFormat.getDateTimeInstance(2, 3).format((Date)object) : object.toString());
        String string2 = UIManager.getString(string);
        if (string2 == null) {
            string2 = string;
        }
        JLabel jLabel = new JLabel(string2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel((String)object);
        jPanel.add((Component)jLabel, gridBagConstraints2);
    }

    private void a(JPanel jPanel, final String string, String string2, GridBagConstraints gridBagConstraints, GridBagConstraints gridBagConstraints2, final PDF pDF) {
        if (string2 == null) {
            string2 = "";
        }
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextField jTextField = new JTextField(string2);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pDF.setInfo(string, jTextField.getText());
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
        });
        jPanel.add((Component)jTextField, gridBagConstraints2);
    }

    public JComponent getInfoPanel(PDF pDF, PDFPage pDFPage, File file) {
        float[] fArray;
        float[] fArray2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(450, 300));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 5, 4, 20);
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints3.insets = new Insets(4, 5, 4, 5);
        if (file != null) {
            this.a(jPanel, "PDFViewer.File", file.toString(), gridBagConstraints, gridBagConstraints2);
            this.a(jPanel, "PDFViewer.FileSize", this.a(file.length()), gridBagConstraints, gridBagConstraints2);
            jPanel.add((Component)new JSeparator(), gridBagConstraints3);
        }
        this.a(jPanel, "PDFViewer.CreationDate", pDF.getInfo().get("CreationDate"), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.ModDate", pDF.getInfo().get("ModDate"), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.Language", pDF.getLocale() == null ? null : pDF.getLocale().toString(), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.Producer", pDF.getInfo().get("Producer"), gridBagConstraints, gridBagConstraints2);
        jPanel.add((Component)new JSeparator(), gridBagConstraints3);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        List<String> list = Arrays.asList("Author", "Title", "Subject", "Keywords", "Creator");
        Map map = pDF.getInfo();
        linkedHashSet.addAll(list);
        linkedHashSet.addAll(map.keySet());
        for (String object2 : linkedHashSet) {
            String string;
            Object v2 = map.get(object2);
            if (object2.equals("CreationDate") || object2.equals("ModDate") || object2.equals("Producer") || v2 instanceof Calendar) continue;
            if (list.contains(object2)) {
                string = UIManager.getString("PDFViewer." + object2);
                if (string == null) {
                    string = object2;
                }
            } else {
                string = object2;
            }
            this.a(jPanel, string, v2 == null ? "" : v2.toString(), gridBagConstraints, gridBagConstraints2, pDF);
        }
        jPanel.add((Component)new JSeparator(), gridBagConstraints3);
        this.a(jPanel, "PDFViewer.Pages", Integer.toString(pDF.getNumberOfPages()), gridBagConstraints, gridBagConstraints2);
        Object object4 = pDFPage.getBox("Media");
        this.a(jPanel, "PDFViewer.PageSize", this.a(pDFPage.getWidth(), pDFPage.getHeight()), gridBagConstraints, gridBagConstraints2);
        float[] fArray3 = pDFPage.getBox("Crop");
        if (fArray3 != null && !Arrays.equals((float[])object4, fArray3)) {
            this.a(jPanel, "PDFViewer.CropBox", this.a(fArray3[2] - fArray3[0], fArray3[3] - fArray3[1]), gridBagConstraints, gridBagConstraints2);
            object4 = fArray3;
        }
        if ((fArray2 = pDFPage.getBox("Bleed")) != null && !Arrays.equals((float[])object4, fArray2)) {
            this.a(jPanel, "PDFViewer.BleedBox", this.a(fArray2[2] - fArray2[0], fArray2[3] - fArray2[1]), gridBagConstraints, gridBagConstraints2);
        }
        if ((fArray = pDFPage.getBox("Art")) != null && !Arrays.equals((float[])object4, fArray)) {
            this.a(jPanel, "PDFViewer.ArtBox", this.a(fArray[2] - fArray[0], fArray[3] - fArray[1]), gridBagConstraints, gridBagConstraints2);
        }
        jPanel.add((Component)new JLabel(""), new GridBagConstraints(){
            {
                this.weighty = 1.0;
                this.gridheight = 0;
            }
        });
        return jPanel;
    }

    private String a(float f2, float f3) {
        if (Math.round(Math.min(f2, f3)) == 595 && Math.round(Math.max(f2, f3)) == 842) {
            return "A4 (210x297mm)";
        }
        if (Math.round(Math.min(f2, f3)) == 612 && Math.round(Math.max(f2, f3)) == 792) {
            return "Letter (8.5x11\")";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        String string = decimalFormat.format(f2 / 72.0f) + "x" + decimalFormat.format(f3 / 72.0f) + "\"   ";
        decimalFormat = new DecimalFormat("#0");
        string = string + decimalFormat.format((double)f2 / 2.8346457) + "x" + decimalFormat.format((double)f3 / 2.8346457) + "mm   ";
        string = string + decimalFormat.format(f2) + "x" + decimalFormat.format(f3) + "pt";
        return string;
    }

    private String a(long l2) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        DecimalFormat decimalFormat2 = new DecimalFormat("#,##0");
        if (l2 > 0x100000L) {
            return decimalFormat.format((double)l2 / 1048576.0) + "MB (" + decimalFormat2.format(l2) + " bytes)";
        }
        if (l2 > 1024L) {
            return decimalFormat.format((double)l2 / 1024.0) + "KB (" + decimalFormat2.format(l2) + " bytes)";
        }
        return decimalFormat2.format(l2) + " bytes";
    }

    public JComponent getStandardEncryptionPanel(PDF pDF) {
        StandardEncryptionHandler standardEncryptionHandler = (StandardEncryptionHandler)pDF.getEncryptionHandler();
        int n2 = standardEncryptionHandler.getChange();
        int n3 = standardEncryptionHandler.getPrint();
        int n4 = standardEncryptionHandler.getExtract();
        return this.a(n2, n3, n4, "PDFViewer.PasswordSecurity", standardEncryptionHandler.getDescription());
    }

    public JComponent getPublicKeyEncryptionPanel(PDF pDF) {
        PublicKeyEncryptionHandler publicKeyEncryptionHandler = (PublicKeyEncryptionHandler)pDF.getEncryptionHandler();
        int n2 = publicKeyEncryptionHandler.getChange();
        int n3 = publicKeyEncryptionHandler.getPrint();
        int n4 = publicKeyEncryptionHandler.getExtract();
        return this.a(n2, n3, n4, "PDFViewer.CertificateSecurity", null);
    }

    private JComponent a(int n2, int n3, int n4, String string, String string2) {
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        switch (n3) {
            case 0: {
                string8 = "PDFViewer.NotAllowed";
                break;
            }
            case 4: {
                string8 = "PDFViewer.LowResolution";
                break;
            }
            default: {
                string8 = "PDFViewer.Allowed";
            }
        }
        switch (n4) {
            case 0: {
                string7 = "PDFViewer.NotAllowed";
                string6 = "PDFViewer.NotAllowed";
                break;
            }
            case 512: {
                string7 = "PDFViewer.NotAllowed";
                string6 = "PDFViewer.Allowed";
                break;
            }
            default: {
                string7 = "PDFViewer.Allowed";
                string6 = "PDFViewer.Allowed";
            }
        }
        switch (n2) {
            case 0: {
                string5 = "PDFViewer.NotAllowed";
                string4 = "PDFViewer.NotAllowed";
                string3 = "PDFViewer.NotAllowed";
                break;
            }
            case 1024: {
                string5 = "PDFViewer.Allowed";
                string4 = "PDFViewer.NotAllowed";
                string3 = "PDFViewer.NotAllowed";
                break;
            }
            case 288: {
                string5 = "PDFViewer.NotAllowed";
                string4 = "PDFViewer.NotAllowed";
                string3 = "PDFViewer.Allowed";
                break;
            }
            case 256: {
                string5 = "PDFViewer.NotAllowed";
                string4 = "PDFViewer.Allowed";
                string3 = "PDFViewer.Allowed";
                break;
            }
            default: {
                string5 = "PDFViewer.Allowed";
                string4 = "PDFViewer.Allowed";
                string3 = "PDFViewer.Allowed";
            }
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 5, 4, 20);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        this.a(jPanel, "PDFViewer.Security", UIManager.getString(string), gridBagConstraints, gridBagConstraints2);
        if (string2 != null) {
            this.a(jPanel, "PDFViewer.Algorithm", string2, gridBagConstraints, gridBagConstraints2);
        }
        this.a(jPanel, "PDFViewer.Printing", UIManager.getString(string8), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.ChangingDocument", UIManager.getString(string5), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.ContentCopying", UIManager.getString(string7), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.ContentCopyingAcc", UIManager.getString(string6), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.Commenting", UIManager.getString(string3), gridBagConstraints, gridBagConstraints2);
        this.a(jPanel, "PDFViewer.FormFilling", UIManager.getString(string4), gridBagConstraints, gridBagConstraints2);
        jPanel.add((Component)new JLabel(""), new GridBagConstraints(){
            {
                this.weighty = 1.0;
                this.gridheight = 0;
            }
        });
        return jPanel;
    }

    public JComponent getProfilePanel(final PDF pDF) {
        final JPanel jPanel = new JPanel(new GridBagLayout());
        final JLabel jLabel = new JLabel(UIManager.getString("PDFViewer.Loading"));
        jPanel.add((Component)jLabel, new GridBagConstraints(){
            {
                this.fill = 0;
                this.anchor = 10;
            }
        });
        jPanel.setCursor(Cursor.getPredefinedCursor(3));
        new Thread(){

            public void run() {
                final OutputProfile outputProfile = pDF.getFullOutputProfile();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                        jPanel.remove(jLabel);
                        jPanel.setCursor(null);
                        jPanel.add(new JList(defaultListModel), new GridBagConstraints(){
                            {
                                this.fill = 1;
                                this.weighty = 1.0;
                                this.weightx = 1.0;
                                this.anchor = 18;
                            }
                        });
                        for (int i2 = 0; i2 < OutputProfile.Feature.ALL.length; ++i2) {
                            OutputProfile.Feature feature = OutputProfile.Feature.ALL[i2];
                            if (!outputProfile.isSet(feature)) continue;
                            defaultListModel.addElement("\u2022 " + feature);
                        }
                    }
                });
            }
        }.start();
        return jPanel;
    }
}

