/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.faceless.pdf2.Form;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.SignatureProvider;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class InvisiblySignDocument
extends ViewerWidget {
    public InvisiblySignDocument() {
        super("InvisiblySignDocument");
        this.setButton("Signatures", "resources/icons/pencil.png", "PDFViewer.InvisiblySignPDF");
    }

    public boolean isButtonEnabledByDefault() {
        return false;
    }

    public void initialize(final PDFViewer pDFViewer) {
        ViewerFeature[] viewerFeatureArray = pDFViewer.getFeatures();
        ArrayList<ViewerFeature> arrayList = new ArrayList<ViewerFeature>();
        FormSignature formSignature = this.createSignature();
        for (int i2 = 0; i2 < viewerFeatureArray.length; ++i2) {
            ViewerFeature viewerFeature = viewerFeatureArray[i2];
            if (!(viewerFeature instanceof SignatureProvider) || !((SignatureProvider)viewerFeature).canSign(formSignature)) continue;
            arrayList.add(viewerFeature);
        }
        if (arrayList.size() == 1) {
            this.setMenu("Document\tSignAndCertify\tInvisiblySignPDF");
            super.initialize(pDFViewer);
        } else {
            super.initialize(pDFViewer);
            for (ViewerFeature viewerFeature : arrayList) {
                ActionListener actionListener = new ActionListener((SignatureProvider)viewerFeature){
                    final /* synthetic */ SignatureProvider val$provider;
                    {
                        this.val$provider = signatureProvider;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPanel documentPanel = pDFViewer.getActiveDocumentPanel();
                        FormSignature formSignature = InvisiblySignDocument.this.a(documentPanel);
                        if (formSignature != null) {
                            try {
                                InvisiblySignDocument.this.sign(formSignature, documentPanel, this.val$provider);
                            }
                            catch (Exception exception) {
                                Util.displayThrowable(exception, documentPanel);
                                formSignature.getForm().getElements().remove(formSignature);
                            }
                        }
                    }
                };
                pDFViewer.setMenu("Document\tSignAndCertify\tInvisiblySignPDF\t" + ((SignatureProvider)viewerFeature).getDisplayName(), '\u0000', true, actionListener);
            }
        }
    }

    public void action(ViewerEvent viewerEvent) {
        JComponent jComponent = (JComponent)viewerEvent.getComponent();
        Point point = new Point(jComponent.getWidth() / 2, jComponent.getHeight() / 2);
        PDFViewer pDFViewer = viewerEvent.getViewer();
        final DocumentPanel documentPanel = pDFViewer.getActiveDocumentPanel();
        final FormSignature formSignature = this.a(documentPanel);
        SignatureProvider.selectSignProvider(documentPanel, formSignature, jComponent, point, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block7: {
                    SignatureProvider signatureProvider = (SignatureProvider)actionEvent.getSource();
                    try {
                        InvisiblySignDocument.this.sign(formSignature, documentPanel, signatureProvider);
                        if (formSignature.getState() == 1) break block7;
                        formSignature.getForm().getElements().values().remove(formSignature);
                    }
                    catch (Exception exception) {
                        try {
                            Util.displayThrowable(exception, documentPanel);
                            if (formSignature.getState() == 1) break block7;
                            formSignature.getForm().getElements().values().remove(formSignature);
                        }
                        catch (Throwable throwable) {
                            if (formSignature.getState() != 1) {
                                formSignature.getForm().getElements().values().remove(formSignature);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        });
    }

    protected FormSignature createSignature() {
        return new FormSignature();
    }

    private FormSignature a(DocumentPanel documentPanel) {
        FormElement formElement2;
        PDF pDF = documentPanel.getPDF();
        Form form = pDF.getForm();
        for (FormElement formElement2 : form.getElements().values()) {
            if (!(formElement2 instanceof FormSignature) || ((FormSignature)formElement2).getState() != 1) continue;
            JOptionPane.showMessageDialog(documentPanel, UIManager.getString("PDFViewer.PendingSignature"), UIManager.getString("PDFViewer.Alert"), 1);
            return null;
        }
        int n2 = 1;
        while (form.getElements().containsKey("Sig" + n2)) {
            ++n2;
        }
        formElement2 = this.createSignature();
        form.getElements().put("Sig" + n2, formElement2);
        return formElement2;
    }

    public void sign(FormSignature formSignature, DocumentPanel documentPanel, SignatureProvider signatureProvider) throws IOException, GeneralSecurityException {
        signatureProvider.showSignDialog(documentPanel, formSignature);
    }
}

