/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.faceless.pdf2.AcrobatSignatureHandlerFactory;
import org.faceless.pdf2.EGIZSignatureHandler;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.PKCS7SignatureHandler;
import org.faceless.pdf2.SignatureHandler;
import org.faceless.pdf2.SignatureHandlerFactory;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.KeyStoreManager;
import org.faceless.pdf2.viewer2.SignatureProvider;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.feature.SignatureCapture;
import org.faceless.pdf2.viewer2.util.DialogPanel;
import org.faceless.pdf2.viewer2.util.KeyStoreAliasList;

public class KeyStoreSignatureProvider
extends SignatureProvider {
    private KeyStoreManager c;
    private SignatureHandlerFactory d;

    public KeyStoreSignatureProvider() {
        super("KeyStoreSignatureProvider");
    }

    public String getDisplayName() {
        return "Local KeyStore";
    }

    public void setSignatureHandlerFactory(SignatureHandlerFactory signatureHandlerFactory) {
        this.d = signatureHandlerFactory;
    }

    protected SignatureHandlerFactory getSignatureHandlerFactory() {
        if (this.d != null) {
            return this.d;
        }
        AcrobatSignatureHandlerFactory acrobatSignatureHandlerFactory = new AcrobatSignatureHandlerFactory();
        if (this.getDefaultContentSize() != 0) {
            acrobatSignatureHandlerFactory.setContentSize(this.getDefaultContentSize());
        }
        if (this.getDefaultDigestAlgorithm() != null) {
            acrobatSignatureHandlerFactory.setDigestAlgorithm(this.getDefaultDigestAlgorithm());
        }
        if (this.getDefaultTimeStampServer() != null) {
            acrobatSignatureHandlerFactory.setTimeStampServer(this.getDefaultTimeStampServer());
        }
        return acrobatSignatureHandlerFactory;
    }

    public KeyStoreManager getKeyStoreManager() {
        return this.c == null ? this.getViewer().getKeyStoreManager() : this.c;
    }

    public void setKeyStoreManager(KeyStoreManager keyStoreManager) {
        this.c = keyStoreManager;
    }

    public boolean canSign(FormSignature formSignature) {
        return true;
    }

    public boolean canVerify(FormSignature formSignature) {
        return formSignature.getSignatureHandler() instanceof PKCS7SignatureHandler;
    }

    public String getDefaultAlias() {
        return this.getFeatureProperty(this.getViewer(), "alias");
    }

    public char[] getDefaultPassword() {
        String string = this.getFeatureProperty(this.getViewer(), "password");
        return string == null ? null : string.toCharArray();
    }

    public URL getDefaultTimeStampServer() {
        String string = this.getFeatureProperty(this.getViewer(), "timeStampServer");
        try {
            return new URL(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getDefaultDigestAlgorithm() {
        return this.getFeatureProperty(this.getViewer(), "digestAlgorithm");
    }

    public int getDefaultContentSize() {
        String string = this.getFeatureProperty(this.getViewer(), "contentSize");
        return string == null ? 0 : Integer.parseInt(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showSignDialog(JComponent jComponent, FormSignature formSignature) throws IOException, GeneralSecurityException {
        Object object;
        String string = this.getDefaultAlias();
        char[] cArray = this.getDefaultPassword();
        String string2 = this.getDefaultName();
        String string3 = this.getDefaultReason();
        String string4 = this.getDefaultLocation();
        int n2 = this.getDefaultCertificationType();
        final KeyStoreAliasList keyStoreAliasList = string == null ? new KeyStoreAliasList(this.getKeyStoreManager(), true, false) : null;
        DialogPanel dialogPanel = new DialogPanel(){

            public String validateDialog() {
                if (keyStoreAliasList != null && keyStoreAliasList.getSelectedValue() == null) {
                    return "Please choose a Key";
                }
                return null;
            }
        };
        JTextField jTextField = new JTextField(string2);
        JTextField jTextField2 = new JTextField(string3);
        JTextField jTextField3 = new JTextField(string4);
        JComboBox<String> jComboBox = null;
        JPasswordField jPasswordField = null;
        if (cArray == null) {
            jPasswordField = new JPasswordField();
        }
        if (string2 != null) {
            jTextField.setEditable(false);
        }
        if (string3 != null) {
            jTextField2.setEditable(false);
        }
        if (string4 != null) {
            jTextField3.setEditable(false);
        }
        if (formSignature.getForm().getPDF().getBasicOutputProfile().isSet(OutputProfile.Feature.DigitallySigned)) {
            n2 = 0;
        }
        if (n2 == -1) {
            String[] stringArray = new String[]{UIManager.getString("PDFViewer.cert.Uncertified"), UIManager.getString("PDFViewer.cert.NoChanges"), UIManager.getString("PDFViewer.cert.ModifyForms"), UIManager.getString("PDFViewer.cert.ModifyComments")};
            jComboBox = new JComboBox<String>(stringArray);
        }
        if (keyStoreAliasList != null) {
            JViewport jViewport = new JViewport();
            jViewport.add(keyStoreAliasList);
            dialogPanel.addComponent(jViewport);
        }
        if (jPasswordField != null) {
            dialogPanel.addComponent("Password", jPasswordField);
        }
        dialogPanel.addComponent("Name", jTextField);
        dialogPanel.addComponent("Reason", jTextField2);
        dialogPanel.addComponent("Location", jTextField3);
        if (jComboBox != null) {
            dialogPanel.addComponent("Certification", jComboBox);
        }
        if (string2 == null || string == null || string3 == null || string4 == null || cArray == null || n2 == -1) {
            if (!dialogPanel.showDialog(jComponent, UIManager.getString("PDFViewer.SignAndCertify"))) return;
        }
        if (keyStoreAliasList != null) {
            string = (String)keyStoreAliasList.getSelectedValue();
        }
        if (jPasswordField != null) {
            cArray = jPasswordField.getPassword();
        }
        if (jTextField != null) {
            string2 = jTextField.getText();
        }
        if (jTextField2 != null) {
            string3 = jTextField2.getText();
        }
        if (jTextField3 != null) {
            string4 = jTextField3.getText();
        }
        if (jComboBox != null) {
            n2 = jComboBox.getSelectedIndex();
        }
        Rectangle2D.Float float_ = this.a(formSignature);
        KeyStoreManager keyStoreManager = this.getKeyStoreManager();
        KeyStore keyStore = keyStoreManager.getKeyStore();
        SignatureHandlerFactory signatureHandlerFactory = this.getSignatureHandlerFactory();
        if (float_ != null && signatureHandlerFactory instanceof AcrobatSignatureHandlerFactory && (object = this.getSignatureAppearance(keyStoreManager, keyStore, string, float_.width, float_.height)) != null) {
            ((AcrobatSignatureHandlerFactory)signatureHandlerFactory).setCustomAppearance((PDFCanvas)object, float_.x, float_.y, float_.width, float_.height);
        }
        formSignature.sign(keyStore, string, cArray, signatureHandlerFactory);
        formSignature.setCertificationType(n2, null);
        if (string3.length() > 0) {
            formSignature.setReason(string3);
        }
        if (string4.length() > 0) {
            formSignature.setLocation(string4);
        }
        if (string2.length() == 0) {
            object = formSignature.getSignatureHandler();
            string2 = ((SignatureHandler)object).getDefaultName();
        }
        if (string2 == null) return;
        if (string2.length() <= 0) return;
        formSignature.setName(string2);
    }

    protected PDFCanvas getSignatureAppearance(KeyStoreManager keyStoreManager, KeyStore keyStore, String string, float f2, float f3) {
        block6: {
            String string2 = string + ".sigpath";
            try {
                SecretKey secretKey;
                if (!keyStore.containsAlias(string2) || (secretKey = keyStoreManager.getSecret(string2, "bfo.signaturepath", SignatureCapture.SECRETKEYPASSWORD)) == null) break block6;
                byte[] byArray = secretKey.getEncoded();
                if (byArray == null || byArray.length <= 0) break block6;
                Shape shape = SignatureCapture.readPath(byArray);
                if (shape != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    int n2 = 6;
                    PDFCanvas pDFCanvas = new PDFCanvas((float)rectangle2D.getWidth() + (float)n2 + (float)n2, (float)rectangle2D.getHeight() + (float)n2 + (float)n2);
                    PDFStyle pDFStyle = new PDFStyle();
                    pDFStyle.setLineColor(Color.black);
                    pDFCanvas.setStyle(pDFStyle);
                    double d2 = -rectangle2D.getMinX() + (double)n2;
                    double d3 = rectangle2D.getHeight() + rectangle2D.getMinY() + (double)n2;
                    shape = new AffineTransform(1.0, 0.0, 0.0, -1.0, d2, d3).createTransformedShape(shape);
                    pDFCanvas.drawShape(shape);
                    pDFCanvas.flush();
                    return pDFCanvas;
                }
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        return null;
    }

    private Rectangle2D.Float a(FormElement formElement) {
        Rectangle2D.Float float_ = null;
        List list = formElement.getAnnotations();
        if (list.size() > 0) {
            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(0);
            float[] fArray = pDFAnnotation.getRectangle();
            float_ = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2] - fArray[0], fArray[3] - fArray[1]);
        }
        return float_;
    }

    public SignatureProvider.SignatureState verify(JComponent jComponent, FormSignature formSignature) {
        Boolean bl;
        String string;
        Exception exception;
        X509Certificate x509Certificate;
        boolean bl2;
        block16: {
            boolean bl3 = false;
            bl2 = false;
            x509Certificate = null;
            exception = null;
            Calendar calendar = formSignature.getSignDate();
            string = null;
            bl = null;
            try {
                bl3 = formSignature.verify();
            }
            catch (Exception exception2) {
                bl = Boolean.FALSE;
                string = Util.getUIString("PDFViewer.ssig.ErrorVerifyingSig", exception2.toString());
                exception = exception2;
            }
            if (formSignature.getNumberOfRevisionsCovered() == 0) {
                bl = Boolean.FALSE;
                string = UIManager.getString("PDFViewer.ssig.NotEntireRevision");
            } else {
                try {
                    block17: {
                        block15: {
                            X509Certificate[] x509CertificateArray = null;
                            SignatureHandler signatureHandler = formSignature.getSignatureHandler();
                            if (signatureHandler instanceof PKCS7SignatureHandler) {
                                x509CertificateArray = ((PKCS7SignatureHandler)signatureHandler).getCertificates();
                            } else if (signatureHandler instanceof EGIZSignatureHandler) {
                                x509CertificateArray = ((EGIZSignatureHandler)signatureHandler).getCertificates();
                            }
                            if (x509CertificateArray != null) {
                                x509Certificate = FormSignature.verifyCertificates(x509CertificateArray, this.getKeyStoreManager().getKeyStore(), null, calendar);
                            }
                            if (formSignature.getNumberOfRevisionsCovered() != formSignature.getForm().getPDF().getNumberOfRevisions()) {
                                bl2 = true;
                            }
                            if (!bl3 || x509Certificate != null) break block15;
                            bl = Boolean.TRUE;
                            string = UIManager.getString("PDFViewer.ssig.DocAndCertVerified");
                            break block16;
                        }
                        if (!bl3 || x509Certificate == null) break block17;
                        bl = Boolean.TRUE;
                        string = UIManager.getString("PDFViewer.ssig.UnableToVerifyCerts");
                        break block16;
                    }
                    bl = Boolean.FALSE;
                    string = UIManager.getString("PDFViewer.ssig.AlteredSinceSigning");
                }
                catch (Exception exception3) {
                    bl = Boolean.FALSE;
                    string = Util.getUIString("PDFViewer.ssig.ErrorVerifyingCerts", exception3.getMessage());
                    exception = exception3;
                }
            }
        }
        return new X509SignatureState(formSignature, bl, string, bl2, exception, x509Certificate);
    }

    public void showVerifyDialog(JComponent jComponent, FormSignature formSignature) {
        Object object;
        X509Certificate[] x509CertificateArray;
        DocumentPanel documentPanel = (DocumentPanel)jComponent;
        X509SignatureState x509SignatureState = (X509SignatureState)KeyStoreSignatureProvider.getSignatureState(documentPanel, formSignature);
        if (x509SignatureState == null) {
            x509SignatureState = (X509SignatureState)this.verify(jComponent, formSignature);
            KeyStoreSignatureProvider.setSignatureState(documentPanel, formSignature, x509SignatureState);
        }
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Summary"), this.getSignatureStatePanel(x509SignatureState, documentPanel));
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Timestamp"), this.getTimestampPanel(x509SignatureState, documentPanel));
        try {
            x509CertificateArray = null;
            object = formSignature.getSignatureHandler();
            if (object instanceof PKCS7SignatureHandler) {
                x509CertificateArray = ((PKCS7SignatureHandler)object).getCertificates();
            } else if (object instanceof EGIZSignatureHandler) {
                x509CertificateArray = ((EGIZSignatureHandler)object).getCertificates();
            }
            if (x509CertificateArray != null) {
                jTabbedPane.addTab(UIManager.getString("PDFViewer.Certificates"), this.getCertificatesPanel(x509SignatureState, documentPanel, x509CertificateArray, x509SignatureState.getCertificate(), jTabbedPane));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        x509CertificateArray = new DialogPanel();
        x509CertificateArray.addButton("cancel", null, null, null);
        x509CertificateArray.addComponent(jTabbedPane);
        object = formSignature.getDescription();
        if (object == null) {
            object = formSignature.getForm().getName(formSignature);
        }
        x509CertificateArray.showDialog(documentPanel, (String)object);
    }

    protected JComponent getSignatureStatePanel(X509SignatureState x509SignatureState, DocumentPanel documentPanel) {
        JLabel jLabel;
        Object object;
        Object object2;
        String string;
        String string2;
        FormSignature formSignature;
        block13: {
            block15: {
                block10: {
                    block11: {
                        block14: {
                            block12: {
                                formSignature = x509SignatureState.getSignature();
                                if (x509SignatureState.getValidity() != null) break block12;
                                string2 = UIManager.getString("PDFViewer.ssig.UnknownValidity");
                                string = x509SignatureState.getReason();
                                break block13;
                            }
                            if (!x509SignatureState.getValidity().equals(Boolean.FALSE)) break block14;
                            string2 = UIManager.getString("PDFViewer.ssig.InvalidSignature");
                            string = x509SignatureState.getReason();
                            break block13;
                        }
                        int n2 = formSignature.getCertificationType();
                        if (n2 != 0) break block10;
                        if (!x509SignatureState.isAlteredSince()) break block11;
                        string2 = UIManager.getString("PDFViewer.ssig.ValidSignatureAlt");
                        break block15;
                    }
                    string2 = UIManager.getString("PDFViewer.ssig.ValidSignature");
                    break block15;
                }
                string2 = x509SignatureState.isAlteredSince() ? UIManager.getString("PDFViewer.ssig.DocumentCertifiedAlt") : UIManager.getString("PDFViewer.ssig.DocumentCertified");
            }
            if (x509SignatureState.getCertificate() != null) {
                object2 = "unknown";
                try {
                    object = FormSignature.getSubjectField(x509SignatureState.getCertificate(), "CN");
                    if (object == null) {
                        object = FormSignature.getSubjectField(x509SignatureState.getCertificate(), "O");
                    }
                    object2 = "\"" + (String)object + "\"";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = Util.getUIString("PDFViewer.ssig.SigNotCertVerified", (String)object2);
            } else {
                string = UIManager.getString("PDFViewer.ssig.SigCertBothVerified");
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        object2 = new GridBagConstraints();
        object = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object2).fill = 2;
        gridBagConstraints.fill = 2;
        ((GridBagConstraints)object).weighty = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        gridBagConstraints.gridx = 0;
        ((GridBagConstraints)object2).gridx = 0;
        gridBagConstraints.gridwidth = 3;
        ((GridBagConstraints)object2).gridwidth = 1;
        ((GridBagConstraints)object2).insets = new Insets(0, 0, 0, 20);
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridwidth = 0;
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setIcon(x509SignatureState.getIcon());
        jLabel2.setFont(new Font("SansSerif", 1, 14));
        jLabel2.setBorder(new EmptyBorder(0, 0, 12, 0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jLabel2 = new JLabel(string);
        jLabel2.setBorder(new EmptyBorder(0, 0, 12, 0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.Name")), object2);
        JPanel jPanel2 = jPanel;
        JLabel jLabel3 = jLabel;
        JLabel jLabel4 = jLabel;
        String string3 = formSignature.getName() == null ? "" : formSignature.getName();
        jLabel3(string3);
        jPanel2.add((Component)jLabel4, object);
        jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.Date")), object2);
        jPanel.add((Component)new JLabel(DateFormat.getDateTimeInstance(1, 1).format(formSignature.getSignDate().getTime())), object);
        jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.Revision")), object2);
        jPanel.add((Component)new JLabel(formSignature.getNumberOfRevisionsCovered() + " / " + formSignature.getForm().getPDF().getNumberOfRevisions()), object);
        jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.Reason")), object2);
        jPanel.add((Component)new JLabel(formSignature.getReason() == null ? UIManager.getString("PDFViewer.NotSpecified") : formSignature.getReason()), object);
        jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.Location")), object2);
        jPanel.add((Component)new JLabel(formSignature.getLocation() == null ? UIManager.getString("PDFViewer.NotSpecified") : formSignature.getLocation()), object);
        if (formSignature.getCertificationType() != 0) {
            String[] stringArray = new String[]{"cert.Uncertified", "cert.NoChanges", "cert.ModifyForms", "cert.ModifyComments"};
            jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.Certification")), object2);
            jPanel.add((Component)new JLabel(UIManager.getString(stringArray[formSignature.getCertificationType()])), object);
        }
        return jPanel;
    }

    protected JComponent getCertificatesPanel(final X509SignatureState x509SignatureState, final DocumentPanel documentPanel, final X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, final JTabbedPane jTabbedPane) throws CertificateException {
        JComponent jComponent;
        Object object;
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            object = FormSignature.getSubjectField(x509CertificateArray[i2], "CN");
            if (object == null) {
                object = FormSignature.getSubjectField(x509CertificateArray[i2], "O");
            }
            vector.add((String)object);
        }
        final JList jList = new JList(vector);
        object = new JScrollPane(jList);
        ((JComponent)object).setPreferredSize(new Dimension(200, 200));
        JPanel jPanel = new JPanel(new BorderLayout());
        final JScrollPane jScrollPane = new JScrollPane(new JPanel());
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jPanel.add((Component)jScrollPane, "Center");
        if (x509Certificate != null) {
            jComponent = new JButton(UIManager.getString("PDFViewer.ssig.TrustCertificate"));
            jComponent.addActionListener(new ActionListener((JButton)jComponent){
                final /* synthetic */ JButton val$trustbutton;
                {
                    this.val$trustbutton = jButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        KeyStoreManager keyStoreManager = KeyStoreSignatureProvider.this.getKeyStoreManager();
                        keyStoreManager.importCertificate(null, x509CertificateArray[jList.getSelectedIndex()]);
                        keyStoreManager.saveKeyStore();
                        X509SignatureState x509SignatureState2 = (X509SignatureState)KeyStoreSignatureProvider.this.verify(documentPanel, x509SignatureState.getSignature());
                        SignatureProvider.setSignatureState(documentPanel, x509SignatureState.getSignature(), x509SignatureState2);
                        jTabbedPane.setComponentAt(0, KeyStoreSignatureProvider.this.getSignatureStatePanel(x509SignatureState2, documentPanel));
                        this.val$trustbutton.setEnabled(false);
                    }
                    catch (Exception exception) {
                        Util.displayThrowable(exception, documentPanel);
                    }
                }
            });
            jPanel.add((Component)jComponent, "South");
        }
        jComponent = new JSplitPane(1, (Component)object, jPanel);
        jList.setSelectionMode(1);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jScrollPane.setViewportView(KeyStoreSignatureProvider.this.getCertificatePanel(x509CertificateArray[jList.getSelectedIndex()]));
            }
        });
        jList.setSelectedIndex(0);
        return jComponent;
    }

    protected JComponent getCertificatePanel(X509Certificate x509Certificate) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospace", 0, 9));
        jTextArea.setText(x509Certificate.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    protected JComponent getTimestampPanel(X509SignatureState x509SignatureState, DocumentPanel documentPanel) {
        JPanel jPanel;
        block8: {
            FormSignature formSignature = x509SignatureState.getSignature();
            jPanel = new JPanel(new BorderLayout());
            try {
                X509Certificate[] x509CertificateArray;
                Calendar calendar;
                block7: {
                    calendar = formSignature.getSignDate();
                    SignatureHandler signatureHandler = formSignature.getSignatureHandler();
                    x509CertificateArray = null;
                    if (signatureHandler instanceof PKCS7SignatureHandler) {
                        x509CertificateArray = ((PKCS7SignatureHandler)signatureHandler).getTimeStampCertificates();
                    }
                    if (x509CertificateArray != null) break block7;
                    jPanel.add((Component)new JLabel(UIManager.getString("PDFViewer.ssig.DateFromComputer")), "North");
                    break block8;
                }
                String string = null;
                X509Certificate x509Certificate = null;
                string = FormSignature.getSubjectField(x509CertificateArray[0], "CN");
                x509Certificate = FormSignature.verifyCertificates(x509CertificateArray, this.getKeyStoreManager().getKeyStore(), null, calendar);
                String string2 = x509Certificate == null ? Util.getUIString("PDFViewer.ssig.DateGuaranteedKnown", string) : Util.getUIString("PDFViewer.ssig.DateGuaranteedUnknown", string);
                jPanel.add((Component)new JLabel(string2), "North");
                try {
                    jPanel.add((Component)this.getCertificatesPanel(x509SignatureState, documentPanel, x509CertificateArray, x509Certificate, null), "Center");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                jPanel.add((Component)new JLabel(Util.getUIString("PDFViewer.ssig.ErrorVerifyingTimestamp", exception.getMessage())), "North");
            }
        }
        return jPanel;
    }

    public class X509SignatureState
    extends SignatureProvider.SignatureState {
        private final X509Certificate f;

        public X509SignatureState(FormSignature formSignature, Boolean bl, String string, boolean bl2, Exception exception, X509Certificate x509Certificate) {
            super(KeyStoreSignatureProvider.this, formSignature, bl, string, bl2, exception);
            this.f = x509Certificate;
        }

        public X509Certificate getCertificate() {
            return this.f;
        }
    }
}

