/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.viewer2.KeyStoreManager;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.ViewerWidget;
import org.faceless.pdf2.viewer2.feature.SignatureCapture;
import org.faceless.pdf2.viewer2.util.DialogPanel;
import org.faceless.pdf2.viewer2.util.KeyStoreAliasList;
import org.faceless.pdf2.viewer2.util.LongRunningTask;
import org.faceless.util.CombinedKeyStore;

public class ManageIdentities
extends ViewerWidget {
    private static final Pattern n = Pattern.compile("\\.(keystore|jks|p12|pfx|pkcs12)$");
    private static final Pattern o = Pattern.compile("\\.(cer|crt|pem)$");
    private static final Pattern p = Pattern.compile("\\.(jks|keystore)$");
    private static final Pattern q = Pattern.compile("\\.(p12|pfx|pkcs12)$");
    private KeyStoreManager r;

    public ManageIdentities() {
        super("ManageIdentities");
    }

    public void initialize(PDFViewer pDFViewer) {
        this.r = pDFViewer.getKeyStoreManager();
        this.setButton("Signatures", "resources/icons/user.png", "PDFViewer.tt.ManageIdentities");
        this.setMenu("Advanced\tManageIdentities");
        this.setDocumentRequired(false);
        super.initialize(pDFViewer);
    }

    public void action(ViewerEvent viewerEvent) {
        this.a(viewerEvent.getViewer());
    }

    private KeyStore a(Component component) {
        try {
            return this.r.getKeyStore();
        }
        catch (Exception exception) {
            Util.displayThrowable(exception, component);
            return null;
        }
    }

    private void a(final JComponent jComponent) {
        try {
            try {
                this.r.loadKeyStore();
            }
            catch (IOException iOException) {
                this.r.createKeyStore();
            }
            DialogPanel dialogPanel = new DialogPanel(this.r.isCancellable()){

                public void cancelDialog() {
                    super.cancelDialog();
                    ManageIdentities.this.r.cancelKeyStore();
                }

                public void acceptDialog() {
                    try {
                        block5: {
                            if (ManageIdentities.this.r.isChanged()) {
                                try {
                                    ManageIdentities.this.r.saveKeyStore();
                                }
                                catch (Exception exception) {
                                    Util.displayThrowable(exception, jComponent);
                                    if (ManageIdentities.this.r.saveKeyStore(jComponent)) break block5;
                                    return;
                                }
                            }
                        }
                        super.acceptDialog();
                    }
                    catch (Exception exception) {
                        Util.displayThrowable(exception, jComponent);
                    }
                }
            };
            final JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.b(jComponent));
            dialogPanel.setButtonText("ok", UIManager.getString("PDFViewer.Save"));
            dialogPanel.addComponent(jPanel);
            if (this.r.isFileBased()) {
                dialogPanel.addButton(UIManager.getString("PDFViewer.ReloadFile"), null, new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            if (ManageIdentities.this.r.loadKeyStore(jComponent)) {
                                jPanel.remove(0);
                                jPanel.add(ManageIdentities.this.b(jComponent));
                                jPanel.validate();
                            }
                        }
                        catch (Exception exception) {
                            Util.displayThrowable(exception, jComponent);
                        }
                    }
                });
            }
            dialogPanel.showDialog(jComponent, UIManager.getString("PDFViewer.ManageIdentities"));
        }
        catch (GeneralSecurityException generalSecurityException) {
            Util.displayThrowable(generalSecurityException, jComponent);
        }
    }

    private JComponent b(JComponent jComponent) throws KeyStoreException {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(1);
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Keys"), null, this.a(jComponent, 0, true, true));
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Contacts"), null, this.a(jComponent, 1, true, true));
        jTabbedPane.addTab(UIManager.getString("PDFViewer.Authorities"), null, this.a(jComponent, 2, true, true));
        return jTabbedPane;
    }

    private JComponent a(final JComponent jComponent, final int n2, boolean bl, final boolean bl2) throws KeyStoreException {
        KeyStoreAliasList keyStoreAliasList;
        JSplitPane jSplitPane;
        block5: {
            JPanel jPanel;
            JPanel jPanel2;
            block4: {
                block3: {
                    KeyStore keyStore = this.a((Component)jComponent);
                    jSplitPane = new JSplitPane();
                    jPanel2 = new JPanel(new BorderLayout());
                    jPanel2.setMinimumSize(new Dimension(200, 200));
                    jSplitPane.setTopComponent(jPanel2);
                    keyStoreAliasList = new KeyStoreAliasList(false, false){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public boolean isDisplayed(KeyStore keyStore, String string) {
                            try {
                                if (n2 == 0) {
                                    return keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class);
                                }
                                if (!keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) return false;
                                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                                if ((x509Certificate.getVersion() == 3 && x509Certificate.getBasicConstraints() == -1) != (n2 == 1)) return false;
                                return true;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return false;
                            }
                        }
                    };
                    keyStoreAliasList.setKeyStoreManager(this.r);
                    keyStoreAliasList.addListSelectionListener(new ListSelectionListener(){

                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            jSplitPane.setBottomComponent(ManageIdentities.this.a(jComponent, keyStoreAliasList, bl2));
                        }
                    });
                    JScrollPane jScrollPane = new JScrollPane(keyStoreAliasList);
                    jPanel2.add((Component)jScrollPane, "Center");
                    if (!bl) break block5;
                    jPanel = new JPanel(new FlowLayout(2));
                    if (n2 != 0) break block3;
                    if (!this.r.canCreateSelfSignedCertificate()) break block4;
                    JButton jButton = new JButton(UIManager.getString("PDFViewer.New"));
                    jButton.setMnemonic(78);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                ManageIdentities.this.a(jComponent, keyStoreAliasList, null);
                            }
                            catch (Exception exception) {
                                Util.displayThrowable(exception, jComponent);
                            }
                        }
                    });
                    jPanel.add(jButton);
                    jButton = new JButton(UIManager.getString("PDFViewer.Import"));
                    jButton.setMnemonic(73);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                ManageIdentities.this.c(jComponent);
                            }
                            catch (Exception exception) {
                                Util.displayThrowable(exception, jComponent);
                            }
                        }
                    });
                    jPanel.add(jButton);
                    break block4;
                }
                if (Util.hasFilePermission()) {
                    JButton jButton = new JButton(UIManager.getString("PDFViewer.Import"));
                    jButton.setMnemonic(73);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                ManageIdentities.this.a(jComponent, keyStoreAliasList);
                            }
                            catch (Exception exception) {
                                Util.displayThrowable(exception, jComponent);
                            }
                        }
                    });
                    jPanel.add(jButton);
                }
            }
            jPanel2.add((Component)jPanel, "South");
        }
        jSplitPane.setBottomComponent(this.a(jComponent, (JList)keyStoreAliasList, bl2));
        return jSplitPane;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JComponent a(final JComponent jComponent, final JList jList, boolean bl) {
        Object object;
        Object object2;
        Serializable secretKey;
        Object object22;
        final KeyStore keyStore = this.a((Component)jComponent);
        final String string = jList.getSelectedIndex() == -1 ? null : (String)jList.getSelectedValue();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Color.white);
        jPanel2.setOpaque(true);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        Certificate[] certificateArray = null;
        JComponent jComponent2 = null;
        if (string != null) {
            try {
                keyStore.getCertificateChain(string);
                if (certificateArray == null) {
                    certificateArray = new Certificate[]{keyStore.getCertificate(string)};
                }
                if (certificateArray == null || certificateArray.length == 0 || !(certificateArray[0] instanceof X509Certificate)) {
                    throw new GeneralSecurityException("No X.509 Certificate for Alias \"" + string + "\"");
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                Util.displayThrowable(generalSecurityException, jComponent);
            }
            try {
                object22 = string + ".sigpath";
                if (keyStore.containsAlias((String)object22) && (secretKey = this.r.getSecret((String)object22, "bfo.signaturepath", SignatureCapture.SECRETKEYPASSWORD)) != null && (object2 = secretKey.getEncoded()) != null && ((byte[])object2).length > 0 && (object = SignatureCapture.readPath((byte[])object2)) != null) {
                    jComponent2 = SignatureCapture.getPathComponent((GeneralPath)object);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                Util.displayThrowable(generalSecurityException, jComponent);
            }
        }
        Object object3 = object22 = certificateArray == null ? null : (X509Certificate)certificateArray[0];
        if (string != null) {
            try {
                Object object4;
                String[] stringArray;
                Object object5;
                int n2;
                String string2;
                int n3 = 0;
                n3 = this.a(jPanel2, "PDFViewer.Alias", string, jComponent2, n3);
                object2 = null;
                object = FormSignature.getSubjectField((X509Certificate)object22, "CN");
                if (object != null && ((String)object).length() > 0) {
                    n3 = this.a(jPanel2, "PDFViewer.Name", (String)object, jComponent2 == null ? null : "RELATIVE", n3);
                    if (object2 == null) {
                        object2 = object;
                    }
                }
                if ((object = FormSignature.getSubjectField((X509Certificate)object22, "O")) != null && ((String)object).length() > 0) {
                    n3 = this.a(jPanel2, "PDFViewer.Organization", (String)object, null, n3);
                    if (object2 == null) {
                        object2 = object;
                    }
                }
                if ((object = FormSignature.getSubjectField((X509Certificate)object22, "OU")) != null && ((String)object).length() > 0) {
                    n3 = this.a(jPanel2, "PDFViewer.OrgUnit", (String)object, null, n3);
                    if (object2 == null) {
                        object2 = object;
                    }
                }
                if ((object = FormSignature.getSubjectField((X509Certificate)object22, "L")) == null) {
                    object = "";
                }
                if ((string2 = FormSignature.getSubjectField((X509Certificate)object22, "ST")) != null && string2.length() > 0) {
                    if (((String)object).length() > 0) {
                        object = (String)object + ", ";
                    }
                    object = (String)object + string2;
                }
                if ((string2 = FormSignature.getSubjectField((X509Certificate)object22, "C")) != null && string2.length() > 0) {
                    if (((String)object).length() > 0) {
                        object = (String)object + ", ";
                    }
                    object = (String)object + string2;
                }
                if (((String)object).length() > 0) {
                    n3 = this.a(jPanel2, "PDFViewer.Location", (String)object, null, n3);
                }
                object = this.a(((X509Certificate)object22).getNotBefore());
                object = (String)object + "  -  ";
                object = (String)object + this.a(((X509Certificate)object22).getNotAfter());
                try {
                    ((X509Certificate)object22).checkValidity();
                    n3 = this.a(jPanel2, "PDFViewer.Validity", (String)object, null, n3);
                }
                catch (Exception exception) {
                    n3 = this.a(jPanel2, "PDFViewer.Expired", (String)object, "red", n3);
                }
                boolean exception = true;
                for (n2 = 0; n2 < certificateArray.length; ++n2) {
                    object5 = (X509Certificate)certificateArray[n2];
                    if (((Object)((X509Certificate)object5).getIssuerDN()).equals(((X509Certificate)object5).getSubjectDN())) continue;
                    object = "";
                    stringArray = new String[]{"CN", "OU", "O", "L", "ST", "C"};
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        object4 = FormSignature.getIssuerField((X509Certificate)object5, stringArray[i2]);
                        if (object4 == null || ((String)object4).length() <= 0) continue;
                        if (((String)object).length() > 0) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + (String)object4;
                    }
                    if (exception) {
                        n3 = this.a(jPanel2, "", "", null, n3);
                        exception = false;
                    }
                    n3 = this.a(jPanel2, "PDFViewer.IssuedBy", (String)object, null, n3);
                }
                n2 = n3;
                jPanel2.add((Component)new JLabel(), new GridBagConstraints(){
                    {
                        this.weighty = 1.0;
                        this.weightx = 1.0;
                        this.gridy = n2;
                        this.gridheight = 0;
                        this.gridwidth = 0;
                    }
                });
                if (bl) {
                    CombinedKeyStore combinedKeyStore;
                    object5 = this.getViewer().getFeature("SignatureCapture");
                    if (object5 != null && this.r.canStoreSecretKeysOnConversion()) {
                        stringArray = new JButton(UIManager.getString("PDFViewer.CaptureSignature"));
                        stringArray.setMnemonic(65);
                        String i2 = string + ".sigpath";
                        stringArray.addActionListener(new ActionListener((ViewerFeature)object5, keyStore, i2, jComponent, jPanel3, jList, bl){
                            final /* synthetic */ ViewerFeature val$capturefeature;
                            final /* synthetic */ KeyStore val$keystore;
                            final /* synthetic */ String val$pathalias;
                            final /* synthetic */ JComponent val$root;
                            final /* synthetic */ JPanel val$pane;
                            final /* synthetic */ JList val$list;
                            final /* synthetic */ boolean val$management;
                            {
                                this.val$capturefeature = viewerFeature;
                                this.val$keystore = keyStore;
                                this.val$pathalias = string;
                                this.val$root = jComponent;
                                this.val$pane = jPanel;
                                this.val$list = jList;
                                this.val$management = bl;
                            }

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    JLabel jLabel;
                                    boolean bl;
                                    GeneralPath generalPath = ((SignatureCapture)this.val$capturefeature).capture(300, 50);
                                    if (generalPath == null) return;
                                    byte[] byArray = SignatureCapture.writePath(generalPath);
                                    boolean bl2 = bl = byArray == null || byArray.length == 0;
                                    if (bl) {
                                        if (!this.val$keystore.containsAlias(this.val$pathalias)) return;
                                    }
                                    JComponent jComponent = bl ? null : SignatureCapture.getPathComponent(generalPath);
                                    DialogPanel dialogPanel = new DialogPanel();
                                    JPanel jPanel = new JPanel(new BorderLayout());
                                    jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                                    if (bl) {
                                        jLabel = new JLabel("<html>" + UIManager.getString("PDFViewer.ConfirmSignaturePathDelete") + "</html>");
                                    } else {
                                        jComponent.setBorder(BorderFactory.createEtchedBorder());
                                        jPanel.add(jComponent);
                                        jLabel = ManageIdentities.this.r.canStoreSecretKeys() ? new JLabel("<html>" + UIManager.getString("PDFViewer.ConfirmSignaturePathStore") + "</html>") : new JLabel("<html>" + UIManager.getString("PDFViewer.ConfirmSignaturePathConvert") + "</html>");
                                        dialogPanel.setPreferredSize(new Dimension(320, 200));
                                    }
                                    jPanel.add((Component)jLabel, "South");
                                    dialogPanel.addComponent(jPanel);
                                    if (!dialogPanel.showDialog(this.val$root, UIManager.getString("PDFViewer.CreateDigitalIdentity"))) return;
                                    try {
                                        if (bl) {
                                            ManageIdentities.this.r.putSecret(this.val$pathalias, null, SignatureCapture.SECRETKEYPASSWORD);
                                        } else {
                                            ManageIdentities.this.r.putSecret(this.val$pathalias, new SecretKeySpec(byArray, "bfo.signaturepath"), SignatureCapture.SECRETKEYPASSWORD);
                                        }
                                        ((JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, this.val$pane)).setBottomComponent(ManageIdentities.this.a(this.val$root, this.val$list, this.val$management));
                                        return;
                                    }
                                    catch (Exception exception) {
                                        Util.displayThrowable(exception, this.val$root);
                                        return;
                                    }
                                }
                                catch (Exception exception) {
                                    Util.displayThrowable(exception, this.val$root);
                                }
                            }
                        });
                        jPanel.add((Component)stringArray);
                    }
                    stringArray = new JButton(UIManager.getString("PDFViewer.Delete"));
                    stringArray.setMnemonic(68);
                    stringArray.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (JOptionPane.showConfirmDialog(jComponent, UIManager.getString("PDFViewer.ConfirmDeleteText"), UIManager.getString("PDFViewer.Confirm"), 0) == 0) {
                                try {
                                    ManageIdentities.this.r.deleteEntry(string);
                                    jList.clearSelection();
                                }
                                catch (Exception exception) {
                                    Util.displayThrowable(exception, jComponent);
                                }
                            }
                        }
                    });
                    jPanel.add((Component)stringArray);
                    if (keyStore instanceof CombinedKeyStore && (combinedKeyStore = (CombinedKeyStore)keyStore).isReadOnly(string)) {
                        stringArray.setEnabled(false);
                    }
                    JButton combinedKeyStore2 = new JButton(UIManager.getString("PDFViewer.Export"));
                    combinedKeyStore2.setMnemonic(69);
                    object4 = object2;
                    combinedKeyStore2.addActionListener(new ActionListener((String)object4){
                        final /* synthetic */ String val$fname;
                        {
                            this.val$fname = string;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                ManageIdentities.this.a(jComponent, keyStore, (String)jList.getSelectedValue(), this.val$fname);
                            }
                            catch (Exception exception) {
                                Util.displayThrowable(exception, jComponent);
                            }
                        }
                    });
                    jPanel.add(combinedKeyStore2);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                Util.displayThrowable(generalSecurityException, jComponent);
            }
        }
        secretKey = new JButton(UIManager.getString("PDFViewer.ShowCertificate"));
        ((AbstractButton)secretKey).setMnemonic(83);
        ((AbstractButton)secretKey).addActionListener(new ActionListener((X509Certificate)object22){
            final /* synthetic */ X509Certificate val$cert;
            {
                this.val$cert = x509Certificate;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                final JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(jComponent), UIManager.getString("PDFViewer.DigitalIdentities"), true);
                JTextArea jTextArea = new JTextArea();
                jTextArea.setFont(new Font("Monospace", 0, 9));
                jTextArea.setText(this.val$cert.toString());
                jTextArea.setEditable(false);
                jTextArea.setCaretPosition(0);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setPreferredSize(new Dimension(500, 300));
                JPanel jPanel = new JPanel(new FlowLayout(2));
                JButton jButton = new JButton(UIManager.getString("PDFViewer.OK"));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                });
                jPanel.add(jButton);
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.add((Component)jScrollPane, "Center");
                jPanel2.add((Component)jPanel, "South");
                jDialog.setContentPane(jPanel2);
                jDialog.setResizable(true);
                jDialog.pack();
                jDialog.setLocationRelativeTo(jComponent);
                jDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        jDialog.dispose();
                    }
                });
                jDialog.setVisible(true);
            }
        });
        ((AbstractButton)secretKey).setEnabled(string != null);
        jPanel.add((Component)secretKey);
        object2 = new JScrollPane(jPanel2);
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        jPanel3.setMinimumSize(new Dimension(400, 200));
        jPanel3.setPreferredSize(new Dimension(400, 300));
        jPanel3.add((Component)object2, "Center");
        jPanel3.add((Component)jPanel, "South");
        return jPanel3;
    }

    private int a(JComponent jComponent, String string, String string2, Object object, int n2) {
        JLabel jLabel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel2 = new JLabel(UIManager.getString(string));
        jComponent.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setOpaque(false);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 8));
        if (object instanceof JComponent) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jLabel = new JLabel("<html>" + string2 + "</html>");
            jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            jLabel.setForeground(new Color(0x606060, false));
            jComponent.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridheight = 2;
            jComponent.add((Component)((JComponent)object), gridBagConstraints);
        } else {
            block7: {
                block6: {
                    gridBagConstraints.gridwidth = "RELATIVE".equals(object) ? 1 : 2;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    jLabel = new JLabel("<html>" + string2 + "</html>");
                    jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                    if (!"red".equals(object)) break block6;
                    jLabel.setForeground(Color.red);
                    break block7;
                }
                jLabel.setForeground(new Color(0x606060, false));
            }
            jComponent.add((Component)jLabel, gridBagConstraints);
        }
        return ++n2;
    }

    private String a(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd MMM yyyy");
        SimpleDateFormat simpleDateFormat3 = Math.abs(date.getTime() - System.currentTimeMillis()) > 1209600000L ? simpleDateFormat2 : simpleDateFormat;
        return simpleDateFormat3.format(date);
    }

    void c(JComponent jComponent) throws GeneralSecurityException, IOException {
        KeyStoreManager keyStoreManager = new KeyStoreManager(this.getViewer());
        if (keyStoreManager.loadKeyStore(jComponent)) {
            Object object;
            boolean bl = false;
            final KeyStoreAliasList keyStoreAliasList = new KeyStoreAliasList(keyStoreManager, true, false);
            if (keyStoreAliasList.getModel().getSize() == 1) {
                try {
                    object = keyStoreManager.getParameter("password");
                    KeyStoreManager keyStoreManager2 = this.r;
                    KeyStore keyStore = keyStoreManager.getKeyStore();
                    String string = (String)keyStoreAliasList.getModel().getElementAt(0);
                    char[] cArray = object == null ? null : ((String)object).toCharArray();
                    keyStoreManager2.importPrivateKey(keyStore, string, cArray);
                    bl = true;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (!bl) {
                object = new JPasswordField();
                if (keyStoreManager.getParameter("password") != null) {
                    ((JPasswordField)object).setText(keyStoreManager.getParameter("password"));
                }
                DialogPanel dialogPanel = new DialogPanel((JPasswordField)object){
                    final /* synthetic */ JPasswordField val$password;
                    {
                        this.val$password = jPasswordField;
                    }

                    public String validateDialog() {
                        try {
                            KeyStore keyStore = keyStoreAliasList.getKeyStoreManager().getKeyStore();
                            keyStore.getKey((String)keyStoreAliasList.getSelectedValue(), this.val$password.getPassword());
                            return null;
                        }
                        catch (Exception exception) {
                            return UIManager.getString("PDFViewer.WrongPassword");
                        }
                    }
                };
                JViewport jViewport = new JViewport();
                keyStoreAliasList.setSelectedIndex(0);
                jViewport.add(keyStoreAliasList);
                dialogPanel.addComponent(jViewport);
                dialogPanel.addComponent(UIManager.getString("PDFViewer.Password"), (JComponent)object);
                if (dialogPanel.showDialog(jComponent)) {
                    try {
                        this.r.importPrivateKey(keyStoreManager.getKeyStore(), (String)keyStoreAliasList.getSelectedValue(), ((JPasswordField)object).getPassword());
                    }
                    catch (Exception exception) {
                        Util.displayThrowable(exception, jComponent);
                    }
                }
            }
        }
    }

    private void a(Component component, JList jList) throws GeneralSecurityException, IOException {
        JFileChooser jFileChooser = new JFileChooser((File)null);
        jFileChooser.addChoosableFileFilter(KeyStoreManager.FILTER_CERTIFICATE);
        jFileChooser.addChoosableFileFilter(KeyStoreManager.FILTER_KEYSTORE);
        jFileChooser.setFileFilter(KeyStoreManager.FILTER_CERTIFICATE);
        if (jFileChooser.showOpenDialog(component) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.r.importAllCertificates(file, file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(JComponent jComponent, KeyStore keyStore, String string, String string2) throws GeneralSecurityException, IOException {
        JFileChooser jFileChooser = new JFileChooser((File)null);
        if (string2 != null) {
            string2 = string2.replaceAll("[.,\"';:/\\ ]", "") + ".cer";
            jFileChooser.setSelectedFile(new File(string2));
        }
        jFileChooser.addChoosableFileFilter(KeyStoreManager.FILTER_CERTIFICATE);
        if (keyStore.isKeyEntry(string)) {
            jFileChooser.addChoosableFileFilter(KeyStoreManager.FILTER_KEYSTORE_PKCS12);
        }
        jFileChooser.setFileFilter(KeyStoreManager.FILTER_CERTIFICATE);
        if (jFileChooser.showSaveDialog(jComponent) != 0) return;
        File file = jFileChooser.getSelectedFile();
        boolean bl = jFileChooser.getFileFilter().accept(new File("test.p12"));
        if (bl) {
            JPasswordField jPasswordField = new JPasswordField(10);
            if (this.r.getParameter("password") != null) {
                jPasswordField.setText(this.r.getParameter("password"));
            }
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(UIManager.getString("PDFViewer.Password")));
            jPanel.add(jPasswordField);
            int n2 = JOptionPane.showConfirmDialog(null, jPanel, UIManager.getString("PDFViewer.Password"), 2, -1);
            if (n2 != 0) return;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    this.r.exportPKCS12Certificate(fileOutputStream, string, jPasswordField.getPassword());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    JOptionPane.showMessageDialog(null, UIManager.getString("PDFViewer.WrongPassword"));
                    Object var14_14 = null;
                    if (fileOutputStream == null) return;
                    ((OutputStream)fileOutputStream).close();
                    return;
                }
                Object var14_13 = null;
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.r.exportCertificate(fileOutputStream, string);
            Object var16_18 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (fileOutputStream == null) throw throwable;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private void a(Component component, JList jList, final String string) throws GeneralSecurityException, IOException {
        String[] stringArray = new String[]{"AF", "AL", "DZ", "AS", "AD", "AO", "AI", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BA", "BW", "BR", "VG", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FJ", "FI", "FR", "GF", "PF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GD", "GP", "GU", "GT", "GN", "GW", "GY", "HT", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "AN", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PA", "PG", "PY", "PE", "PH", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SK", "SI", "SB", "SO", "ZA", "ES", "LK", "KN", "LC", "VC", "SD", "SR", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "VI", "UG", "UA", "AE", "GB", "US", "UY", "UZ", "VU", "VE", "VN", "YE", "ZM", "ZW"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, UIManager.getString("iso3166." + object), n2, bl, bl2);
            }
        });
        try {
            jComboBox.setSelectedItem(Locale.getDefault().getCountry().toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JTextField jTextField = new JTextField();
        final JTextField jTextField2 = new JTextField();
        final JTextField jTextField3 = new JTextField();
        final JTextField jTextField4 = new JTextField();
        final JTextField jTextField5 = new JTextField();
        final JPasswordField jPasswordField = new JPasswordField();
        final JPasswordField jPasswordField2 = new JPasswordField();
        DialogPanel dialogPanel = new DialogPanel(){

            public String validateDialog() {
                if ((jTextField.getText().trim() + jTextField2.getText().trim() + jTextField3.getText().trim()).length() == 0) {
                    return UIManager.getString("PDFViewer.OneNameRequired");
                }
                if ((jTextField.getText() + jTextField2.getText() + jTextField3.getText() + jTextField4.getText() + jTextField5.getText()).indexOf("\"") >= 0) {
                    return Util.getUIString("PDFViewer.InvalidWhy", "No \" allowed in Name");
                }
                if (!Arrays.equals(jPasswordField.getPassword(), jPasswordField2.getPassword())) {
                    return UIManager.getString("PDFViewer.PasswordMismatch");
                }
                if (jPasswordField.getPassword().length == 0) {
                    return UIManager.getString("PDFViewer.ChoosePassword");
                }
                return null;
            }
        };
        dialogPanel.addComponent(UIManager.getString("PDFViewer.Name"), jTextField);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.OrgUnit"), jTextField2);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.Organization"), jTextField3);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.City"), jTextField4);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.State"), jTextField5);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.Country"), jComboBox);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.Password"), jPasswordField);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.ConfirmPassword"), jPasswordField2);
        if (dialogPanel.showDialog(component, UIManager.getString("PDFViewer.CreateDigitalIdentity"))) {
            LongRunningTask longRunningTask = new LongRunningTask(){

                public boolean isCancellable() {
                    return false;
                }

                public float getProgress() {
                    return 0.5f;
                }

                public void run() throws GeneralSecurityException {
                    ManageIdentities.this.r.createSelfSignedKey(string, jTextField.getText(), jTextField2.getText(), jTextField3.getText(), jTextField4.getText(), jTextField5.getText(), (String)jComboBox.getSelectedItem(), jPasswordField.getPassword(), 730);
                }
            };
            longRunningTask.start((JComponent)component, UIManager.getString("PDFViewer.CreateDigitalIdentity"), true);
        }
    }
}

