/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.Exporter;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;
import org.faceless.pdf2.viewer2.util.DialogPanel;
import org.faceless.pdf2.viewer2.util.LongRunningTask;
import org.faceless.util.Base64;
import org.faceless.util.CountingOutputStream;

public class NetworkSave
extends ViewerWidget
implements DocumentPanelListener {
    private int n;
    private int o;
    private URL p;
    private String q;
    private String r;
    private String s;
    private String t;

    public NetworkSave() {
        super("NetworkSave");
        this.setButton("Document", "resources/icons/drive_network.png", "PDFViewer.tt.Save");
        this.setMenu("File\tSave to Network", 's');
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
        String string = this.getFeatureProperty(pDFViewer, "timeout");
        if (string != null) {
            this.setTimeout(Integer.parseInt(string));
        }
        if ((string = this.getFeatureProperty(pDFViewer, "readTimeout")) != null) {
            this.setReadTimeout(Integer.parseInt(string));
        }
        if ((string = this.getFeatureProperty(pDFViewer, "url")) != null) {
            try {
                this.setURL(new URL(string));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if ((string = this.getFeatureProperty(pDFViewer, "premessage")) != null) {
            this.setPreMessage(string);
        }
        if ((string = this.getFeatureProperty(pDFViewer, "postmessage")) != null) {
            this.setPostMessage(string);
        }
        if ((string = this.getFeatureProperty(pDFViewer, "fieldname")) != null) {
            this.setFieldName(string);
        }
        if ((string = this.getFeatureProperty(pDFViewer, "filename")) == null) return;
        this.setFileName(string);
    }

    public void setTimeout(int n2) {
        this.n = n2;
    }

    public void setReadTimeout(int n2) {
        this.o = n2;
    }

    public void setURL(URL uRL) {
        this.p = uRL;
    }

    public void setPreMessage(String string) {
        this.q = string;
    }

    public void setPostMessage(String string) {
        this.r = string;
    }

    public void setFieldName(String string) {
        this.s = string;
    }

    public void setFileName(String string) {
        this.t = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (documentPanelEvent.getType() != "activated") return;
        if (documentPanelEvent.getDocumentPanel().getPDF() == null) return;
        EncryptionHandler encryptionHandler = documentPanelEvent.getDocumentPanel().getPDF().getEncryptionHandler();
        boolean bl = encryptionHandler == null || encryptionHandler.hasRight("Save");
        JComponent jComponent = documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("ButtonNetworkSave");
        if (jComponent != null) {
            jComponent.setEnabled(bl);
        }
        if ((jComponent = documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("MenuNetworkSave")) == null) return;
        jComponent.setEnabled(bl);
    }

    public void action(ViewerEvent viewerEvent) {
        this.save(viewerEvent, null, this.p);
    }

    public void save(final ViewerEvent viewerEvent, final Exporter exporter, final URL uRL) {
        if (uRL == null) {
            throw new IllegalStateException("No URL specified");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl;
                Object object;
                JComponent jComponent;
                final DocumentPanel documentPanel = viewerEvent.getDocumentPanel();
                PDFViewer pDFViewer = viewerEvent.getViewer();
                JComponent jComponent2 = jComponent = exporter == null ? null : exporter.getComponent();
                if (NetworkSave.this.q != null && JOptionPane.showConfirmDialog(null, NetworkSave.this.q, UIManager.getString("PDFViewer.Save"), 2) == 2) {
                    return null;
                }
                if (jComponent != null) {
                    object = new DialogPanel(){

                        public String validateDialog() {
                            return exporter.validateComponent(jComponent);
                        }
                    };
                    jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    ((DialogPanel)object).addComponent(jComponent);
                    ((DialogPanel)object).setButtonText("ok", UIManager.getString("PDFViewer.Save"));
                    bl = ((DialogPanel)object).showDialog(pDFViewer, Util.getUIString("PDFViewer.SavingFile", "PDF"));
                } else {
                    bl = true;
                }
                if (bl) {
                    object = new LongRunningTask(true, 1000){
                        volatile int i;
                        volatile CountingOutputStream j;
                        volatile HttpURLConnection k;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() throws IOException {
                            PDF pDF = documentPanel.getPDF();
                            this.k = (HttpURLConnection)uRL.openConnection();
                            this.k.setUseCaches(false);
                            try {
                                this.k.setConnectTimeout(NetworkSave.this.n);
                                this.k.setReadTimeout(NetworkSave.this.o);
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                // empty catch block
                            }
                            this.k.setInstanceFollowRedirects(true);
                            this.k.setRequestProperty("User-Agent", "Mozilla/4.0 (" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + ") BFOPDF/" + PDF.VERSION + " Java/" + System.getProperty("java.version"));
                            if (uRL.getUserInfo() != null) {
                                this.k.setRequestProperty("Authorization", "Basic " + Base64.encode(uRL.getUserInfo().getBytes("ISO-8859-1")));
                            }
                            this.k.setRequestMethod("POST");
                            this.k.setDoOutput(true);
                            this.k.setRequestProperty("Connection", "close");
                            if (documentPanel.getClientProperty("File") != null) {
                                this.k.setRequestProperty("X-BFOPDF-File", documentPanel.getClientProperty("file").toString());
                            }
                            NetworkSave.this.setAdditionalHeaders(this.k, documentPanel);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            if (NetworkSave.this.s == null) {
                                this.k.setRequestProperty("Content-Type", "application/pdf");
                                pDF.render(byteArrayOutputStream);
                            } else {
                                Object object;
                                byte[] byArray = new byte[]{13, 10};
                                byte[] byArray2 = new byte[]{45, 45};
                                byte[] byArray3 = new byte[18];
                                new SecureRandom().nextBytes(byArray3);
                                String string2 = Base64.encode(byArray3);
                                this.k.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string2);
                                String string3 = NetworkSave.this.t;
                                if (string3 == null) {
                                    object = (File)documentPanel.getClientProperty("file");
                                    string3 = object == null ? NetworkSave.this.s + ".pdf" : ((File)object).getName();
                                }
                                object = "Content-Disposition: form-data; name=\"" + NetworkSave.this.s + "\"; filename=\"" + string3 + "\"";
                                String string4 = "Content-Type: application/pdf";
                                byteArrayOutputStream.write(byArray2);
                                byteArrayOutputStream.write(string2.getBytes("ISO-8859-1"));
                                byteArrayOutputStream.write(byArray);
                                byteArrayOutputStream.write(((String)object).getBytes("ISO-8859-1"));
                                byteArrayOutputStream.write(byArray);
                                byteArrayOutputStream.write(string4.getBytes("ISO-8859-1"));
                                byteArrayOutputStream.write(byArray);
                                byteArrayOutputStream.write(byArray);
                                pDF.render(byteArrayOutputStream);
                                byteArrayOutputStream.write(byArray);
                                byteArrayOutputStream.write(byArray2);
                                byteArrayOutputStream.write(string2.getBytes("ISO-8859-1"));
                                byteArrayOutputStream.write(byArray2);
                                byteArrayOutputStream.write(byArray);
                            }
                            byteArrayOutputStream.close();
                            this.i = byteArrayOutputStream.size();
                            this.k.setRequestProperty("Content-Length", Integer.toString(this.i));
                            this.j = new CountingOutputStream(this.k.getOutputStream());
                            try {
                                block20: {
                                    try {
                                        byteArrayOutputStream.writeTo(this.j);
                                        this.j.close();
                                        this.j = null;
                                        int n2 = this.k.getResponseCode();
                                        if (n2 > 299) {
                                            String string5 = NetworkSave.a(this.k);
                                            JOptionPane.showMessageDialog(null, string5, UIManager.getString("PDFViewer.Error"), 0);
                                            break block20;
                                        }
                                        if (NetworkSave.this.r == null) break block20;
                                        final String string6 = NetworkSave.this.r.equals("response") ? NetworkSave.a(this.k) : NetworkSave.this.r;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                JOptionPane.showMessageDialog(null, string6, UIManager.getString("PDFViewer.Saved"), 1);
                                            }
                                        });
                                    }
                                    catch (IOException iOException) {
                                        if (!this.isCancelled()) {
                                            throw iOException;
                                        }
                                        Object var11_16 = null;
                                        if (this.j == null) return;
                                        this.j.close();
                                        return;
                                    }
                                }
                                Object var11_15 = null;
                                if (this.j == null) return;
                                this.j.close();
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var11_17 = null;
                                if (this.j == null) throw throwable;
                                this.j.close();
                                throw throwable;
                            }
                        }

                        public float getProgress() {
                            if (this.i == 0) {
                                return documentPanel.getPDF().getRenderProgress() / 2.0f;
                            }
                            if (this.j != null) {
                                double d2 = this.j.tell();
                                return (float)(d2 / (double)this.i / 2.0 + 0.5);
                            }
                            return 1.0f;
                        }

                        public void cancel() {
                            super.cancel();
                            if (this.k != null) {
                                this.k.disconnect();
                            }
                        }
                    };
                    ((LongRunningTask)object).start(pDFViewer, Util.getUIString("PDFViewer.SavingFile", uRL.toString()));
                }
                return null;
            }
        });
    }

    public void setAdditionalHeaders(URLConnection uRLConnection, DocumentPanel documentPanel) {
    }

    private static String a(HttpURLConnection httpURLConnection) throws IOException {
        String string;
        String string2 = httpURLConnection.getContentEncoding();
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }
}

