/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.Exporter;
import org.faceless.pdf2.viewer2.PDFBackgroundTask;
import org.faceless.pdf2.viewer2.ViewerFeature;

public class PDFExporter
extends Exporter {
    private FileFilter b = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
        }

        public String getDescription() {
            return UIManager.getString("PDFViewer.FilesPDF");
        }
    };

    public PDFExporter() {
        super("PDFExporter");
    }

    public FileFilter getFileFilter() {
        return this.b;
    }

    public String getFileSuffix() {
        return "pdf";
    }

    public Exporter.ExporterTask getExporter(final DocumentPanel documentPanel, final PDF pDF, JComponent jComponent, final OutputStream outputStream) {
        return new Exporter.ExporterTask(){

            public final boolean isCancellable() {
                return false;
            }

            public float getProgress() {
                return pDF.getRenderProgress();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void savePDF() throws IOException {
                Iterator iterator;
                HashSet<ViewerFeature> hashSet = null;
                if (documentPanel != null) {
                    hashSet = new HashSet<ViewerFeature>(documentPanel.getSidePanels());
                    if (documentPanel.getViewer() != null) {
                        hashSet.addAll(Arrays.asList(documentPanel.getViewer().getFeatures()));
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (e2 instanceof PDFBackgroundTask) {
                            try {
                                ((PDFBackgroundTask)e2).pause();
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                throw new RuntimeException(interruptedException);
                            }
                        }
                        iterator.remove();
                    }
                    documentPanel.getJSManager().runEventDocWillSave(documentPanel);
                }
                pDF.render(outputStream);
                outputStream.close();
                if (documentPanel != null) {
                    documentPanel.setDirty(false);
                    documentPanel.getJSManager().runEventDocDidSave(documentPanel);
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        ((PDFBackgroundTask)iterator.next()).unpause();
                    }
                }
            }
        };
    }
}

