/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFReader;
import org.faceless.pdf2.viewer2.Importer;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PasswordPromptEncryptionHandler;
import org.faceless.pdf2.viewer2.PublicKeyPromptEncryptionHandler;
import org.faceless.util.SemiSeekableInputStream;

public class PDFImporter
extends Importer {
    private Set b = new LinkedHashSet();
    private FileFilter c = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
        }

        public String getDescription() {
            return UIManager.getString("PDFViewer.FilesPDF");
        }
    };
    private boolean d;

    public PDFImporter() {
        super("PDFImporter");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        this.b.add(new PasswordPromptEncryptionHandler(pDFViewer));
        this.b.add(new PublicKeyPromptEncryptionHandler(pDFViewer, pDFViewer.getKeyStoreManager()));
    }

    public FileFilter getFileFilter() {
        return this.c;
    }

    public boolean matches(File file) throws IOException {
        boolean bl = false;
        if (file.length() > 200L) {
            SemiSeekableInputStream semiSeekableInputStream = new SemiSeekableInputStream(new FileInputStream(file));
            bl = semiSeekableInputStream.search(new byte[]{37, 80, 68, 70, 45, 49}, 1032L);
            semiSeekableInputStream.close();
        }
        return bl;
    }

    public Set getEncryptionHandlers() {
        return this.b;
    }

    public void setUseInputStream(boolean bl) {
        this.d = bl;
    }

    public Importer.ImporterTask getImporter(PDFViewer pDFViewer, File file) {
        return this.getImporter(pDFViewer, null, null, file);
    }

    public Importer.ImporterTask getImporter(PDFViewer pDFViewer, InputStream inputStream, String string, File file) {
        this.b.remove(null);
        final EncryptionHandler[] encryptionHandlerArray = this.b.toArray(new EncryptionHandler[0]);
        return new Importer.ImporterTask(pDFViewer, inputStream, string, file){
            private float[] j;
            {
                super(PDFImporter.this, pDFViewer, inputStream, string, file);
                this.j = new float[1];
            }

            public float getProgress() {
                return this.j[0];
            }

            public PDF loadPDF() throws IOException {
                try {
                    return (PDF)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            PDFReader pDFReader;
                            InputStream inputStream;
                            block7: {
                                inputStream = in;
                                if (inputStream != null || !PDFImporter.this.d) break block7;
                                inputStream = new FileInputStream(file);
                            }
                            if (inputStream == null) {
                                pDFReader = new PDFReader(file, encryptionHandlerArray, j);
                            } else {
                                pDFReader = new PDFReader(inputStream, encryptionHandlerArray, j);
                                inputStream.close();
                            }
                            if (!this.isCancelled()) {
                                return new PDF(pDFReader);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
        };
    }
}

