/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class PageNext
extends ViewerWidget
implements DocumentPanelListener {
    public PageNext() {
        super("PageNext");
        this.setButton("Navigation.ltr", "resources/icons/NextPage.png", "PDFViewer.tt.PageNext");
        this.setMenu("View\tGoTo\tNextPage");
    }

    public void action(ViewerEvent viewerEvent) {
        int n2;
        DocumentPanel documentPanel = viewerEvent.getDocumentPanel();
        PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
        int n3 = n2 = pDFPage == null ? 0 : pDFPage.getPageNumber() - 1;
        if (n2 < documentPanel.getPDF().getNumberOfPages() - 1) {
            viewerEvent.getDocumentPanel().setPageNumber(n2 + 1);
        }
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (documentPanelEvent.getType() == "pageChanged" || documentPanelEvent.getType() == "activated") {
            PDF pDF = documentPanelEvent.getDocumentPanel().getPDF();
            boolean bl = pDF != null && documentPanelEvent.getDocumentPanel().getPageNumber() < pDF.getNumberOfPages() - 1;
            documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("ButtonPageNext").setEnabled(bl);
            documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("MenuPageNext").setEnabled(bl);
        }
    }
}

