/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class PageNumber
extends ViewerWidget
implements DocumentPanelListener,
PropertyChangeListener {
    private JTextField n = new JTextField();
    private String[] o;
    private PDF p;
    private boolean q = true;

    public PageNumber() {
        super("PageNumber");
        this.n.setColumns(3);
        this.n.setFont(null);
        this.n.setHorizontalAlignment(2);
        this.n.setEditable(true);
        this.n.setEnabled(false);
        this.n.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PageNumber.this.n.getText().trim();
                DocumentPanel documentPanel = PageNumber.this.getViewer().getActiveDocumentPanel();
                if (PageNumber.this.o != null) {
                    int n2 = -1;
                    for (int i2 = 0; n2 < 0 && i2 < PageNumber.this.o.length; ++i2) {
                        if (!PageNumber.this.o[i2].equals(string)) continue;
                        n2 = i2;
                    }
                    if (n2 < 0) {
                        try {
                            n2 = Integer.parseInt(string) - 1;
                            if (n2 < 0 || n2 >= PageNumber.this.o.length) {
                                n2 = -1;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (documentPanel != null) {
                        if (n2 >= 0) {
                            documentPanel.setPageNumber(n2);
                        } else {
                            n2 = documentPanel.getPageNumber();
                            if (n2 >= 0 && n2 < PageNumber.this.o.length) {
                                PageNumber.this.n.setText(PageNumber.this.o[n2]);
                            }
                        }
                    }
                }
                if (!PageNumber.this.n.hasFocus()) return;
                if (documentPanel == null) return;
                documentPanel.getViewport().requestFocusInWindow();
            }
        });
        this.n.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                PageNumber.this.n.selectAll();
            }
        });
        this.setComponent("Navigation.ltr", this.n);
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
        String string = this.getFeatureProperty(pDFViewer, "usePageLabels");
        if (string != null) {
            this.setUsePageLabels("true".equalsIgnoreCase(string));
        }
    }

    public void setUsePageLabels(boolean bl) {
        this.q = bl;
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        String string = documentPanelEvent.getType();
        if (string == "pageChanged" || string == "activated") {
            String string2;
            int n2;
            PDF pDF;
            if (string == "activated" && (pDF = documentPanelEvent.getDocumentPanel().getPDF()) != null) {
                this.p = pDF;
                this.p.addPropertyChangeListener(this);
                this.a(pDF);
                this.n.setEnabled(true);
            }
            if ((n2 = documentPanelEvent.getDocumentPanel().getPageNumber()) >= 0 && this.o != null && n2 < this.o.length && !(string2 = this.o[n2]).equals(this.n.getText())) {
                this.n.setText(string2);
            }
        } else if (string == "deactivated") {
            if (this.p != null) {
                this.p.removePropertyChangeListener(this);
            }
            this.o = null;
            this.p = null;
            this.n.setText("");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        final PDF pDF = this.p;
        if (pDF != null && (string.equals("pages") || string.equals("pagelabels"))) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.a(pDF);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PageNumber.this.a(pDF);
                    }
                });
            }
        }
    }

    private void a(PDF pDF) {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = pDF.getNumberOfPages();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string;
            String string2 = string = this.q ? pDF.getPageLabel(i2) : null;
            if (string == null) {
                string = Integer.toString(i2 + 1);
            }
            arrayList.add(string);
        }
        this.o = arrayList.toArray(new String[n3]);
        DocumentPanel documentPanel = this.getViewer().getActiveDocumentPanel();
        int n4 = n2 = documentPanel == null ? -1 : documentPanel.getPageNumber();
        if (n2 >= 0) {
            this.n.setText(this.o[n2]);
        }
    }
}

