/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;
import org.faceless.pdf2.viewer2.util.AppletMenuItem;

public class Quit
extends ViewerWidget
implements ActionListener {
    public Quit() {
        super("Quit");
        this.setDocumentRequired(false);
    }

    public void initialize(PDFViewer pDFViewer) {
        if (Util.isLAFWindows()) {
            this.setMenu("File\tExit(999)");
        } else {
            this.setMenu("File\tQuit(999)", 'q');
        }
        super.initialize(pDFViewer);
        AppletMenuItem appletMenuItem = (AppletMenuItem)pDFViewer.getNamedComponent("MenuQuit");
        if (appletMenuItem != null) {
            appletMenuItem.setAppletEnabled(false);
            if (Util.isLAFWindows()) {
                appletMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
            }
        }
    }

    protected ActionListener createActionListener() {
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.createActionListener().actionPerformed(actionEvent);
    }

    public void action(ViewerEvent viewerEvent) {
        if (!Util.isBrowserApplet(viewerEvent.getViewer()) || JOptionPane.showConfirmDialog(viewerEvent.getViewer(), UIManager.getString("PDFViewer.ConfirmQuitText"), UIManager.getString("PDFViewer.Confirm"), 0) == 0) {
            DocumentPanel[] documentPanelArray = viewerEvent.getViewer().getDocumentPanels();
            for (int i2 = 0; i2 < documentPanelArray.length; ++i2) {
                viewerEvent.getViewer().closeDocumentPanel(documentPanelArray[i2]);
            }
            if (viewerEvent.getViewer().getDocumentPanels().length == 0) {
                System.exit(0);
            }
        }
    }
}

