/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.faceless.pdf2.BarCode;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.util.DialogPanel;
import org.faceless.util.Base64;

public class SignatureCapture
extends ViewerFeature {
    public static final String PATHSUFFIX = ".sigpath";
    public static final String KEYALGORITHM = "bfo.signaturepath";
    public static final char[] SECRETKEYPASSWORD = "bfo.signaturepath".toCharArray();
    private InetSocketAddress b;

    public SignatureCapture() {
        super("SignatureCapture");
    }

    public void initialize(PDFViewer pDFViewer) {
        int n2;
        InetAddress inetAddress;
        block8: {
            super.initialize(pDFViewer);
            String string = this.getFeatureProperty(pDFViewer, "host");
            inetAddress = null;
            try {
                if (string != null) {
                    inetAddress = InetAddress.getByName(string);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't identify local host from " + string);
            }
            String string2 = this.getFeatureProperty(pDFViewer, "port");
            n2 = 0;
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2);
                    if (n2 >= 1024 && n2 <= 65535) break block8;
                    n2 = 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setLocalAddress(new InetSocketAddress(inetAddress, n2));
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public void setLocalAddress(InetSocketAddress inetSocketAddress) {
        this.b = inetSocketAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] writePath(GeneralPath generalPath) {
        if (generalPath == null || generalPath.getBounds().width == 0) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(generalPath);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeneralPath readPath(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return (GeneralPath)new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JComponent getPathComponent(final GeneralPath generalPath) {
        final Rectangle rectangle = generalPath.getBounds();
        return new JPanel(){

            public void paintComponent(Graphics graphics) {
                float f2 = (float)this.getWidth() - 2.0f;
                float f3 = (float)this.getHeight() - 2.0f;
                int n2 = rectangle.width;
                int n3 = rectangle.height;
                float f4 = Math.min(f2 / (float)n2, f3 / (float)n3);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate((f2 - (float)n2 * f4) / 2.0f, (f3 - (float)n3 * f4) / 2.0f);
                affineTransform.scale(f4, f4);
                affineTransform.translate(-rectangle.x, -rectangle.y);
                AffineTransform affineTransform2 = ((Graphics2D)graphics).getTransform();
                ((Graphics2D)graphics).transform(affineTransform);
                ((Graphics2D)graphics).draw(generalPath);
                ((Graphics2D)graphics).setTransform(affineTransform2);
            }
        };
    }

    public void action(ViewerEvent viewerEvent) {
    }

    public GeneralPath capture(int n2, int n3) {
        return SignatureCapture.capture(this.b, null, n2, n3);
    }

    public static GeneralPath capture(InetSocketAddress inetSocketAddress, String string, int n2, int n3) {
        final Object[] objectArray = new Object[]{null};
        try {
            String string2;
            ServerSocket serverSocket;
            block9: {
                block8: {
                    serverSocket = new ServerSocket();
                    serverSocket.bind(inetSocketAddress);
                    if (inetSocketAddress.getAddress() != null && !inetSocketAddress.getHostName().equals("0.0.0.0")) break block8;
                    string2 = InetAddress.getLocalHost().getCanonicalHostName();
                    break block9;
                }
                string2 = inetSocketAddress.getAddress().getCanonicalHostName();
            }
            String string3 = "http://" + string2 + ":" + serverSocket.getLocalPort() + "/capture?w=" + n2 + "&h=" + n3 + "&reset=" + UIManager.getString("PDFViewer.Clear") + "&ok=" + UIManager.getString("PDFViewer.OK");
            if (string != null) {
                string3 = string3 + "&proxy=" + URLEncoder.encode(string, "UTF-8");
            }
            final DialogPanel dialogPanel = new DialogPanel(false, true);
            BarCode barCode = BarCode.newQRCode(string3, 2.0, 2, 0);
            dialogPanel.addButton("delete", UIManager.getString("PDFViewer.Delete"), KeyStroke.getKeyStroke(127, 0), new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    objectArray[0] = new GeneralPath();
                    dialogPanel.acceptDialog();
                }
            });
            BufferedImage bufferedImage = barCode.getBufferedImage(1.0, Color.white);
            JButton jButton = new JButton("<html><p style='text-align:center; width:340px'>" + Util.getUIString("PDFViewer.CaptureSignatureHowto", string3) + "</p></html>", new ImageIcon(bufferedImage));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setIconTextGap(10);
            jButton.setVerticalTextPosition(3);
            jButton.setHorizontalTextPosition(0);
            jButton.setFocusable(false);
            dialogPanel.addComponent(jButton);
            Thread thread = new Thread(){

                public void run() {
                    while (objectArray[0] == null) {
                        try {
                            final Socket socket = serverSocket.accept();
                            Thread thread = new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void run() {
                                    InputStream inputStream = null;
                                    try {
                                        int n2;
                                        inputStream = socket.getInputStream();
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((n2 = inputStream.read()) >= 0 && n2 != 13 && stringBuilder.length() < 65536) {
                                            stringBuilder.append((char)n2);
                                        }
                                        if (n2 != 13) return;
                                        if (inputStream.read() != 10) return;
                                        if (stringBuilder.indexOf(" HTTP/1") <= 0) return;
                                        stringBuilder.setLength(stringBuilder.indexOf(" HTTP/1"));
                                        stringBuilder.delete(0, stringBuilder.indexOf(" ") + 1);
                                        if (stringBuilder.indexOf("/capture") >= 0) {
                                            SignatureCapture.a(socket, stringBuilder.toString());
                                            return;
                                        }
                                        if (stringBuilder.indexOf("/store") < 0) return;
                                        objectArray[0] = SignatureCapture.b(socket, stringBuilder.toString());
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                dialogPanel.acceptDialog();
                                            }
                                        });
                                        return;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        return;
                                    }
                                    finally {
                                        try {
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            socket.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            };
                            thread.setDaemon(true);
                            thread.start();
                        }
                        catch (Exception exception) {
                            objectArray[0] = exception;
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (dialogPanel.isVisible()) {
                                dialogPanel.cancelDialog();
                            }
                        }
                    });
                }
            };
            thread.setDaemon(true);
            thread.start();
            dialogPanel.showDialog(null, UIManager.getString("PDFViewer.ManageIdentities"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (objectArray[0] instanceof GeneralPath) {
            return (GeneralPath)objectArray[0];
        }
        return null;
    }

    private static void a(Socket socket, String string) throws IOException {
        int n2;
        InputStream inputStream = PDFViewer.class.getResourceAsStream("resources/sigcapture.html");
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write("HTTP/1.0 200 OK\r\nContent-Type: text/html\r\nConnection: close\r\n\r\n".getBytes("ISO-8859-1"));
        while ((n2 = inputStream.read()) >= 0) {
            outputStream.write(n2);
        }
        inputStream.close();
        outputStream.close();
    }

    private static GeneralPath b(Socket socket, String string) throws IOException {
        Object object;
        if (socket != null) {
            object = socket.getOutputStream();
            ((OutputStream)object).write("HTTP/1.0 200 OK\r\nContent-Type: text/html\r\nConnection: close\r\n\r\n<html><head><script>window.close()</script></head></html>".getBytes("ISO-8859-1"));
            ((OutputStream)object).close();
            string = string.substring(string.indexOf("?") + 1);
        }
        object = Base64.decode(string);
        GeneralPath generalPath = new GeneralPath();
        int n2 = 0;
        int n3 = (object[n2++] & 0xFF) << 8 | object[n2++] & 0xFF;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            if ((n4 = (object[n2++] & 0xFF) << 8 | (object[n2++] & 0xFF) / 2) <= 0) continue;
            int n5 = (object[n2++] & 0xFF) << 8 | object[n2++] & 0xFF;
            int n6 = (object[n2++] & 0xFF) << 8 | object[n2++] & 0xFF;
            generalPath.moveTo(n5, n6);
            for (int i3 = 1; i3 < n4; ++i3) {
                n5 = (object[n2++] & 0xFF) << 8 | object[n2++] & 0xFF;
                n6 = (object[n2++] & 0xFF) << 8 | object[n2++] & 0xFF;
                generalPath.lineTo(n5, n6);
            }
        }
        return generalPath;
    }
}

