/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PageExtractor;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.Exporter;

public class TextExporter
extends Exporter {
    private FileFilter b = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".txt");
        }

        public String getDescription() {
            return UIManager.getString("PDFViewer.FilesText");
        }
    };

    public TextExporter() {
        super("TextExporter");
    }

    public FileFilter getFileFilter() {
        return this.b;
    }

    public String getFileSuffix() {
        return "txt";
    }

    public boolean isEnabled(PDF pDF) {
        EncryptionHandler encryptionHandler = pDF.getEncryptionHandler();
        return encryptionHandler == null || encryptionHandler.hasRight("Extract");
    }

    public Exporter.ExporterTask getExporter(final DocumentPanel documentPanel, final PDF pDF, JComponent jComponent, final OutputStream outputStream) {
        return new Exporter.ExporterTask(){
            private float i;

            public final boolean isCancellable() {
                return true;
            }

            public float getProgress() {
                return this.i;
            }

            public void savePDF() throws IOException {
                PDFParser pDFParser = documentPanel.getParser();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                for (int i2 = 0; i2 < pDF.getNumberOfPages(); ++i2) {
                    PageExtractor pageExtractor = pDFParser.getPageExtractor(i2);
                    outputStreamWriter.write(pageExtractor.getTextAsStringBuffer().toString());
                    this.i = (float)i2 / (float)pDF.getNumberOfPages();
                }
                outputStreamWriter.close();
            }
        };
    }
}

