/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.faceless.pdf2.PageExtractor;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.DocumentViewport;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.PagePanelEvent;
import org.faceless.pdf2.viewer2.PagePanelListener;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.TextSelection;
import org.faceless.pdf2.viewer2.util.PropertyParser;

public class TextHighlighter
extends ViewerFeature
implements DocumentPanelListener,
PagePanelListener {
    private WeakReference b;
    private Map c;
    private String[] d;
    private Pattern e;
    private Paint f;
    private Stroke g;
    private int h;
    private float i;
    public static final int TYPE_FILL = 1;
    public static final int TYPE_OUTLINE = 8;

    public TextHighlighter() {
        super("TextHighlighter");
        this.setHighlightType(1, new Color(0x70FFFF00, true), null, 0.0f);
        this.c = new WeakHashMap();
    }

    public synchronized void setPattern(Pattern pattern) {
        this.e = pattern;
        this.c.clear();
        this.b();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void addWord(String string) {
        if (!(string == null || string.length() <= 0 || this.d != null && Arrays.asList(this.d).contains(string))) {
            String[] stringArray = new String[this.d == null ? 1 : this.d.length + 1];
            if (this.d != null) {
                System.arraycopy(this.d, 0, stringArray, 0, this.d.length);
            }
            stringArray[stringArray.length - 1] = string;
            this.d = stringArray;
            this.c.clear();
            this.b();
        }
    }

    public void initialize(PDFViewer pDFViewer) {
        block6: {
            String string;
            block5: {
                super.initialize(pDFViewer);
                this.f = PropertyParser.getPaint(this.getFeatureProperty(pDFViewer, "highlightColor"), this.f);
                this.h = PropertyParser.getHighlightType(this.getFeatureProperty(pDFViewer, "highlightType"), this.h);
                this.g = PropertyParser.getStroke(this.getFeatureProperty(pDFViewer, "highlightStroke"), this.g);
                this.i = PropertyParser.getMargin(this.getFeatureProperty(pDFViewer, "highlightMargin"), this.i);
                string = this.getFeatureProperty(pDFViewer, "pattern");
                if (string == null) break block5;
                this.setPattern(Pattern.compile(string));
                break block6;
            }
            int n2 = 0;
            while ((string = this.getFeatureProperty(pDFViewer, "word" + n2++)) != null) {
                this.addWord(string);
            }
        }
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        block7: {
            if (documentPanelEvent.getType() == "viewportChanged") {
                block6: {
                    DocumentViewport documentViewport = this.a();
                    if (documentViewport != null) {
                        documentViewport.removePagePanelListener(this);
                    }
                    documentViewport = documentPanelEvent.getDocumentPanel().getViewport();
                    if (documentViewport == null) break block6;
                    documentViewport.addPagePanelListener(this);
                    this.b = new WeakReference<DocumentViewport>(documentViewport);
                    break block7;
                }
                this.b = null;
            }
        }
    }

    private DocumentViewport a() {
        DocumentViewport documentViewport = this.b == null ? null : (DocumentViewport)this.b.get();
        return documentViewport;
    }

    public void setHighlightType(int n2, Paint paint, Stroke stroke, float f2) {
        if (paint == null) {
            throw new IllegalArgumentException("color is null");
        }
        this.h = n2;
        this.f = paint;
        this.g = stroke;
        this.i = f2;
        this.b();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pageUpdated(PagePanelEvent pagePanelEvent) {
        if (pagePanelEvent.getType() == "redrawing") {
            if (this.e == null) return;
            if (this.d == null) return;
            pagePanelEvent.getPagePanel().setExtractText(true);
            return;
        }
        if (pagePanelEvent.getType() != "redrawn") return;
        this.a(pagePanelEvent.getPagePanel()).repaint();
    }

    private void b() {
        DocumentViewport documentViewport = this.a();
        if (documentViewport != null) {
            for (PagePanel pagePanel : documentViewport.getPagePanels()) {
                this.a(pagePanel).repaint();
            }
        }
    }

    private TextSelection a(PagePanel pagePanel) {
        TextSelection textSelection = null;
        int n2 = 0;
        while (true) {
            block6: {
                if (textSelection != null || n2 >= pagePanel.getComponentCount()) break;
                Component component = pagePanel.getComponent(n2);
                if (!(component instanceof a_) || ((a_)component).a() != this) break block6;
                textSelection = (TextSelection)component;
            }
            ++n2;
        }
        if (textSelection == null) {
            textSelection = new a_(this.h, this.f, this.g, this.i);
            textSelection.setBounds(new Rectangle(0, 0, pagePanel.getWidth(), pagePanel.getHeight()));
            pagePanel.add(textSelection);
        }
        return textSelection;
    }

    private class a_
    extends TextSelection {
        a_(int n2, Paint paint, Stroke stroke, float f2) {
            super(n2, paint, stroke, f2);
        }

        TextHighlighter a() {
            return TextHighlighter.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TextSelection.RangeList getRangeList() {
            TextSelection.RangeList rangeList;
            PagePanel pagePanel = (PagePanel)this.getParent();
            PageExtractor pageExtractor = pagePanel.getPageExtractor();
            if (TextHighlighter.this.d == null && TextHighlighter.this.e == null || pageExtractor == null) {
                return TextSelection.RangeList.b;
            }
            Map map = TextHighlighter.this.c;
            synchronized (map) {
                SoftReference softReference = (SoftReference)TextHighlighter.this.c.get(pageExtractor);
                TextSelection.RangeList rangeList2 = rangeList = softReference == null ? null : (TextSelection.RangeList)softReference.get();
                if (rangeList == null) {
                    Collection collection = TextHighlighter.this.e != null ? pageExtractor.getMatchingText(TextHighlighter.this.e) : pageExtractor.getMatchingText(TextHighlighter.this.d);
                    if (collection.isEmpty()) {
                        rangeList = TextSelection.RangeList.b;
                    } else {
                        ArrayList<TextSelection.Range> arrayList = new ArrayList<TextSelection.Range>(collection.size());
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            arrayList.add(TextSelection.Range.createRange((PageExtractor.Text)iterator.next()));
                        }
                        rangeList = new TextSelection.RangeList(arrayList);
                    }
                    TextHighlighter.this.c.put(pageExtractor, new SoftReference<TextSelection.RangeList>(rangeList));
                }
            }
            return rangeList;
        }
    }
}

