/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.text.AttributedString;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PageExtractor;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.feature.TextTool;
import org.faceless.util.AttributedStringBuilder;

public abstract class TextSelection
extends JPanel {
    private final Paint a;
    private final Stroke b;
    private final float c;
    private final int d;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_UNDERLINE = 2;
    public static final int TYPE_DOUBLEUNDERLINE = 4;
    public static final int TYPE_OUTLINE = 8;
    public static final int TYPE_STRIKEOUT = 16;
    public static final int TYPE_DOUBLESTRIKEOUT = 32;

    public TextSelection(int n2, Paint paint, Stroke stroke, float f2) {
        this.a = paint;
        this.d = n2;
        this.b = stroke;
        this.c = f2;
        this.setOpaque(false);
    }

    public boolean isGlassPane() {
        return true;
    }

    public boolean contains(int n2, int n3) {
        return !this.isGlassPane() && super.contains(n2, n3);
    }

    protected abstract RangeList getRangeList();

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        PagePanel pagePanel = (PagePanel)this.getParent();
        PDFPage pDFPage = pagePanel.getPage();
        if (pDFPage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getClientProperty("pdf.rect") == null) {
            this.putClientProperty("pdf.rect", pDFPage.getBox("ViewBox"));
        }
        boolean bl = this.d != 1 && this.d != 8;
        RangeList rangeList = this.getRangeList();
        for (int i2 = 0; i2 < rangeList.size(); ++i2) {
            Range range = (Range)rangeList.get(i2);
            if (!range.isValid()) continue;
            PageExtractor.Text text = range.getFirst();
            PageExtractor.Text text2 = range.getLast();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(pagePanel.getPageToScreenTransform());
            int n2 = range.getFirstPosition();
            int n3 = range.getLastPosition();
            if (text == text2) {
                this.drawHighlight(this.d, this.a, this.b, graphics2D, TextTool.a(text, n2, n3, this.c, bl));
            } else {
                boolean bl2 = false;
                PageExtractor pageExtractor = text.getPageExtractor();
                Collection collection = pageExtractor.getTextUnordered();
                for (PageExtractor.Text text3 : collection) {
                    if (text3 == text) {
                        bl2 = true;
                        this.drawHighlight(this.d, this.a, this.b, graphics2D, TextTool.a(text3, n2, text3.getTextLength() - 1, this.c, bl));
                        continue;
                    }
                    if (text3 == text2) {
                        bl2 = false;
                        this.drawHighlight(this.d, this.a, this.b, graphics2D, TextTool.a(text3, 0, n3, this.c, bl));
                        continue;
                    }
                    if (!bl2) continue;
                    this.drawHighlight(this.d, this.a, this.b, graphics2D, TextTool.a(text3, this.c, bl));
                }
            }
            graphics2D.setTransform(affineTransform);
        }
    }

    public void drawHighlight(int n2, Paint paint, Stroke stroke, Graphics2D graphics2D, Shape shape) {
        if (shape == null) {
            return;
        }
        graphics2D.setPaint(paint);
        if (n2 == 1) {
            graphics2D.fill(shape);
        } else if (n2 == 8) {
            graphics2D.draw(shape);
        } else if (n2 == 2 || n2 == 4 || n2 == 16 || n2 == 32) {
            Point2D.Float float_ = null;
            Point2D.Float float_2 = null;
            PathIterator pathIterator = ((GeneralPath)shape).getPathIterator(new AffineTransform());
            float[][] fArray = new float[4][6];
            pathIterator.currentSegment(fArray[0]);
            pathIterator.next();
            pathIterator.currentSegment(fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray[2]);
            pathIterator.next();
            pathIterator.currentSegment(fArray[3]);
            pathIterator.next();
            float f2 = (float)Math.sqrt((fArray[1][0] - fArray[0][0]) * (fArray[1][0] - fArray[0][0]) + (fArray[1][1] - fArray[0][1]) * (fArray[1][1] - fArray[0][1])) / 20.0f;
            if (n2 == 16 || n2 == 32) {
                float_ = new Point2D.Float((fArray[1][0] + fArray[0][0]) / 2.0f, (fArray[1][1] + fArray[0][1]) / 2.0f);
                float_2 = new Point2D.Float((fArray[2][0] + fArray[3][0]) / 2.0f, (fArray[2][1] + fArray[3][1]) / 2.0f);
            } else {
                float_ = new Point2D.Float(fArray[0][0], fArray[0][1]);
                float_2 = new Point2D.Float(fArray[3][0], fArray[3][1]);
            }
            if (stroke == null) {
                stroke = new BasicStroke(f2);
            }
            graphics2D.setStroke(stroke);
            Line2D.Float float_3 = new Line2D.Float(float_, float_2);
            graphics2D.draw(float_3);
            if (n2 == 4 || n2 == 32) {
                if (stroke instanceof BasicStroke) {
                    f2 = ((BasicStroke)stroke).getLineWidth();
                }
                float f3 = (float)(float_2.getX() - float_.getX());
                float f4 = (float)(float_2.getY() - float_.getY());
                double d2 = (double)(f2 * 2.0f) / Math.sqrt(f3 * f3 + f4 * f4);
                graphics2D.draw(AffineTransform.getTranslateInstance((double)f4 * d2, (double)(-f3) * d2).createTransformedShape(float_3));
            }
        }
    }

    public static class RangeList
    extends AbstractList {
        private final List a;
        static final RangeList b = new RangeList(Collections.EMPTY_LIST);

        public RangeList(Range range) {
            this(Collections.singletonList(range));
        }

        public RangeList(List list) {
            if (list.size() > 1) {
                Collections.sort(list);
                Range range = (Range)list.get(0);
                for (int i2 = 1; i2 < list.size(); ++i2) {
                    Range range2 = (Range)list.get(i2);
                    if (!(range instanceof a_) || !(range2 instanceof a_)) continue;
                    if (((a_)range).a((a_)range2)) {
                        list.remove(i2--);
                        continue;
                    }
                    range = range2;
                }
            }
            this.a = list;
        }

        public Object get(int n2) {
            return this.a.get(n2);
        }

        public int size() {
            return this.a.size();
        }

        public boolean isValid() {
            boolean bl = this.a.size() > 0;
            for (int i2 = 0; bl && i2 < this.a.size(); bl &= ((Range)this.a.get(i2)).isValid(), ++i2) {
            }
            return bl;
        }

        public Set getPages() {
            LinkedHashSet<PDFPage> linkedHashSet = new LinkedHashSet<PDFPage>();
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Range range = (Range)this.a.get(i2);
                linkedHashSet.add(range.getPage());
            }
            return linkedHashSet;
        }

        public float[] getCorners(PDFPage pDFPage) {
            ArrayList<Float> arrayList = new ArrayList<Float>();
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Object object;
                int n2;
                Range range = (Range)this.a.get(i2);
                if (range.getPage() != pDFPage) continue;
                PageExtractor.Text text = range.getFirst();
                PageExtractor.Text text2 = range.getLast();
                int n3 = range.getFirstPosition();
                int n4 = range.getLastPosition();
                if (text == text2) {
                    n2 = n4 - n3;
                    if (n2 <= 0) continue;
                    object = text.getSubText(n3, n2);
                    Object object2 = ((PageExtractor.Text)object).getCorners();
                    for (int i3 = 0; i3 < 8; ++i3) {
                        arrayList.add(new Float((float)object2[i3]));
                    }
                    continue;
                }
                n2 = 0;
                object = text.getPageExtractor();
                for (PageExtractor.Text text3 : ((PageExtractor)object).getTextUnordered()) {
                    if (text3 == text) {
                        n2 = 1;
                        int n5 = text.getTextLength() - n3;
                        if (n5 <= 0) continue;
                        PageExtractor.Text text4 = text.getSubText(n3, n5);
                        float[] fArray = text4.getCorners();
                        for (int i4 = 0; i4 < 8; ++i4) {
                            arrayList.add(new Float(fArray[i4]));
                        }
                        continue;
                    }
                    if (text3 == text2) {
                        n2 = 0;
                        PageExtractor.Text text5 = text2.getSubText(0, n4 + 1);
                        float[] fArray = text5.getCorners();
                        for (int i5 = 0; i5 < 8; ++i5) {
                            arrayList.add(new Float(fArray[i5]));
                        }
                        continue;
                    }
                    if (n2 == 0) continue;
                    float[] fArray = text3.getCorners();
                    for (int i6 = 0; i6 < 8; ++i6) {
                        arrayList.add(new Float(fArray[i6]));
                    }
                }
            }
            float[] fArray = new float[arrayList.size()];
            for (int i7 = 0; i7 < fArray.length; ++i7) {
                fArray[i7] = ((Float)arrayList.get(i7)).floatValue();
            }
            return fArray;
        }

        public StringBuffer getText() {
            StringBuffer stringBuffer = new StringBuffer();
            PDFPage pDFPage = null;
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Range range = (Range)this.a.get(i2);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(range.getPage() == pDFPage ? (char)' ' : '\n');
                }
                stringBuffer.append(range.getText());
                pDFPage = range.getPage();
            }
            return stringBuffer;
        }

        public AttributedString getStyledText() {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            PDFPage pDFPage = null;
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Range range = (Range)this.a.get(i2);
                if (attributedStringBuilder.length() > 0) {
                    attributedStringBuilder.append(range.getPage() == pDFPage ? " " : "\n");
                }
                attributedStringBuilder.append(range.getStyledText());
                pDFPage = range.getPage();
            }
            return attributedStringBuilder.toAttributedString();
        }

        public String toString() {
            return this.a.toString();
        }
    }

    private static class a_
    extends Range {
        private WeakReference a;
        private WeakReference b;
        private int c;
        private int d;

        a_(PageExtractor.Text text) {
            this(text, 0, text, text.getTextLength() - 1);
        }

        a_(PageExtractor.Text text, int n2, PageExtractor.Text text2, int n3) {
            if (text.getPageExtractor() != text2.getPageExtractor()) {
                throw new IllegalArgumentException("PageExtractor mismatch");
            }
            while (text.getPrimaryText() != null) {
                n2 += text.getPrimaryTextOffset();
                text = text.getPrimaryText();
            }
            while (text2.getPrimaryText() != null) {
                n3 += text2.getPrimaryTextOffset();
                text2 = text2.getPrimaryText();
            }
            this.a = new WeakReference<PageExtractor.Text>(text);
            this.b = new WeakReference<PageExtractor.Text>(text2);
            this.c = n2;
            this.d = n3;
        }

        public PageExtractor.Text getFirst() {
            return (PageExtractor.Text)this.a.get();
        }

        public PageExtractor.Text getLast() {
            return (PageExtractor.Text)this.b.get();
        }

        public int getFirstPosition() {
            return this.c;
        }

        public int getLastPosition() {
            return this.d;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean a(a_ a_2) {
            if (this.getLast() == a_2.getFirst() && this.getLastPosition() + 1 <= a_2.getFirstPosition()) {
                this.b = a_2.b;
                this.d = a_2.d;
                return true;
            }
            return false;
        }

        public boolean isValid() {
            return true;
        }
    }

    public static abstract class Range
    implements Comparable {
        public PDFPage getPage() {
            return this.isValid() ? this.getFirst().getPage() : null;
        }

        public abstract PageExtractor.Text getFirst();

        public abstract PageExtractor.Text getLast();

        public abstract int getFirstPosition();

        public abstract int getLastPosition();

        public StringBuffer getText() {
            return this.getFirst().getPageExtractor().getText(this.getFirst(), this.getFirstPosition(), this.getLast(), this.getLastPosition() + 1, true);
        }

        public AttributedString getStyledText() {
            return this.getFirst().getPageExtractor().getStyledText(this.getFirst(), this.getFirstPosition(), this.getLast(), this.getLastPosition() + 1, true);
        }

        public abstract boolean isValid();

        public static Range createRange(PageExtractor.Text text) {
            return new a_(text);
        }

        public static Range createRange(PageExtractor.Text text, int n2, PageExtractor.Text text2, int n3) {
            return new a_(text, n2, text2, n3);
        }

        public int compareTo(Object object) {
            PDFPage pDFPage;
            int n2;
            Range range = (Range)object;
            PDFPage pDFPage2 = this.getPage();
            int n3 = n2 = pDFPage2 == (pDFPage = range.getPage()) ? 0 : pDFPage2.getPageNumber() - pDFPage.getPageNumber();
            if (n2 == 0 && (n2 = this.getFirst().compareTo(range.getFirst())) == 0) {
                n2 = this.getFirstPosition() - range.getFirstPosition();
            }
            return n2;
        }
    }
}

