/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PageExtractor;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.DocumentViewport;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.PagePanelEvent;
import org.faceless.pdf2.viewer2.PagePanelInteractionEvent;
import org.faceless.pdf2.viewer2.PagePanelInteractionListener;
import org.faceless.pdf2.viewer2.PagePanelListener;
import org.faceless.pdf2.viewer2.ToggleViewerWidget;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.TextSelection;
import org.faceless.pdf2.viewer2.feature.TextSelectionAction;
import org.faceless.pdf2.viewer2.util.PropertyParser;
import org.faceless.pdf2.viewer2.util.RichTextTransferHandler;

public class TextTool
extends ToggleViewerWidget
implements DocumentPanelListener,
PagePanelInteractionListener,
PagePanelListener,
FocusListener {
    private final TransferHandler q;
    private final Action r;
    private DocumentViewport s;
    private boolean t;
    private boolean u;
    private Paint v;
    private Stroke w;
    private int x;
    private float y;
    private Pattern z;
    private Map A;
    private Point2D B;
    private int C;
    private boolean D;
    private PageExtractor.Text E;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_UNDERLINE = 2;
    public static final int TYPE_DOUBLEUNDERLINE = 4;
    public static final int TYPE_OUTLINE = 8;
    public static final int TYPE_STRIKEOUT = 16;
    public static final int TYPE_DOUBLESTRIKEOUT = 32;

    public TextTool() {
        super("TextTool", "Mode");
        this.setButton("Mode", "resources/icons/TextTool.png", "PDFViewer.tt.TextTool");
        this.r = new AbstractAction("select-all"){

            public void actionPerformed(ActionEvent actionEvent) {
                TextTool.this.selectAll();
            }
        };
        this.q = new RichTextTransferHandler(this);
        this.A = new WeakHashMap();
        this.setHighlightType(1, new Color(0x70FFFF00, true), null, 0.0f);
        this.setDraggable(true);
    }

    public void setHighlightType(int n2, Paint paint, Stroke stroke, float f2) {
        this.x = n2;
        this.v = paint;
        this.w = stroke;
        this.y = f2;
    }

    public void setDraggable(boolean bl) {
        this.t = bl;
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        this.v = PropertyParser.getPaint(this.getFeatureProperty(pDFViewer, "highlightColor"), this.v);
        this.x = PropertyParser.getHighlightType(this.getFeatureProperty(pDFViewer, "highlightType"), this.x);
        this.w = PropertyParser.getStroke(this.getFeatureProperty(pDFViewer, "highlightStroke"), this.w);
        this.y = PropertyParser.getMargin(this.getFeatureProperty(pDFViewer, "highlightMargin"), this.y);
        String string = this.getFeatureProperty(pDFViewer, "draggable");
        if (string != null) {
            this.setDraggable("true".equals(string));
        }
        if (this.getFeatureProperty(pDFViewer, "selectPattern") != null) {
            this.z = Pattern.compile(this.getFeatureProperty(pDFViewer, "selectPattern"));
        }
        pDFViewer.addDocumentPanelListener(this);
        String string2 = this.getFeatureProperty(pDFViewer, "selectTextToolOnTextSelection");
        this.D = string2 != null && !"false".equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextSelection.RangeList getRangeList() {
        List list = this.s.getDocumentPanel().getParser().getPageExtractors();
        ArrayList arrayList = new ArrayList();
        Map map = this.A;
        synchronized (map) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                PageExtractor pageExtractor = (PageExtractor)list.get(i2);
                TextSelection.RangeList rangeList = (TextSelection.RangeList)this.A.get(pageExtractor);
                if (rangeList == null || !rangeList.isValid()) continue;
                arrayList.addAll(rangeList);
            }
        }
        return new TextSelection.RangeList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextSelection.RangeList a(PageExtractor pageExtractor) {
        Map map = this.A;
        synchronized (map) {
            TextSelection.RangeList rangeList = (TextSelection.RangeList)this.A.get(pageExtractor);
            if (rangeList == null) {
                rangeList = TextSelection.RangeList.b;
            }
            return rangeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a_ b(PageExtractor pageExtractor) {
        Map map = this.A;
        synchronized (map) {
            TextSelection.RangeList rangeList = (TextSelection.RangeList)this.A.get(pageExtractor);
            a_ a_2 = null;
            if (rangeList == null || rangeList.size() != 1 || !(rangeList.get(0) instanceof a_)) {
                a_2 = new a_();
                this.A.put(pageExtractor, new TextSelection.RangeList(a_2));
            } else {
                a_2 = (a_)rangeList.get(0);
            }
            return a_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PageExtractor pageExtractor, TextSelection.RangeList rangeList) {
        Map map = this.A;
        synchronized (map) {
            if (rangeList == null) {
                this.A.remove(pageExtractor);
            } else {
                this.A.put(pageExtractor, rangeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PDF pDF) {
        Map map = this.A;
        synchronized (map) {
            Iterator iterator = this.A.keySet().iterator();
            while (iterator.hasNext()) {
                PageExtractor pageExtractor = (PageExtractor)iterator.next();
                if (pageExtractor.getPage().getPDF() != pDF) continue;
                iterator.remove();
            }
        }
        this.a(false);
    }

    protected void updateViewport(final DocumentViewport documentViewport, boolean bl) {
        if (bl) {
            Serializable serializable2;
            this.s = documentViewport;
            EncryptionHandler encryptionHandler = documentViewport.getDocumentPanel().getPDF().getEncryptionHandler();
            this.u = encryptionHandler == null || encryptionHandler.hasRight("Extract");
            documentViewport.addPagePanelInteractionListener(this);
            documentViewport.addPagePanelListener(this);
            documentViewport.addFocusListener(this);
            for (Serializable serializable2 : documentViewport.getPagePanels()) {
                this.b((PagePanel)serializable2);
                ((Component)serializable2).repaint();
            }
            ActionMap actionMap = documentViewport.getActionMap();
            serializable2 = documentViewport.getInputMap();
            documentViewport.setTransferHandler(this.q);
            actionMap.put(this.r.getValue("Name"), this.r);
            ((InputMap)serializable2).put(KeyStroke.getKeyStroke(65, documentViewport.getToolkit().getMenuShortcutKeyMask()), this.r.getValue("Name"));
            if (this.u) {
                ((InputMap)serializable2).put(KeyStroke.getKeyStroke(67, documentViewport.getToolkit().getMenuShortcutKeyMask()), TransferHandler.getCopyAction().getValue("Name"));
                actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
            }
            Object[] objectArray = actionMap.keys();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!(objectArray[i2] instanceof TextSelectionAction)) continue;
                actionMap.remove(objectArray[i2]);
            }
            ViewerFeature[] viewerFeatureArray = this.getViewer().getFeatures();
            for (int i3 = 0; i3 < viewerFeatureArray.length; ++i3) {
                if (!(viewerFeatureArray[i3] instanceof TextSelectionAction)) continue;
                final TextSelectionAction textSelectionAction = (TextSelectionAction)((Object)viewerFeatureArray[i3]);
                AbstractAction abstractAction = new AbstractAction(textSelectionAction.getDescription()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPanel documentPanel = documentViewport.getDocumentPanel();
                        ArrayList arrayList = new ArrayList();
                        Map map = TextTool.this.A;
                        synchronized (map) {
                            Collection collection = TextTool.this.A.values();
                            for (TextSelection.RangeList rangeList : collection) {
                                if (!rangeList.isValid()) continue;
                                arrayList.addAll(rangeList);
                            }
                        }
                        textSelectionAction.selectAction(documentPanel, new TextSelection.RangeList(arrayList));
                    }
                };
                actionMap.put(textSelectionAction, abstractAction);
            }
        } else {
            documentViewport.removePagePanelInteractionListener(this);
            documentViewport.removePagePanelListener(this);
            documentViewport.removeFocusListener(this);
            ActionMap actionMap = documentViewport.getActionMap();
            InputMap inputMap = documentViewport.getInputMap();
            Object[] objectArray = actionMap.keys();
            for (int i4 = 0; i4 < objectArray.length; ++i4) {
                if (!(objectArray[i4] instanceof TextSelectionAction)) continue;
                actionMap.remove(objectArray[i4]);
            }
            actionMap.put(this.r.getValue("Name"), null);
            actionMap.put(TransferHandler.getCopyAction().getValue("Name"), null);
            documentViewport.setTransferHandler(null);
            this.s = null;
        }
        documentViewport.requestFocusInWindow();
    }

    private TextSelection a(PagePanel pagePanel) {
        for (int i2 = 0; i2 < pagePanel.getComponentCount(); ++i2) {
            Component component = pagePanel.getComponent(i2);
            if (!(component instanceof e_) || ((e_)component).a() != this) continue;
            return (TextSelection)component;
        }
        return null;
    }

    private TextSelection b(PagePanel pagePanel) {
        TextSelection textSelection = this.a(pagePanel);
        if (textSelection == null) {
            textSelection = new e_(this.x, this.v, this.w, this.y);
            textSelection.setBounds(new Rectangle(0, 0, pagePanel.getWidth(), pagePanel.getHeight()));
            pagePanel.setExtractText(true);
            pagePanel.add(textSelection);
        }
        return textSelection;
    }

    private void a(boolean bl) {
        if (this.s != null) {
            for (PagePanel pagePanel : this.s.getPagePanels()) {
                TextSelection textSelection = this.b(pagePanel);
                textSelection.repaint();
                textSelection.setCursor(Cursor.getPredefinedCursor(bl ? 3 : 2));
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getOppositeComponent() instanceof JTextComponent) {
            this.clear();
        }
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        String string = documentPanelEvent.getType();
        DocumentPanel documentPanel = documentPanelEvent.getDocumentPanel();
        if (this.s != null && (string == "viewportChanged" || string == "activated")) {
            if (documentPanel.getPDF() != null) {
                this.updateViewport(documentPanel.getViewport(), this.isSelected());
            }
        } else if (this.z != null && string == "loaded") {
            final PDFParser pDFParser = documentPanel.getParser();
            Thread thread = new Thread(){

                public void run() {
                    TextTool.this.a(pDFParser, TextTool.this.z);
                    TextTool.this.setSelected(true);
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        if (string == "pageChanged") {
            this.a(documentPanel.getViewport());
        }
    }

    public void pageUpdated(PagePanelEvent pagePanelEvent) {
        PagePanel pagePanel;
        if (this.isSelected() && (pagePanel = pagePanelEvent.getPagePanel()) != null) {
            if (pagePanelEvent.getType() == "redrawing") {
                pagePanel.setExtractText(true);
            } else if (pagePanelEvent.getType() == "redrawn") {
                this.b(pagePanel);
            }
        }
    }

    public void copy() {
        Action action = TransferHandler.getCopyAction();
        if (this.s != null) {
            action.actionPerformed(new ActionEvent(this.s, 1001, (String)action.getValue("Name")));
        }
    }

    public void selectAll() {
        List list = this.s.getDocumentPanel().getParser().getPageExtractors();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PageExtractor pageExtractor = (PageExtractor)list.get(i2);
            PageExtractor.Text text = null;
            PageExtractor.Text text22 = null;
            for (PageExtractor.Text text22 : pageExtractor.getTextUnordered()) {
                if (text != null) continue;
                text = text22;
            }
            if (text22 == null) {
                this.a(pageExtractor, null);
            } else {
                this.a(pageExtractor, new TextSelection.RangeList(TextSelection.Range.createRange(text, 0, text22, text22.getTextLength() - 1)));
            }
            this.a(i2 != list.size() - 1);
        }
    }

    public void clear() {
        if (this.s != null && this.s.getDocumentPanel() != null) {
            this.a(this.s.getDocumentPanel().getPDF());
        }
    }

    public void select(PageExtractor.Text text) {
        Object object;
        if (!this.isSelected() && this.D) {
            this.setSelected(true);
        }
        if (this.s == null) {
            object = this.getViewer().getActiveDocumentPanel();
            this.s = ((DocumentPanel)object).getViewport();
        }
        this.clear();
        object = text.getPage();
        PageExtractor pageExtractor = text.getPageExtractor();
        this.a(pageExtractor, new TextSelection.RangeList(TextSelection.Range.createRange(text)));
        this.E = text;
        float[] fArray = text.getCorners();
        float f2 = fArray[2];
        float f3 = fArray[3];
        this.s.ensureVisible((PDFPage)object, f2, f3);
        this.a(this.s);
    }

    private void a(DocumentViewport documentViewport) {
        if (this.E != null) {
            PDFPage pDFPage = this.E.getPage();
            for (PagePanel pagePanel : documentViewport.getPagePanels()) {
                if (pagePanel.getPage() != pDFPage) continue;
                this.b(pagePanel);
                pagePanel.repaint();
                this.E = null;
            }
        }
    }

    public void select(Collection collection) {
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = new HashMap();
        for (PageExtractor.Text object42 : collection) {
            object3 = object42.getPageExtractor();
            object2 = ((PageExtractor)object3).getPage().getPDF();
            HashMap hashMap2 = (HashMap)hashMap.get(object2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(object2, hashMap2);
            }
            if ((object = (ArrayList<TextSelection.Range>)hashMap2.get(object3)) == null) {
                object = new ArrayList<TextSelection.Range>();
                hashMap2.put(object3, object);
            }
            object.add(TextSelection.Range.createRange(object42));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object3 = (PDF)entry.getKey();
            object2 = (Map)entry.getValue();
            this.a((PDF)object3);
            for (Map.Entry entry2 : object2.entrySet()) {
                object = (PageExtractor)entry2.getKey();
                this.a((PageExtractor)object, new TextSelection.RangeList((List)entry2.getValue()));
            }
        }
        this.a(false);
    }

    public void select(Pattern pattern) {
        this.a(this.s.getDocumentPanel().getParser(), pattern);
    }

    private void a(PDFParser pDFParser, Pattern pattern) {
        List list = pDFParser.getPageExtractors();
        ArrayList arrayList = new ArrayList();
        this.a(SwingUtilities.isEventDispatchThread());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PageExtractor pageExtractor = (PageExtractor)list.get(i2);
            arrayList.addAll(pageExtractor.getMatchingText(pattern));
        }
        this.select(arrayList);
    }

    public void pageAction(PagePanelInteractionEvent pagePanelInteractionEvent) {
        if (!this.isSelected()) {
            return;
        }
        if (pagePanelInteractionEvent.getMouseEvent().isPopupTrigger()) {
            MouseEvent mouseEvent = pagePanelInteractionEvent.getMouseEvent();
            PageExtractor pageExtractor = pagePanelInteractionEvent.getPagePanel().getPageExtractor();
            TextSelection.RangeList rangeList = this.a(pageExtractor);
            if (rangeList.isValid()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                boolean bl = false;
                ActionMap actionMap = this.s.getActionMap();
                Object[] objectArray = actionMap.keys();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    if (!(objectArray[i2] instanceof TextSelectionAction)) continue;
                    bl = true;
                    jPopupMenu.add(actionMap.get(objectArray[i2]));
                }
                if (bl) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            return;
        }
        if (this.t && pagePanelInteractionEvent.getMouseEvent().getButton() == 1 || this.B != null) {
            if (pagePanelInteractionEvent.getType() == "mousePressed") {
                this.clear();
                this.C = pagePanelInteractionEvent.getPagePanel().getPage().getPageNumber() - 1;
                this.B = pagePanelInteractionEvent.getPoint();
                this.b(pagePanelInteractionEvent.getPagePanel()).repaint();
            } else if (pagePanelInteractionEvent.getType() == "mouseDragged") {
                PagePanelInteractionEvent pagePanelInteractionEvent2 = pagePanelInteractionEvent.getEventOnNewPanel();
                if (pagePanelInteractionEvent2 != null) {
                    pagePanelInteractionEvent = pagePanelInteractionEvent2;
                }
                int n2 = pagePanelInteractionEvent.getPagePanel().getPage().getPageNumber() - 1;
                int n3 = Math.min(this.C, n2);
                int n4 = Math.max(this.C, n2);
                PDFParser pDFParser = pagePanelInteractionEvent.getPagePanel().getDocumentPanel().getParser();
                for (int i3 = n3; i3 <= n4; ++i3) {
                    Object object;
                    PageExtractor.Text text2;
                    PageExtractor pageExtractor = pDFParser.getPageExtractor(i3);
                    a_ a_2 = this.b(pageExtractor);
                    if (i3 == this.C) {
                        if (a_2.b() == null && (text2 = TextTool.a(pageExtractor, (Point2D)(object = this.B), this.y)) != null) {
                            a_2.a(text2, TextTool.b(text2, TextTool.a(text2, object)));
                        }
                    } else {
                        object = pageExtractor.getTextInDisplayOrder().iterator();
                        text2 = object.hasNext() ? (PageExtractor.Text)object.next() : null;
                        a_2.a(text2, 0);
                    }
                    if (i3 == n4) {
                        object = pagePanelInteractionEvent.getPoint();
                        text2 = TextTool.a(pageExtractor, object, this.y);
                        if (text2 != null) {
                            if (a_2.b() != null) {
                                a_2.b(text2, TextTool.b(text2, TextTool.a(text2, object)));
                            } else {
                                int n5 = TextTool.b(text2, TextTool.a(text2, this.B));
                                a_2.a(text2, n5 < 0 ? 0 : text2.getTextLength() - 1);
                            }
                        } else if (a_2.c() != null) {
                            text2 = a_2.c();
                            int n6 = TextTool.b(text2, TextTool.a(text2, object));
                            boolean bl = n6 < 0;
                            boolean bl2 = a_2.a();
                            if (bl && bl2) {
                                n6 = 0;
                            } else if (!bl && !bl2) {
                                n6 = text2.getTextLength() - 1;
                            } else if (bl && !bl2) {
                                if ((text2 = TextTool.a(text2, -1)) != null) {
                                    n6 = text2.getTextLength() - 1;
                                } else {
                                    text2 = a_2.c();
                                    n6 = 0;
                                }
                            } else if ((text2 = TextTool.a(text2, 1)) != null) {
                                n6 = 0;
                            } else {
                                text2 = a_2.c();
                                n6 = text2.getTextLength() - 1;
                            }
                            a_2.b(text2, n6);
                        }
                    } else {
                        text2 = null;
                        for (PageExtractor.Text text2 : pageExtractor.getTextInDisplayOrder()) {
                        }
                        a_2.b(text2, text2 == null ? 0 : text2.getTextLength() - 1);
                    }
                    object = null;
                    if (i3 == n2) {
                        object = pagePanelInteractionEvent.getPagePanel();
                    } else {
                        for (PagePanel pagePanel : pagePanelInteractionEvent.getPagePanel().getViewport().getPagePanels()) {
                            if (pagePanel.getPage().getPageNumber() != i3) continue;
                            object = pagePanel;
                            break;
                        }
                    }
                    if (object == null) continue;
                    this.b((PagePanel)object).repaint();
                }
            } else if (pagePanelInteractionEvent.getType() == "mouseClicked") {
                Point2D point2D;
                PageExtractor pageExtractor;
                PageExtractor.Text text;
                int n7 = pagePanelInteractionEvent.getMouseEvent().getClickCount();
                if ((n7 == 2 || n7 == 3) && (text = TextTool.a(pageExtractor = pagePanelInteractionEvent.getPagePanel().getPageExtractor(), point2D = pagePanelInteractionEvent.getPoint(), this.y)) != null) {
                    a_ a_3 = this.b(pageExtractor);
                    String string = text.getText();
                    if (n7 == 2) {
                        int n8 = TextTool.b(text, TextTool.a(text, point2D));
                        int n9 = -1;
                        for (int i4 = 0; i4 <= string.length(); ++i4) {
                            if (i4 != string.length() && string.charAt(i4) != ' ') continue;
                            if (i4 < n8) {
                                n9 = i4;
                                continue;
                            }
                            a_3.a(text, n9 + 1);
                            a_3.b(text, i4 - 1);
                            break;
                        }
                    } else if (n7 == 3) {
                        a_3.a(text, 0);
                        a_3.b(text, string.length() - 1);
                    }
                }
                this.b(pagePanelInteractionEvent.getPagePanel()).repaint();
            } else if (pagePanelInteractionEvent.getType() == "mouseReleased") {
                this.B = null;
                this.C = -1;
            }
        }
    }

    static Shape a(PageExtractor.Text text, float f2, boolean bl) {
        return TextTool.a(text, 0, text.getTextLength() - 1, f2, bl);
    }

    static Shape a(PageExtractor.Text text, int n2, int n3, float f2, boolean bl) {
        if (n2 < 0 || n3 < n2) {
            return null;
        }
        float[] fArray = text.getCorners();
        if (f2 != 0.0f) {
            double d2 = Math.sqrt((fArray[6] - fArray[0]) * (fArray[6] - fArray[0]) + (fArray[7] - fArray[1]) * (fArray[7] - fArray[1]));
            double d3 = Math.sqrt((fArray[2] - fArray[0]) * (fArray[2] - fArray[0]) + (fArray[3] - fArray[1]) * (fArray[3] - fArray[1]));
            if (d2 != 0.0 && d3 != 0.0) {
                double d4 = (double)((fArray[6] - fArray[0]) * f2) / d2;
                double d5 = (double)((fArray[2] - fArray[0]) * f2) / d3;
                double d6 = (double)((fArray[7] - fArray[1]) * f2) / d2;
                double d7 = (double)((fArray[3] - fArray[1]) * f2) / d3;
                fArray[0] = (float)((double)fArray[0] - (d4 + d5));
                fArray[1] = (float)((double)fArray[1] - (d6 + d7));
                fArray[2] = (float)((double)fArray[2] + (d5 - d4));
                fArray[3] = (float)((double)fArray[3] + (d7 - d6));
                fArray[4] = (float)((double)fArray[4] + (d4 + d5));
                fArray[5] = (float)((double)fArray[5] + (d6 + d7));
                fArray[6] = (float)((double)fArray[6] + (d4 - d5));
                fArray[7] = (float)((double)fArray[7] + (d6 - d7));
            }
        }
        float f3 = text.getOffset(n2);
        float f4 = text.getOffset(n3 + 1);
        float f5 = fArray[6] - fArray[0];
        float f6 = fArray[7] - fArray[1];
        if (f6 == 0.0f && f5 > 0.0f && !bl) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0] + f5 * f3, fArray[1], f5 * (f4 - f3), fArray[3] - fArray[1]);
            return float_;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0] + f3 * f5, fArray[1] + f3 * f6);
        generalPath.lineTo(fArray[2] + f3 * f5, fArray[3] + f3 * f6);
        generalPath.lineTo(fArray[2] + f4 * f5, fArray[3] + f4 * f6);
        generalPath.lineTo(fArray[0] + f4 * f5, fArray[1] + f4 * f6);
        generalPath.closePath();
        return generalPath;
    }

    private static PageExtractor.Text a(PageExtractor pageExtractor, Point2D point2D, float f2) {
        for (PageExtractor.Text text : pageExtractor.getTextUnordered()) {
            if (!TextTool.a(text, f2, false).contains(point2D)) continue;
            return text;
        }
        return null;
    }

    private static PageExtractor.Text a(PageExtractor.Text text, int n2) {
        PageExtractor.Text text2 = null;
        PageExtractor pageExtractor = text.getPageExtractor();
        Iterator iterator = pageExtractor.getTextUnordered().iterator();
        while (iterator.hasNext()) {
            PageExtractor.Text text3 = (PageExtractor.Text)iterator.next();
            if (text3 == text) {
                if (n2 == -1) {
                    return text2;
                }
                if (n2 == 1) {
                    return iterator.hasNext() ? (PageExtractor.Text)iterator.next() : null;
                }
            }
            text2 = text3;
        }
        return null;
    }

    private static Point2D a(PageExtractor.Text text, Point2D point2D) {
        float[] fArray = text.getCorners();
        double d2 = fArray[3] - fArray[1];
        double d3 = fArray[2] - fArray[0];
        double d4 = fArray[6] - fArray[0];
        double d5 = fArray[7] - fArray[1];
        double d6 = point2D.getX() - (double)fArray[0];
        double d7 = point2D.getY() - (double)fArray[1];
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        double d9 = Math.atan2(d6, d7) - Math.atan2(d4, d5);
        double d10 = Math.sin(d9) * d8 / Math.sqrt(d2 * d2 + d3 * d3);
        double d11 = Math.sin(1.5707963267948966 - d9) * d8 / Math.sqrt(d4 * d4 + d5 * d5);
        return new Point2D.Double(d11, d10 + 1.0);
    }

    private static int b(PageExtractor.Text text, Point2D point2D) {
        if (point2D.getY() < 0.0) {
            return -1;
        }
        if (point2D.getY() > 1.0) {
            return text.getTextLength();
        }
        if (point2D.getX() <= 0.0) {
            return -1;
        }
        if (point2D.getX() >= 1.0) {
            return text.getTextLength();
        }
        String string = text.getText();
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (!(point2D.getX() < (double)text.getOffset(i2))) continue;
            return i2 - 1;
        }
        return string.length() - 1;
    }

    private static class a_
    extends TextSelection.Range {
        private WeakReference a;
        private WeakReference b;
        private int c;
        private int d;
        private boolean e;

        private a_() {
        }

        public boolean isValid() {
            return this.b() != null && this.c() != null;
        }

        boolean a() {
            return this.e;
        }

        public PageExtractor.Text getFirst() {
            return this.e ? this.c() : this.b();
        }

        public PageExtractor.Text getLast() {
            return this.e ? this.b() : this.c();
        }

        public int getFirstPosition() {
            return this.e ? this.d : this.c;
        }

        public int getLastPosition() {
            return this.e ? this.c : this.d;
        }

        PageExtractor.Text b() {
            return this.a == null ? null : (PageExtractor.Text)this.a.get();
        }

        PageExtractor.Text c() {
            return this.b == null ? null : (PageExtractor.Text)this.b.get();
        }

        public String toString() {
            return "(" + this.b() + ":" + this.c + (this.e ? " <- " : " -> ") + this.c() + ":" + this.d + ")";
        }

        void a(PageExtractor.Text text, int n2) {
            this.a = text == null ? null : new WeakReference<PageExtractor.Text>(text);
            this.c = n2;
            this.b = null;
            this.e = false;
        }

        void b(PageExtractor.Text text, int n2) {
            this.b = text == null ? null : new WeakReference<PageExtractor.Text>(text);
            this.d = n2;
            this.e = this.b == null ? false : (this.c() == this.b() ? this.d < this.c : this.b().compareTo(this.c()) > 0);
        }
    }

    private class e_
    extends TextSelection {
        private e_(int n2, Paint paint, Stroke stroke, float f2) {
            super(n2, paint, stroke, f2);
            this.setCursor(Cursor.getPredefinedCursor(2));
        }

        TextTool a() {
            return TextTool.this;
        }

        protected TextSelection.RangeList getRangeList() {
            return TextTool.this.a(((PagePanel)this.getParent()).getPageExtractor());
        }

        public boolean isGlassPane() {
            return TextTool.this.s == null;
        }
    }
}

