/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerFeature;

public final class Undo
extends ViewerFeature
implements ActionListener,
UndoableEditListener,
DocumentPanelListener {
    public static final UndoableEdit DISCARD = new AbstractUndoableEdit(){};
    private PDFViewer b;
    private Map c = new WeakHashMap();
    private JMenuItem d;
    private JMenuItem e;

    public Undo() {
        super("Undo");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        UndoManager undoManager = (UndoManager)this.c.get(this.b.getActiveDocumentPanel());
        if (actionEvent.getSource() == this.d && undoManager.canUndo()) {
            undoManager.undo();
            this.a();
        } else if (actionEvent.getSource() == this.e && undoManager.canRedo()) {
            undoManager.redo();
            this.a();
        }
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        this.b = pDFViewer;
        this.d = pDFViewer.setMenu("Edit\tUndo", 'z', true, this);
        this.e = pDFViewer.setMenu("Edit\tRedo", 'y', true, this);
        pDFViewer.getMenu("Edit").add(new JPopupMenu.Separator());
        pDFViewer.addDocumentPanelListener(this);
        this.a();
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        String string = documentPanelEvent.getType();
        if (string == "closing") {
            documentPanelEvent.getDocumentPanel().removeUndoableEditListener(this);
            this.c.remove(documentPanelEvent.getDocumentPanel());
            this.a();
        } else if (string == "loaded") {
            documentPanelEvent.getDocumentPanel().addUndoableEditListener(this);
            UndoManager undoManager = new UndoManager();
            this.c.put(documentPanelEvent.getDocumentPanel(), undoManager);
            undoManager.setLimit(10);
            this.a();
        } else if (string == "deactivated" || string == "activated") {
            this.a();
        }
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        DocumentPanel documentPanel = (DocumentPanel)undoableEditEvent.getSource();
        UndoManager undoManager = (UndoManager)this.c.get(documentPanel);
        if (undoableEditEvent.getEdit() == DISCARD) {
            undoManager.discardAllEdits();
        } else {
            undoManager.undoableEditHappened(undoableEditEvent);
        }
        this.a();
    }

    private void a() {
        UndoManager undoManager;
        DocumentPanel documentPanel = this.b.getActiveDocumentPanel();
        UndoManager undoManager2 = undoManager = documentPanel == null ? null : (UndoManager)this.c.get(documentPanel);
        if (undoManager == null || !undoManager.canUndo()) {
            this.d.setText(UIManager.getString("AbstractUndoableEdit.undoText"));
            this.d.setEnabled(false);
        } else {
            this.d.setText(undoManager.getUndoPresentationName());
            this.d.setEnabled(true);
        }
        if (undoManager == null || !undoManager.canRedo()) {
            this.e.setText(UIManager.getString("AbstractUndoableEdit.redoText"));
            this.e.setEnabled(false);
        } else {
            this.e.setText(undoManager.getRedoPresentationName());
            this.e.setEnabled(true);
        }
    }
}

