/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ToggleViewerWidget;
import org.faceless.pdf2.viewer2.ViewerEvent;

public class ZoomFit
extends ToggleViewerWidget
implements DocumentPanelListener {
    public ZoomFit() {
        super("FitPage", "Zoom");
        this.setButton("Navigation", "resources/icons/ZoomFit.png", "PDFViewer.tt.ZoomFit");
        this.setMenu("View\tZoom\tZoomFit", '0');
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        String string = documentPanelEvent.getType();
        if (string == "redrawn" || string == "activated" || string == "viewportChanged") {
            int n2 = documentPanelEvent.getDocumentPanel().getViewport().getZoomMode();
            this.setSelected(n2 == 1);
        }
    }

    public void action(ViewerEvent viewerEvent) {
        DocumentPanel documentPanel = viewerEvent.getDocumentPanel();
        PDFPage pDFPage = null;
        if (documentPanel != null && (pDFPage = documentPanel.getPage()) != null) {
            super.action(viewerEvent);
            if (this.isSelected()) {
                documentPanel.getViewport().setZoomMode(1);
                documentPanel.runAction(PDFAction.goToFit(pDFPage));
            } else {
                documentPanel.getViewport().setZoomMode(0);
            }
        }
    }
}

