/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ToggleViewerWidget;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerWidget;
import org.faceless.pdf2.viewer2.feature.ZoomFit;
import org.faceless.pdf2.viewer2.feature.ZoomFitHeight;
import org.faceless.pdf2.viewer2.feature.ZoomFitWidth;

public class ZoomLevel
extends ViewerWidget
implements DocumentPanelListener {
    private JComboBox n = new JComboBox<String>(new String[]{"15%", "25%", "50%", "75%", "100%", "125%", "150%", "200%", "400%", "800%", "1600%", "2400%", "3200%", "6400%"});
    private boolean o;

    public ZoomLevel() {
        super("ZoomLevel");
        this.n.setSelectedItem("100%");
        this.n.putClientProperty("JComponent.sizeVariant", "small");
        this.n.setEditable(true);
        this.n.setFont(null);
        this.n.setEnabled(false);
        this.n.setPrototypeDisplayValue("6400%");
        if (this.n.getEditor().getEditorComponent() instanceof JTextField) {
            int n2 = Util.isLAFAqua() ? 3 : 4;
            ((JTextField)this.n.getEditor().getEditorComponent()).setColumns(n2);
        }
        this.n.setToolTipText(UIManager.getString("PDFViewer.tt.ZoomLevel"));
        this.n.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent actionEvent) {
                DocumentPanel documentPanel = ZoomLevel.this.getViewer().getActiveDocumentPanel();
                if (documentPanel == null) return;
                if (ZoomLevel.this.n.getSelectedItem() == null) return;
                float f2 = documentPanel.getZoom();
                String string = (String)ZoomLevel.this.n.getSelectedItem();
                try {
                    float f3;
                    if (string.endsWith("%")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if ((double)Math.abs((f3 = Float.parseFloat(string) / 100.0f) - f2) > 0.01) {
                        documentPanel.getViewport().setZoomMode(0);
                        documentPanel.setZoom(f3);
                        if (!ZoomLevel.this.o) {
                            ToggleViewerWidget toggleViewerWidget = (ToggleViewerWidget)ZoomLevel.this.getViewer().getFeature(ZoomFit.class);
                            if (toggleViewerWidget != null && toggleViewerWidget.isSelected()) {
                                toggleViewerWidget.setSelected(false);
                            }
                            if ((toggleViewerWidget = (ToggleViewerWidget)ZoomLevel.this.getViewer().getFeature(ZoomFitWidth.class)) != null && toggleViewerWidget.isSelected()) {
                                toggleViewerWidget.setSelected(false);
                            }
                            if ((toggleViewerWidget = (ToggleViewerWidget)ZoomLevel.this.getViewer().getFeature(ZoomFitHeight.class)) != null && toggleViewerWidget.isSelected()) {
                                toggleViewerWidget.setSelected(false);
                            }
                            documentPanel.getViewport().setZoomMode(0);
                        }
                        ZoomLevel.this.o = false;
                    }
                }
                catch (Exception exception) {
                    ZoomLevel.this.n.setSelectedItem(Integer.toString(Math.round(f2 * 100.0f)) + "%");
                }
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component == null) return;
                if (component != ZoomLevel.this.n) {
                    if (!ZoomLevel.this.n.isAncestorOf(component)) return;
                }
                documentPanel.getViewport().requestFocusInWindow();
            }
        });
        this.setComponent("Navigation", this.n);
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (documentPanelEvent.getType() == "redrawn" || documentPanelEvent.getType() == "activated") {
            this.o = true;
            this.n.setSelectedItem(Integer.toString(Math.round(documentPanelEvent.getDocumentPanel().getZoom() * 100.0f)) + "%");
        }
    }
}

