/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.viewer2.KeyStoreManager;
import org.faceless.util.CombinedKeyStore;
import org.faceless.util.SortedListModel;

public class KeyStoreAliasList
extends JList
implements Comparator,
ListCellRenderer,
PropertyChangeListener {
    private KeyStoreManager a;
    private SortedListModel b;
    private final boolean c;
    private final boolean d;
    private static final Color e = new Color(0, true);

    public KeyStoreAliasList(boolean bl, boolean bl2) {
        this.c = bl;
        this.d = bl2;
        this.b = new SortedListModel(this);
        this.setVisibleRowCount(6);
        this.setModel(this.b);
        this.setCellRenderer(this);
    }

    public KeyStoreAliasList(KeyStoreManager keyStoreManager, boolean bl, boolean bl2) {
        this(bl, bl2);
        this.setKeyStoreManager(keyStoreManager);
    }

    public KeyStoreManager getKeyStoreManager() {
        return this.a;
    }

    public void setKeyStoreManager(KeyStoreManager keyStoreManager) {
        try {
            KeyStore keyStore;
            if (this.a != null) {
                this.a.removePropertyChangeListener(this);
                this.b.clear();
            }
            this.a = keyStoreManager;
            try {
                keyStore = keyStoreManager.getKeyStore();
            }
            catch (Exception exception) {
                keyStore = null;
            }
            if (keyStore != null) {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (!this.isDisplayed(keyStore, string)) continue;
                    this.b.add(string);
                }
                keyStoreManager.addPropertyChangeListener(this);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("alias")) return;
        try {
            if (propertyChangeEvent.getOldValue() != null) {
                this.b.remove(propertyChangeEvent.getOldValue());
            }
            if (propertyChangeEvent.getNewValue() == null) return;
            if (!this.isDisplayed(this.a.getKeyStore(), (String)propertyChangeEvent.getNewValue())) return;
            this.b.add(propertyChangeEvent.getNewValue());
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean isDisplayed(KeyStore keyStore, String string) {
        try {
            if (this.c && keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
                return true;
            }
            return !this.c && keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEnabled(KeyStore keyStore, String string) {
        return true;
    }

    public boolean isReadOnly(KeyStore keyStore, String string) {
        if (keyStore instanceof CombinedKeyStore) {
            CombinedKeyStore combinedKeyStore = (CombinedKeyStore)keyStore;
            return combinedKeyStore.isReadOnly(string);
        }
        return false;
    }

    public int compare(Object object, Object object2) {
        int n2;
        block11: {
            n2 = 0;
            try {
                String string;
                Object object3;
                Object object4;
                X509Certificate x509Certificate;
                block12: {
                    KeyStore keyStore = this.a.getKeyStore();
                    if (object == object2) break block11;
                    x509Certificate = (X509Certificate)keyStore.getCertificate((String)object);
                    if (x509Certificate == null && (object4 = keyStore.getCertificateChain((String)object)) != null) {
                        x509Certificate = (X509Certificate)object4[0];
                    }
                    if ((object4 = (X509Certificate)keyStore.getCertificate((String)object2)) == null && (object3 = keyStore.getCertificateChain((String)object2)) != null) {
                        object4 = (X509Certificate)object3[0];
                    }
                    if (x509Certificate != null || object4 != null) break block12;
                    return 0;
                }
                if (x509Certificate == null) {
                    return 1;
                }
                if (object4 == null) {
                    return -1;
                }
                object3 = x509Certificate.getSubjectX500Principal().toString();
                n2 = ((String)object3).compareTo(string = ((X509Certificate)object4).getSubjectX500Principal().toString());
                if (n2 == 0) {
                    n2 = x509Certificate.getNotAfter().compareTo(((X509Certificate)object4).getNotAfter());
                }
                if (n2 == 0) {
                    n2 = x509Certificate.getSerialNumber().compareTo(((X509Certificate)object4).getSerialNumber());
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                n2 = object.hashCode() - object2.hashCode();
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
        try {
            Object object2;
            KeyStore keyStore = this.a.getKeyStore();
            String string = (String)object;
            boolean bl4 = this.isEnabled(keyStore, string);
            bl &= bl4;
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null && (object2 = keyStore.getCertificateChain(string)) != null) {
                x509Certificate = (X509Certificate)object2[0];
            }
            Object object3 = object2 = x509Certificate == null ? string : FormSignature.getSubjectField(x509Certificate, "CN");
            if (object2 == null) {
                object2 = FormSignature.getSubjectField(x509Certificate, "O");
            }
            JLabel jLabel = new JLabel((String)object2);
            boolean bl5 = bl4 && !this.isReadOnly(keyStore, string);
            jLabel.setEnabled(bl5);
            try {
                x509Certificate.checkValidity();
                jLabel.setIcon(new ImageIcon(KeyStoreManager.class.getResource("resources/icons/accept.png")));
            }
            catch (Exception exception) {
                jLabel.setIcon(new ImageIcon(KeyStoreManager.class.getResource("resources/icons/error.png")));
                jLabel.setToolTipText(UIManager.getString("PDFViewer.InvalidWhy").replaceAll("\\{1\\}", exception.getMessage() == null ? exception.toString() : exception.getMessage()));
            }
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jLabel);
            jPanel.setOpaque(true);
            jPanel.setBackground(bl ? jList.getSelectionBackground() : e);
            jPanel.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            jPanel.setFont(jList.getFont());
            jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            return jPanel;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

