/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.feature.TextSelection;
import org.faceless.pdf2.viewer2.feature.TextTool;
import org.faceless.util.AttributedStringBuilder;

public class RichTextTransferHandler
extends TransferHandler {
    private static final DataFlavor a;
    private static final DataFlavor b;
    private static final DataFlavor c;
    private final TextTool d;

    public RichTextTransferHandler() {
        this.d = null;
    }

    public RichTextTransferHandler(TextTool textTool) {
        this.d = textTool;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.d == null && jComponent instanceof JTextComponent && dataFlavorArray != null) {
            for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                if (dataFlavorArray[i2] != a && dataFlavorArray[i2] != b && dataFlavorArray[i2] != c) continue;
                return true;
            }
        }
        return false;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        block17: {
            if (this.d != null || !(jComponent instanceof JTextComponent)) break block17;
            try {
                JTextComponent jTextComponent;
                block18: {
                    jTextComponent = (JTextComponent)jComponent;
                    if (!(jTextComponent.getDocument() instanceof HTMLDocument) || !transferable.isDataFlavorSupported(c)) break block18;
                    int n2 = jTextComponent.getSelectionStart();
                    int n3 = jTextComponent.getSelectionEnd();
                    if (n3 > n2) {
                        jTextComponent.getDocument().remove(n2, n3 - n2);
                    }
                    HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jTextComponent.getUI().getEditorKit(jTextComponent);
                    StringReader stringReader = new StringReader((String)transferable.getTransferData(c));
                    hTMLEditorKit.read(stringReader, jTextComponent.getDocument(), n2);
                    return true;
                }
                if (jTextComponent.getDocument() instanceof StyledDocument && transferable.isDataFlavorSupported(b)) {
                    int n4 = jTextComponent.getSelectionStart();
                    int n5 = jTextComponent.getSelectionEnd();
                    if (n5 > n4) {
                        jTextComponent.getDocument().remove(n4, n5 - n4);
                    }
                    RTFEditorKit rTFEditorKit = new RTFEditorKit();
                    StyledDocument styledDocument = (StyledDocument)rTFEditorKit.createDefaultDocument();
                    InputStream inputStream = (InputStream)transferable.getTransferData(b);
                    rTFEditorKit.read(inputStream, (Document)styledDocument, 0);
                    inputStream.close();
                    StyledDocument styledDocument2 = (StyledDocument)jTextComponent.getDocument();
                    for (int i2 = 0; i2 < styledDocument.getLength(); ++i2) {
                        styledDocument2.insertString(n4 + i2, styledDocument.getText(i2, 1), styledDocument.getCharacterElement(i2).getAttributes());
                    }
                    return true;
                }
                if (transferable.isDataFlavorSupported(a)) {
                    jTextComponent.replaceSelection((String)transferable.getTransferData(a));
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        DocumentPanel documentPanel;
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            return new RichTransferable(jTextComponent.getDocument(), jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd());
        }
        if (this.d != null && (documentPanel = (DocumentPanel)SwingUtilities.getAncestorOfClass(DocumentPanel.class, jComponent)) != null) {
            TextSelection.RangeList rangeList = this.d.getRangeList();
            return new RichTransferable(rangeList.getStyledText());
        }
        return null;
    }

    public int getSourceActions(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            return jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd() ? 0 : 1;
        }
        if (this.d != null) {
            return this.d.getRangeList().isValid() ? 1 : 0;
        }
        return 0;
    }

    private static void a(AttributedString attributedString, Appendable appendable) throws IOException {
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        char c2 = attributedCharacterIterator.first();
        while (true) {
            Object object;
            block32: {
                if (c2 == '\uffff') break;
                if (c2 != '\n') break block32;
                appendable.append("<br />\n");
                c2 = attributedCharacterIterator.next();
                continue;
            }
            int n2 = attributedCharacterIterator.getIndex();
            int n3 = attributedCharacterIterator.getRunLimit();
            appendable.append("<span style='");
            String string = (String)attributedCharacterIterator.getAttribute(TextAttribute.FAMILY);
            Number number = (Number)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            boolean bl = attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT) == TextAttribute.WEIGHT_BOLD;
            boolean bl2 = bl;
            boolean bl3 = attributedCharacterIterator.getAttribute(TextAttribute.POSTURE) == TextAttribute.POSTURE_OBLIQUE;
            boolean bl4 = bl3;
            appendable.append("font:");
            if (number != null) {
                appendable.append(Integer.toString(number.intValue()));
                appendable.append("pt \"");
            }
            appendable.append(string);
            appendable.append("\";");
            Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
            if (paint instanceof Color) {
                object = (Color)paint;
                appendable.append("color:#");
                appendable.append(RichTextTransferHandler.a(((Color)object).getRed(), 2));
                appendable.append(RichTextTransferHandler.a(((Color)object).getGreen(), 2));
                appendable.append(RichTextTransferHandler.a(((Color)object).getBlue(), 2));
                appendable.append(";");
            }
            appendable.append("'>");
            if (bl2) {
                appendable.append("<b>");
            }
            if (bl4) {
                appendable.append("<i>");
            }
            do {
                block34: {
                    block36: {
                        if (c2 == '<') {
                            appendable.append("&lt;");
                        } else {
                            block35: {
                                block33: {
                                    if (c2 != '>') break block33;
                                    appendable.append("&gt;");
                                    break block34;
                                }
                                if (c2 != '&') break block35;
                                appendable.append("&amp;");
                                break block34;
                            }
                            if (c2 < '\u007f' && c2 >= ' ') break block36;
                            object = Integer.toHexString(c2);
                            appendable.append("&#x");
                            appendable.append((CharSequence)object);
                            appendable.append(";");
                        }
                        break block34;
                    }
                    appendable.append(c2);
                }
                c2 = attributedCharacterIterator.next();
            } while (attributedCharacterIterator.getIndex() < n3);
            if (bl4) {
                appendable.append("</i>");
            }
            if (bl2) {
                appendable.append("</b>");
            }
            appendable.append("</span>");
        }
    }

    private static final String a(int n2, int n3) {
        String string = Integer.toHexString(n2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = string.length(); i2 < n3; ++i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void b(AttributedString attributedString, Appendable appendable) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            string = (String)attributedCharacterIterator.getAttribute(TextAttribute.FAMILY);
            Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
            if (string != null && !arrayList.contains(string)) {
                stringBuilder.append("\\f");
                stringBuilder.append(Integer.toString(arrayList.size()));
                stringBuilder.append("\\fnil ");
                stringBuilder.append(string);
                stringBuilder.append(";");
                arrayList.add(string);
            }
            if (paint instanceof Color && !arrayList2.contains(paint)) {
                Color color = (Color)paint;
                arrayList2.add(color);
                stringBuilder2.append("\\red");
                stringBuilder2.append(Integer.toString(color.getRed()));
                stringBuilder2.append("\\green");
                stringBuilder2.append(Integer.toString(color.getGreen()));
                stringBuilder2.append("\\blue");
                stringBuilder2.append(Integer.toString(color.getBlue()));
                stringBuilder2.append(";");
            }
            c2 = attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        appendable.append("{\\rtf1\\ansi");
        appendable.append("{\\fonttbl");
        appendable.append(stringBuilder);
        appendable.append("}");
        appendable.append("{\\colortbl");
        appendable.append(stringBuilder2);
        appendable.append("}");
        attributedCharacterIterator = attributedString.getIterator();
        c2 = attributedCharacterIterator.first();
        while (true) {
            Paint paint;
            int n2;
            Number number;
            boolean bl;
            boolean bl2;
            if (c2 == '\uffff') {
                appendable.append("}");
                return;
            }
            if (c2 == '\n') {
                appendable.append("\\par");
                c2 = attributedCharacterIterator.next();
                continue;
            }
            appendable.append("{");
            string = (String)attributedCharacterIterator.getAttribute(TextAttribute.FAMILY);
            int n3 = arrayList.indexOf(string);
            if (n3 >= 0) {
                appendable.append("\\f");
                appendable.append(Integer.toString(n3));
            }
            boolean bl3 = bl2 = attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT) == TextAttribute.WEIGHT_BOLD;
            if (bl2) {
                appendable.append("\\b");
            }
            boolean bl4 = bl = attributedCharacterIterator.getAttribute(TextAttribute.POSTURE) == TextAttribute.POSTURE_OBLIQUE;
            if (bl) {
                appendable.append("\\i");
            }
            if ((number = (Number)attributedCharacterIterator.getAttribute(TextAttribute.SIZE)) != null) {
                appendable.append("\\fs");
                appendable.append(Integer.toString((int)Math.ceil(number.doubleValue() * 2.0)));
            }
            if ((n2 = arrayList2.indexOf(paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND))) >= 0) {
                appendable.append("\\cf");
                appendable.append(Integer.toString(n2));
            }
            appendable.append(" ");
            int n4 = attributedCharacterIterator.getRunLimit();
            do {
                if (c2 == '\\') {
                    appendable.append("\\\\");
                } else if (c2 == '{') {
                    appendable.append("\\{");
                } else if (c2 == '}') {
                    appendable.append("\\}");
                } else if (c2 >= '\u007f' || c2 < ' ') {
                    appendable.append("\\u");
                    appendable.append(Short.toString((short)c2));
                    appendable.append('?');
                } else {
                    appendable.append(c2);
                }
                c2 = attributedCharacterIterator.next();
            } while (attributedCharacterIterator.getIndex() < n4);
            appendable.append("}");
        }
    }

    static {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor = new DataFlavor("text/rtf;class=java.io.InputStream");
            dataFlavor2 = new DataFlavor("text/html;class=java.lang.String");
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        a = DataFlavor.stringFlavor;
        b = dataFlavor;
        c = dataFlavor2;
    }

    public static class RichTransferable
    implements Transferable {
        private final AttributedString a;
        private final Document b;
        private final int c;
        private final int d;

        public RichTransferable(AttributedString attributedString) {
            this.a = attributedString;
            this.b = null;
            this.d = 0;
            this.c = 0;
        }

        public RichTransferable(Document document, int n2, int n3) {
            this.a = null;
            this.b = document;
            this.c = n2;
            this.d = n3 - n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DataFlavor[] getTransferDataFlavors() {
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            arrayList.add(a);
            if (this.a != null || this.b instanceof HTMLDocument) {
                arrayList.add(c);
            }
            if (this.a == null) {
                if (!(this.b instanceof StyledDocument)) return arrayList.toArray(new DataFlavor[0]);
            }
            arrayList.add(b);
            return arrayList.toArray(new DataFlavor[0]);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (a.equals(dataFlavor)) return true;
            if (b.equals(dataFlavor)) {
                if (this.a != null) return true;
                if (this.b instanceof StyledDocument) return true;
            }
            if (!c.equals(dataFlavor)) return false;
            if (this.a != null) return true;
            if (!(this.b instanceof HTMLDocument)) return false;
            return true;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws IOException {
            try {
                if (a.equals(dataFlavor)) {
                    if (this.b != null) {
                        return this.b.getText(this.c, this.d);
                    }
                    return new AttributedStringBuilder(this.a).toString().trim();
                }
                if (c.equals(dataFlavor)) {
                    Object object;
                    StringWriter stringWriter = new StringWriter();
                    if (this.b != null) {
                        object = new HTMLEditorKit();
                        ((HTMLEditorKit)object).write(stringWriter, this.b, this.c, this.d);
                    } else {
                        RichTextTransferHandler.a(this.a, stringWriter);
                    }
                    if (dataFlavor.isRepresentationClassInputStream()) {
                        object = dataFlavor.getParameter("charset");
                        if (object == null) {
                            object = "ISO-8859-1";
                        }
                        return new ByteArrayInputStream(stringWriter.toString().getBytes((String)object));
                    }
                    return stringWriter.toString();
                }
                if (b.equals(dataFlavor)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    if (this.b != null) {
                        RTFEditorKit rTFEditorKit = new RTFEditorKit();
                        rTFEditorKit.write(byteArrayOutputStream, this.b, this.c, this.d);
                    } else {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "ISO-8859-1");
                        RichTextTransferHandler.b(this.a, outputStreamWriter);
                        outputStreamWriter.close();
                    }
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                throw new IllegalArgumentException("Unsupported Flavor: " + dataFlavor.getMimeType());
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
        }
    }
}

