/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class X509Util {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate generateCertificate(String string, KeyPair keyPair, int n2, String string2) throws GeneralSecurityException {
        if (string == null || string.length() == 0) {
            throw new GeneralSecurityException("Empty distinguished name!");
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            X509CertInfo x509CertInfo = new X509CertInfo();
            Date date = new Date();
            Date date2 = new Date(date.getTime() + (long)n2 * 86400000L);
            CertificateValidity certificateValidity = new CertificateValidity(date, date2);
            CertificateSerialNumber certificateSerialNumber = new CertificateSerialNumber(new BigInteger(64, new Random()));
            X500Name x500Name = new X500Name(string);
            x509CertInfo.set("validity", certificateValidity);
            x509CertInfo.set("serialNumber", certificateSerialNumber);
            x509CertInfo.set("subject", new CertificateSubjectName(x500Name));
            x509CertInfo.set("issuer", new CertificateIssuerName(x500Name));
            x509CertInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
            x509CertInfo.set("version", new CertificateVersion(2));
            AlgorithmId algorithmId = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
            x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algorithmId));
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(privateKey, string2);
            algorithmId = (AlgorithmId)x509CertImpl.get("x509.algorithm");
            x509CertInfo.set("algorithmID.algorithm", algorithmId);
            x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(privateKey, string2);
            return x509CertImpl;
        }
        catch (IOException iOException) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Failed generating certificate for DN=" + string);
            generalSecurityException.initCause(iOException);
            throw generalSecurityException;
        }
    }
}

