/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.Map;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.Node;
import org.xml.sax.SAXException;

class BarCode
extends AbstractBlock {
    private org.faceless.pdf2.BarCode s;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BarCode(Map map) throws SAXException {
        super(map);
        if (this.getAttribute(Atts.CODETYPE) == null) {
            this.document.error("Missing \"codetype\" attribute in barcode");
        }
        if (this.getStringAttribute(Atts.VALUE) == null || this.getStringAttribute(Atts.VALUE).length() == 0) {
            this.document.error("Missing \"value\" attribute in barcode");
        }
        String string = this.b();
        String string2 = this.getStringAttribute(Atts.VALUE);
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 < '\ue000' || c2 > '\ue0ff') continue;
            string2 = string2.substring(0, i2) + (char)(c2 - 57344) + string2.substring(i2 + 1);
        }
        float f2 = this.getNumAttribute(Atts.BAR_WIDTH);
        float f3 = this.getNumAttribute(Atts.BAR_RATIO);
        if (string.equals("maxicode")) {
            try {
                this.s = org.faceless.pdf2.BarCode.newMaxiCode(string2, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.s = org.faceless.pdf2.BarCode.newMaxiCode(string2, false);
            }
        } else if (string.equals("qrcode")) {
            int n2 = this.getIntAttribute(Atts.WIDTH);
            int n3 = this.getIntAttribute(Atts.HEIGHT);
            if (n2 == 0 && n3 == 0) {
                this.document.error("Missing or zero width/height attribute for QRCode");
            }
            this.s = org.faceless.pdf2.BarCode.newQRCode(string2, (double)0.21f, 2, 0);
        } else if (string.equals("pdf417")) {
            this.s = org.faceless.pdf2.BarCode.newPDF417(string2, 0.5f, -1, 0);
        } else if (string.equals("aztec")) {
            this.s = org.faceless.pdf2.BarCode.newAztecCode(string2);
        } else if (string.equals("datamatrix")) {
            int n4 = this.getIntAttribute(Atts.WIDTH);
            int n5 = this.getIntAttribute(Atts.HEIGHT);
            this.s = n5 != 0 && n4 / n5 > 1 ? org.faceless.pdf2.BarCode.newDataMatrixCode(string2, n4 / n5, 1) : (n4 != 0 && n5 / n4 > 1 ? org.faceless.pdf2.BarCode.newDataMatrixCode(string2, 1, n5 / n4) : org.faceless.pdf2.BarCode.newDataMatrixCode(string2));
        } else if (string.equals("code39")) {
            this.s = org.faceless.pdf2.BarCode.newCode39(string2, false, f2 == 0.0f ? 1.0f : f2, f3 == 0.0f ? 2.8f : f3);
        } else if (string.equals("code39checksum")) {
            this.s = org.faceless.pdf2.BarCode.newCode39(string2, true, f2 == 0.0f ? 1.0f : f2, f3 == 0.0f ? 2.8f : f3);
        } else if (string.equals("code39xchecksum")) {
            this.s = org.faceless.pdf2.BarCode.newCode39Extended(string2, true, f2 == 0.0f ? 1.0f : f2, f3 == 0.0f ? 2.8f : f3);
        } else if (string.equals("code39x")) {
            this.s = org.faceless.pdf2.BarCode.newCode39Extended(string2, true, f2 == 0.0f ? 1.0f : f2, f3 == 0.0f ? 2.8f : f3);
        } else if (string.equals("code25")) {
            this.s = org.faceless.pdf2.BarCode.newInterleaved25(string2, false, f2 == 0.0f ? 1.0f : f2, f3 == 0.0f ? 2.8f : f3);
        } else if (string.equals("code25checksum")) {
            this.s = org.faceless.pdf2.BarCode.newInterleaved25(string2, true, f2 == 0.0f ? 1.0f : f2, f3 == 0.0f ? 2.8f : f3);
        } else if (string.equals("code128")) {
            this.s = org.faceless.pdf2.BarCode.newCode128(string2, f2 == 0.0f ? 1.0 : (double)f2);
        } else if (string.equals("ean13")) {
            this.s = org.faceless.pdf2.BarCode.newEAN13(string2);
        } else if (string.equals("ean8")) {
            this.s = org.faceless.pdf2.BarCode.newEAN8(string2);
        } else if (string.equals("codabar")) {
            this.s = org.faceless.pdf2.BarCode.newCodabar(string2, f2 == 0.0f ? 1.0f : f2);
        } else if (string.equals("upca")) {
            this.s = org.faceless.pdf2.BarCode.newEAN13("0" + string2);
        } else if (string.equals("postnet")) {
            this.s = org.faceless.pdf2.BarCode.newPostnet(string2);
        } else if (string.equals("rm4scc")) {
            this.s = org.faceless.pdf2.BarCode.newRM4SCC(string2);
        } else if (string.equals("code25deutschenpost")) {
            this.s = org.faceless.pdf2.BarCode.newDeutschePostCode(string2);
        } else if (string.equals("intelligentmail")) {
            this.s = org.faceless.pdf2.BarCode.newIntelligentMail(string2);
        } else {
            this.document.error("Illegal <" + this.getTag() + "> codetype attribute \"" + this.getStringAttribute(Atts.CODETYPE) + "\"");
        }
        if (this.hasAttribute(Atts.SHOWTEXT)) {
            this.s.setShowText(this.getBooleanAttribute(Atts.SHOWTEXT));
        }
        if (!this.hasAttribute(Atts.COLOR)) return;
        this.s.setColor(this.getColorAttribute(Atts.COLOR));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String b() throws SAXException {
        String string = this.getStringAttribute(Atts.CODETYPE).trim().toLowerCase();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == ' ' || string.charAt(n2) == '-') {
                string = string.substring(0, n2) + string.substring(n2 + 1);
                --n2;
            }
            ++n2;
        }
        return string;
    }

    public void addKid(Node node) throws SAXException {
        this.document.warning("<" + this.getTag() + "> can't have kids: <" + node.getTag() + "> ignored");
    }

    void draw() throws SAXException {
        if (this.debug) {
            this.a("in BarCode.draw()");
        }
        if (this.drawBackground()) {
            PDFCanvas pDFCanvas = this.s.getCanvas();
            this.m.drawCanvas(pDFCanvas, this.x + this.ml + this.pl + this.bl, this.y + this.mt + this.pt + this.bt, this.x + this.w - this.mr - this.pr - this.br, this.y + this.h - this.mb - this.pb - this.bb);
        }
        this.postDrawBackground();
        if (this.debug) {
            this.a("out BarCode.draw()");
        }
    }

    public float setWidth(float f2) throws SAXException {
        if (this.debug) {
            this.a("in BarCode.setWidth maxwidth=" + f2);
        }
        f2 = this.setEdges(f2);
        float f3 = this.getNumAttribute(Atts.WIDTH, f2);
        float f4 = this.getNumAttribute(Atts.HEIGHT, f2);
        try {
            if (f3 != 0.0f) {
                this.s.setWidth(f3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (f4 != 0.0f) {
                this.s.setHeight(f4);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.w = this.s.getWidth();
        this.h = this.s.getHeight();
        String string = this.b();
        this.w += this.edgew();
        this.h += this.edgeh();
        if (this.w < this.getNumAttribute(Atts.WIDTH, f2)) {
            this.w = this.getNumAttribute(Atts.WIDTH, f2);
        }
        if (this.w < this.getNumAttribute(Atts.MIN_WIDTH, f2)) {
            this.w = this.getNumAttribute(Atts.MIN_WIDTH, f2);
        }
        if (this.debug) {
            this.a("out BarCode.setWidth: w=" + this.w + " h=" + this.h);
        }
        return this.w;
    }

    public float getMCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public float getOCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public float setHeight() {
        return this.h;
    }

    public AbstractBlock split(float f2) {
        return this;
    }
}

