/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.awt.Paint;
import java.util.Locale;
import java.util.Map;
import org.faceless.graph.AbstractBarGraph;
import org.faceless.graph.AxesGraph;
import org.faceless.graph.DepthBarGraph;
import org.faceless.graph.FloatingBarGraph;
import org.faceless.graph.Graph;
import org.faceless.graph.MultiBarGraph;
import org.faceless.graph.TowerBarGraph;
import org.faceless.graph.output.PDF2Output;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.GraphData;
import org.faceless.report.Node;
import org.faceless.report.PieGraph;
import org.xml.sax.SAXException;

class BarGraph
extends AbstractBlock {
    AbstractBarGraph s;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BarGraph(Map map) throws SAXException {
        super(map);
        if (this.getTag().equals("bargraph")) {
            this.s = new org.faceless.graph.BarGraph();
        } else if (this.getTag().equals("towerbargraph")) {
            this.s = new TowerBarGraph();
        } else if (this.getTag().equals("depthbargraph")) {
            this.s = new DepthBarGraph();
        } else if (this.getTag().equals("multibargraph")) {
            this.s = new MultiBarGraph();
        } else if (this.getTag().equals("floatingbargraph")) {
            this.s = new FloatingBarGraph();
        }
        if (this.getAttribute(Atts.WIDTH) != null) {
            if (this.getAttribute(Atts.HEIGHT) != null) return;
        }
        this.document.error("Must specify width and height for <" + this.getTag() + ">");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setWidth(float f2) throws SAXException {
        this.setEdges(f2);
        this.w = this.getNumAttribute(Atts.WIDTH, f2 - this.edgew());
        if (this.hasAttribute(Atts.MIN_WIDTH)) {
            this.w = Math.max(this.w, this.getNumAttribute(Atts.MIN_WIDTH, f2 - this.edgew()));
        }
        this.h = this.getNumAttribute(Atts.HEIGHT, this.getParent() instanceof AbstractBlock ? Math.max(0.0f, this.getParent().getNumAttribute(Atts.HEIGHT, 0.0f) - ((AbstractBlock)this.getParent()).edgeh()) : 0.0f);
        if (this.w == 0.0f || this.h == 0.0f) {
            this.document.error("Must specify width and height for <" + this.getTag() + ">");
        }
        this.w += this.edgew();
        this.h += this.edgeh();
        this.h = Math.max(this.h, this.getNumAttribute(Atts.MIN_HEIGHT, 0.0f));
        return this.w;
    }

    public float setHeight() {
        return this.h;
    }

    public float getMCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public float getOCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public AbstractBlock split(float f2) {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void draw() throws SAXException {
        if (this.debug) {
            this.a("in BarGraph.draw: " + this.kids.size() + " kids");
        }
        Locale locale = this.getLocale();
        Locale locale2 = null;
        if (locale != null) {
            locale2 = this.document.getPDF().getLocale();
            this.document.getPDF().setLocale(locale);
        }
        if (this.drawBackground()) {
            Paint[] paintArray;
            int n2 = (int)(this.x + this.ml + this.pl + this.bl);
            int n3 = (int)(this.y + this.mt + this.pt + this.bt);
            int n4 = (int)(this.x + this.w - this.edgew());
            int n5 = (int)(this.y + this.h - this.edgeh());
            this.m.setUnits(1.0f, 0);
            PDF2Output pDF2Output = new PDF2Output(this.m, n2, this.m.getHeight() - n3, n4, this.m.getHeight() - n5);
            PieGraph.a((Node)this, (Graph)this.s, pDF2Output);
            PieGraph.a((Node)this, (AxesGraph)this.s, pDF2Output);
            PieGraph.a((Node)this, this.s, pDF2Output);
            if (this.s instanceof DepthBarGraph) {
                if (this.hasAttribute(Atts.KEY_ON_X)) {
                    ((DepthBarGraph)this.s).optionKeyOnX(this.getBooleanAttribute(Atts.KEY_ON_X));
                }
            } else if (this.s instanceof FloatingBarGraph && this.hasAttribute(Atts.DEFAULT_COLORS) && (paintArray = (Paint[])this.getAttribute(Atts.DEFAULT_COLORS)).length > 0) {
                ((FloatingBarGraph)this.s).setColor("MIN", paintArray[0]);
                ((FloatingBarGraph)this.s).setColor("MAX", paintArray[paintArray.length > 1 ? 1 : 0]);
            }
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                GraphData graphData = (GraphData)this.kids.get(i2);
                String string = graphData.getStringAttribute(Atts.NAME);
                String string2 = graphData.getStringAttribute(Atts.NAME2);
                if (string2 == null) {
                    string2 = "";
                }
                if (this.s instanceof org.faceless.graph.BarGraph) {
                    if (graphData.hasAttribute(Atts.COLOR)) {
                        ((org.faceless.graph.BarGraph)this.s).setColor(string, graphData.getPaintAttribute(Atts.COLOR));
                    }
                    if (!graphData.hasAttribute(Atts.VALUE)) continue;
                    ((org.faceless.graph.BarGraph)this.s).set(string, Double.parseDouble(graphData.getStringAttribute(Atts.VALUE)));
                    continue;
                }
                if (this.s instanceof DepthBarGraph) {
                    if (graphData.hasAttribute(Atts.COLOR)) {
                        ((DepthBarGraph)this.s).setColor(string, graphData.getPaintAttribute(Atts.COLOR));
                    }
                    if (!graphData.hasAttribute(Atts.VALUE)) continue;
                    ((DepthBarGraph)this.s).set(string, string2, Double.parseDouble(graphData.getStringAttribute(Atts.VALUE)));
                    continue;
                }
                if (this.s instanceof MultiBarGraph) {
                    if (graphData.hasAttribute(Atts.COLOR)) {
                        ((MultiBarGraph)this.s).setColor(string2, graphData.getPaintAttribute(Atts.COLOR));
                    }
                    if (!graphData.hasAttribute(Atts.VALUE)) continue;
                    ((MultiBarGraph)this.s).set(string, string2, Double.parseDouble(graphData.getStringAttribute(Atts.VALUE)));
                    continue;
                }
                if (this.s instanceof TowerBarGraph) {
                    if (graphData.hasAttribute(Atts.COLOR)) {
                        ((TowerBarGraph)this.s).setColor(string, graphData.getPaintAttribute(Atts.COLOR));
                    }
                    if (!graphData.hasAttribute(Atts.VALUE)) continue;
                    ((TowerBarGraph)this.s).set(string, string2, Double.parseDouble(graphData.getStringAttribute(Atts.VALUE)));
                    continue;
                }
                if (!(this.s instanceof FloatingBarGraph)) continue;
                if (graphData.hasAttribute(Atts.COLOR)) {
                    ((FloatingBarGraph)this.s).setColor(string, graphData.getPaintAttribute(Atts.COLOR));
                }
                if (!graphData.hasAttribute(Atts.MIN_VALUE) && !graphData.hasAttribute(Atts.MAX_VALUE) && !graphData.hasAttribute(Atts.MID_VALUE)) continue;
                if (!(graphData.hasAttribute(Atts.MIN_VALUE) && graphData.hasAttribute(Atts.MAX_VALUE) && graphData.hasAttribute(Atts.MID_VALUE))) {
                    this.document.warning("<" + graphData.getTag() + "> element must have min-value, center-value and max-value specified for <" + this.getTag() + ">");
                    continue;
                }
                ((FloatingBarGraph)this.s).set(string, Double.parseDouble(graphData.getStringAttribute(Atts.MIN_VALUE)), Double.parseDouble(graphData.getStringAttribute(Atts.MID_VALUE)), Double.parseDouble(graphData.getStringAttribute(Atts.MAX_VALUE)));
            }
            pDF2Output.render(this.s);
            this.m.setUnits(1.0f, 1);
        }
        this.postDrawBackground();
        if (locale2 != null) {
            this.document.getPDF().setLocale(locale2);
        }
        if (!this.debug) return;
        this.a("out BarGraph.draw");
    }
}

