/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.faceless.lexer.RuleHandler;
import org.faceless.lexer.RuleSet;
import org.faceless.lexer.SimpleEscaper;
import org.faceless.report.Atts;
import org.faceless.report.CSSEntry;
import org.faceless.report.CSSEntryKey;
import org.faceless.report.MyURL;
import org.faceless.report.Node;
import org.faceless.report.ParserHandler;

final class CSS
implements RuleHandler {
    private Map a;
    private Map b;
    private MyURL c;
    static final Object d = " ANC ";
    static final Object e = " PAR ";
    static final Object f = " PREV ";
    static final Object g = " NEXT ";
    private Set h;
    private Stack i;
    private ArrayList j = new ArrayList();
    private Map k = new HashMap();
    private Map l;
    private String m;
    private String n;
    private String o;
    private String p;
    private int q;
    private int r;

    public CSS() {
        this.i = new Stack();
        this.h = new HashSet();
        this.a = new HashMap();
        this.b = new HashMap();
    }

    public CSS(CSS cSS) {
        this();
        Collection collection;
        for (Object k2 : cSS.a.keySet()) {
            collection = (Collection)cSS.a.get(k2);
            this.a.put(k2, new ArrayList(collection));
        }
        for (Object k2 : cSS.b.keySet()) {
            collection = (Collection)cSS.b.get(k2);
            this.b.put(k2, new ArrayList(collection));
        }
        this.c = cSS.c;
        this.q = cSS.q;
    }

    void a(File file) throws IOException {
        this.a(new MyURL(file.toURL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(MyURL myURL) throws IOException {
        URLConnection uRLConnection = myURL.d();
        String string = uRLConnection.getContentType();
        if (string != null) {
            int n2 = string.indexOf("charset=");
            string = n2 > 0 ? string.substring(n2 + 8) : null;
        }
        if (string == null) {
            string = "US-ASCII";
        }
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            this.parse(new InputStreamReader(inputStream, string), myURL);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Reader reader, MyURL myURL) throws IOException {
        InputStream inputStream = null;
        try {
            String string;
            RuleSet ruleSet = new RuleSet("stylesheet");
            inputStream = ParserHandler.getResourceFromJar("org/faceless/report/resources/cssparser.grammar");
            if (inputStream == null) throw new InternalError("Can't load \"cssparser.grammar\": Not found");
            ruleSet.add(new InputStreamReader(inputStream, "ISO-8859-1"));
            ruleSet.compile();
            ruleSet.addCallback("elementname", this);
            ruleSet.addCallback("id", this);
            ruleSet.addCallback("selector", this);
            ruleSet.addCallback("class", this);
            ruleSet.addCallback("pseudo", this);
            ruleSet.addCallback("attsel", this);
            ruleSet.addCallback("combinator", this);
            ruleSet.addCallback("property", this);
            ruleSet.addCallback("expr", this, new SimpleEscaper());
            ruleSet.addCallback("ruleset", this);
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            reader.close();
            boolean bl = false;
            for (int n2 = 0; n2 < stringBuffer.length() - 1; ++n2) {
                if (!bl && stringBuffer.charAt(n2) == '/' && stringBuffer.charAt(n2 + 1) == '*') {
                    bl = true;
                } else if (bl && stringBuffer.charAt(n2) == '*' && stringBuffer.charAt(n2 + 1) == '/') {
                    stringBuffer.setCharAt(n2, ' ');
                    stringBuffer.setCharAt(n2 + 1, ' ');
                    bl = false;
                }
                if (!bl) continue;
                stringBuffer.setCharAt(n2, ' ');
            }
            CSS cSS = this;
            synchronized (cSS) {
                this.c = myURL;
                if (ruleSet.parse(stringBuffer.toString())) return;
                throw new IOException("WARNING: Failed to parse stylesheet after " + ruleSet.getParseLength() + " of " + ruleSet.getInputLength() + " characters: Last attribute read was '" + this.p + "'");
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void match(String string, String string2) {
        if (string.equals("elementname")) {
            this.m = string2.toLowerCase().intern();
        } else if (string.equals("id")) {
            this.n = string2.substring(1).intern();
        } else if (string.equals("class")) {
            this.o = string2.substring(1).intern();
        } else if (string.equals("pseudo")) {
            this.j.add(string2.substring(1));
        } else if (string.equals("attsel")) {
            int n2 = (string2 = string2.substring(1, string2.length() - 1)).indexOf(61);
            if (n2 < 0) {
                string = string2;
                string2 = null;
            } else {
                string = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            }
            n2 = Atts.stringToAtt(string);
            if (Atts.attToString(n2).equals(string)) {
                if (this.l == null) {
                    this.l = new HashMap();
                }
                this.l.put(new Integer(n2), string2);
            }
        } else if (string.equals("combinator")) {
            this.i.push(new CSSEntryKey(this.m, this.n, this.o, this.j, this.l));
            if (string2.startsWith(">")) {
                this.i.push(e);
            } else if (string2.startsWith("-")) {
                this.i.push(g);
            } else if (string2.startsWith("+")) {
                this.i.push(f);
            } else {
                this.i.push(d);
            }
            this.j = new ArrayList();
            this.o = null;
            this.n = null;
            this.m = null;
            this.l = null;
        } else if (string.equals("selector")) {
            this.h.add(this.i);
            this.i = new Stack();
        } else if (string.equals("property")) {
            this.p = string2;
        } else if (string.equals("expr")) {
            if ((string2 = string2.trim()).endsWith("!important")) {
                this.r = 1;
                string2 = string2.substring(0, string2.length() - 10);
            } else if (string2.endsWith("!unimportant")) {
                this.r = -1;
                string2 = string2.substring(0, string2.length() - 12);
            }
            if (string2.charAt(0) == '\'') {
                string2 = string2.substring(1, string2.length() - 1);
            } else if (string2.startsWith("url(")) {
                if ((string2 = string2.substring(4, string2.length() - 1)).charAt(0) == '\'' || string2.charAt(0) == '\"') {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                string2 = string2.trim();
                try {
                    string2 = new MyURL(string2).a(this.c).toString();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                string2 = string2.trim();
            }
            this.k.put(this.p, string2);
        } else if (string.equals("ruleset")) {
            for (Stack stack : this.h) {
                stack.pop();
                CSSEntry cSSEntry = new CSSEntry(stack, this.q, this.k, this.r);
                cSSEntry.addToMap(cSSEntry.isPermEntry() ? this.a : this.b);
            }
            this.r = 0;
            this.k = new HashMap();
            this.i = new Stack();
            this.h = new HashSet();
        }
        ++this.q;
    }

    public String toString() {
        return this.a.toString() + this.b.toString();
    }

    public SortedSet getPermAttributes(Node node) {
        ArrayList arrayList = new ArrayList();
        TreeSet<CSSEntry> treeSet = new TreeSet<CSSEntry>(new CSSEntryComparator());
        Collection collection = (Collection)this.a.get(node.getTag());
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if ((collection = (Collection)this.a.get("#" + node.getId())) != null) {
            arrayList.addAll(collection);
        }
        String[] stringArray = node.getTagClasses();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            collection = (Collection)this.a.get("." + stringArray[i2]);
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        collection = (Collection)this.a.get("*");
        if (collection != null) {
            arrayList.addAll(collection);
        }
        for (CSSEntry cSSEntry : arrayList) {
            if (!cSSEntry.matches(node)) continue;
            treeSet.add(cSSEntry);
        }
        return treeSet;
    }

    public SortedSet getTransientAttributes(Node node) {
        ArrayList arrayList = new ArrayList();
        TreeSet<CSSEntry> treeSet = new TreeSet<CSSEntry>(new CSSEntryComparator());
        Collection collection = (Collection)this.b.get(node.getTag());
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if ((collection = (Collection)this.b.get("#" + node.getId())) != null) {
            arrayList.addAll(collection);
        }
        String[] stringArray = node.getTagClasses();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            collection = (Collection)this.b.get("." + stringArray[i2]);
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        collection = (Collection)this.b.get("*");
        if (collection != null) {
            arrayList.addAll(collection);
        }
        for (CSSEntry cSSEntry : arrayList) {
            if (!cSSEntry.matches(node)) continue;
            treeSet.add(cSSEntry);
        }
        return treeSet;
    }

    public void merge(CSS cSS) {
        Collection collection;
        for (Object k2 : cSS.a.keySet()) {
            collection = (Collection)this.a.get(k2);
            if (collection == null) {
                this.a.put(k2, cSS.a.get(k2));
                continue;
            }
            for (CSSEntry cSSEntry : (Collection)cSS.a.get(k2)) {
                cSSEntry.addScore(this.q);
                collection.add(cSSEntry);
            }
        }
        for (Object k2 : cSS.b.keySet()) {
            collection = (Collection)this.b.get(k2);
            if (collection == null) {
                this.b.put(k2, cSS.b.get(k2));
                continue;
            }
            for (CSSEntry cSSEntry : (Collection)cSS.b.get(k2)) {
                cSSEntry.addScore(this.q);
                collection.add(cSSEntry);
            }
        }
        this.q += cSS.q;
    }

    public static void main(String[] stringArray) {
        try {
            CSS cSS = new CSS();
            cSS.a(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class CSSEntryComparator
    implements Comparator {
        private CSSEntryComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((CSSEntry)object).score() - ((CSSEntry)object2).score();
        }

        public boolean equals(Object object, Object object2) {
            return object.equals(object2);
        }
    }
}

