/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.faceless.report.Node;
import org.faceless.report.Page;

final class CSSEntryKey {
    private final int a = 0x4000000;
    private final int b = 262144;
    private final int c = 1024;
    private final String d;
    private final String e;
    private final String f;
    private final Collection g;
    private final String[] h;
    private final Map i;

    public CSSEntryKey(String string, String string2, String string3, Collection collection, Map map) {
        this.d = string == "*" ? null : string;
        this.f = string2;
        this.e = string3;
        this.i = map;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (string4.startsWith("lang(")) {
                string4 = string4.substring(5, string4.length() - 1).toLowerCase().replace(',', ' ').replace('-', '_').trim();
                int n2 = string4.indexOf(32);
                while (n2 >= 0) {
                    hashSet.add(string4.substring(0, n2).trim());
                    string4 = string4.substring(n2 + 1).trim();
                    n2 = string4.indexOf(32);
                }
                hashSet.add(string4);
                iterator.remove();
                continue;
            }
            if (string4.equals("first-child") || string4.equals("last-child") || string4.equals("left") || string4.equals("right")) continue;
            iterator.remove();
        }
        this.g = collection.isEmpty() ? null : collection;
        this.h = hashSet.isEmpty() ? null : hashSet.toArray(new String[0]);
    }

    public boolean matches(Node node) {
        if (node == null) {
            return false;
        }
        if (this.d != null && this.d != node.getTag()) {
            return false;
        }
        if (this.e != null) {
            String[] stringArray = node.getTagClasses();
            boolean bl = false;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (this.e != stringArray[i2]) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.f != null && this.f != node.getId()) {
            return false;
        }
        if (this.g != null) {
            if (this.g.contains("first-child") && node.getPrevSibling() != null) {
                return false;
            }
            if (this.g.contains("last-child") && node.getNextSibling() != null) {
                return false;
            }
            if (this.g.contains("left") && node instanceof Page && ((Page)node).pagenumber % 2 == 0) {
                return false;
            }
            if (this.g.contains("right") && node instanceof Page && ((Page)node).pagenumber % 2 == 1) {
                return false;
            }
        }
        if (this.h != null) {
            boolean bl = false;
            Locale locale = node.getLocale();
            String string = locale.getLanguage();
            String string2 = locale.getCountry();
            for (int i3 = 0; i3 < this.h.length; ++i3) {
                if (!this.h[i3].equals(string) && (string2 == null || this.h[i3].length() != 5 || !this.h[i3].startsWith(string) || !this.h[i3].regionMatches(true, 3, string2, 0, 2))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.i != null) {
            for (Integer n2 : this.i.keySet()) {
                String string = (String)this.i.get(n2);
                int n3 = n2;
                Object object = node.getDirectAttribute(n3);
                if (object == null) {
                    return false;
                }
                if (string == null || object.toString().equals(string)) continue;
                return false;
            }
        }
        return true;
    }

    public int score() {
        int n2 = (this.d == null ? 0 : 1024) + (this.f == null ? 0 : 0x4000000) + (this.e == null ? 0 : 262144);
        if (this.h != null) {
            n2 += 262144;
        }
        if (this.g != null) {
            n2 += this.g.size() * 262144;
        }
        if (this.i != null) {
            n2 += this.i.size() * 262144;
        }
        return n2;
    }

    public boolean isTransient() {
        return this.g != null || this.h != null;
    }

    public String toString() {
        String string = "<";
        if (this.d != null) {
            string = string + "T:" + this.d + " ";
        }
        if (this.e != null) {
            string = string + "C:" + this.e + " ";
        }
        if (this.f != null) {
            string = string + "I:" + this.f + " ";
        }
        if (this.g != null) {
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                string = string + "P:" + iterator.next() + " ";
            }
        }
        if (this.h != null) {
            for (int i2 = 0; i2 < this.h.length; ++i2) {
                string = string + "L:" + this.h[i2] + " ";
            }
        }
        if (string.equals("<")) {
            return "<*>";
        }
        return string.substring(0, string.length() - 1) + ">";
    }

    void a(Map map, Object object) {
        if (this.d != null) {
            this.a(map, this.d, object);
        } else if (this.f != null) {
            this.a(map, "#" + this.f, object);
        } else if (this.e != null) {
            this.a(map, "." + this.e, object);
        } else {
            this.a(map, "*", object);
        }
    }

    private void a(Map map, String string, Object object) {
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put(string, arrayList);
        }
        arrayList.add(object);
    }
}

