/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.awt.Color;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.faceless.graph.formatter.DateFormatter;
import org.faceless.graph.math.Curve;
import org.faceless.graph.math.DataCurve;
import org.faceless.graph.math.SimpleCurve;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.Node;
import org.xml.sax.SAXException;

class GraphCurve
extends AbstractBlock {
    Curve s;

    public GraphCurve(Map map) throws SAXException {
        super(map);
        if (this.getAttribute(Atts.NAME) == null) {
            this.document.error("Curve is missing a name");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addKid(Node node) throws SAXException {
        if (this.getTag().equals("simplecurve")) {
            this.document.warning("<" + this.getTag() + "> doesn't allow children: Ignoring <" + node.getTag() + ">");
            return;
        }
        if (this.getTag().equals("datacurve") && !node.getTag().equals("sample")) {
            this.document.warning("<" + this.getTag() + "> kid not a <sample>: Ignoring <" + node.getTag() + ">");
            return;
        }
        super.addKid(node);
    }

    public String getName() throws SAXException {
        return this.getStringAttribute(Atts.NAME);
    }

    public Color getColor() throws SAXException {
        return this.getColorAttribute(Atts.COLOR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMarker() throws SAXException {
        String[] stringArray = new String[]{"none", "square", "octagon", "diamond", "line", "uptriangle", "downtriangle", "circle"};
        String string = this.getStringAttribute(Atts.MARKER);
        if (string == null) return 0;
        string = string.toLowerCase();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.indexOf(stringArray[n2]) >= 0) {
                int n3;
                int n4 = n2 + (string.indexOf("only") >= 0 ? 256 : 0) + (string.indexOf("big") >= 0 ? 128 : 0) + (string.indexOf("small") >= 0 ? 1024 : 0);
                if (string.indexOf("noborder") >= 0) {
                    n3 = 512;
                    return n4 + n3;
                }
                n3 = 0;
                return n4 + n3;
            }
            ++n2;
        }
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Curve getCurve() throws SAXException {
        block16: {
            if (this.s != null) return this.s;
            if (this.getTag().equals("simplecurve")) {
            }
            if (!this.getTag().equals("datacurve")) return this.s;
            this.s = new DataCurve();
            int n2 = 0;
            while (n2 < this.kids.size()) {
                Node node = (Node)this.kids.get(n2);
                double d2 = 0.0;
                double d3 = 0.0;
                boolean bl = false;
                try {
                    d2 = this.d((String)node.getAttribute(Atts.X));
                }
                catch (SAXException sAXException) {
                    throw sAXException;
                }
                catch (Exception exception) {
                    this.document.warning("Invalid X-sample \"" + node.getAttribute(Atts.X) + "\" in curve \"" + this.getName() + "\": ignoring");
                    bl = true;
                }
                try {
                    d3 = this.c((String)node.getAttribute(Atts.Y));
                }
                catch (Exception exception) {
                    this.document.warning("Invalid Y-sample \"" + node.getAttribute(Atts.Y) + "\" in curve \"" + this.getName() + "\": ignoring");
                    bl = true;
                }
                if (!bl) {
                    ((DataCurve)this.s).set(d2, d3);
                }
                ++n2;
            }
            return this.s;
            try {}
            catch (NoSuchMethodException noSuchMethodException) {
                this.document.warning("Method name '" + this.getAttribute(Atts.METHOD) + "' is not a valid SimpleCurve method - ignoring");
                return this.s;
            }
            break block16;
            catch (SAXException sAXException) {
                throw sAXException;
            }
        }
        this.s = new SimpleCurve(this.getStringAttribute(Atts.METHOD));
        return this.s;
    }

    private double c(String string) {
        if (string.equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("+Inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-Inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    private double d(String string) throws SAXException {
        double d2 = Double.NaN;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Date date = GraphCurve.e(string);
            if (date == null) {
                this.document.error("Unable to parse date \"" + string + "\"");
            }
            d2 = DateFormatter.toDouble(date);
        }
        return d2;
    }

    private static Date e(String string) {
        Date date = null;
        if (date == null) {
            date = GraphCurve.a("E, d MMM yyyy HH:mm:ss z", string);
        }
        if (date == null) {
            date = GraphCurve.a("yyyy-MM-dd'T'HH:mm:ss", string);
        }
        if (date == null) {
            date = GraphCurve.a("yyyy-MM-dd'T'HH:mm", string);
        }
        if (date == null) {
            date = GraphCurve.a("yyyy-MM-dd'T'HH", string);
        }
        if (date == null) {
            date = GraphCurve.a("yyyy-MM-dd HH:mm:ss", string);
        }
        if (date == null) {
            date = GraphCurve.a("yyyy-MM-dd HH:mm", string);
        }
        if (date == null) {
            date = GraphCurve.a("yyyy-MM-dd", string);
        }
        return date;
    }

    private static Date a(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        ParsePosition parsePosition = new ParsePosition(0);
        simpleDateFormat.setLenient(false);
        try {
            Date date;
            block10: {
                int n2;
                block11: {
                    date = ((DateFormat)simpleDateFormat).parse(string2, parsePosition);
                    if (string.indexOf("'T'") <= 0 || parsePosition.getIndex() == string2.length()) break block10;
                    String string3 = string2.substring(parsePosition.getIndex());
                    string2 = string2.substring(0, parsePosition.getIndex());
                    if (string3.equals("Z")) {
                        string3 = "+0000";
                    }
                    if (string3.charAt(3) == ':') {
                        string3 = string3.substring(0, 3) + string3.substring(4);
                    }
                    String string4 = string3.substring(3);
                    if ((string3 = string3.substring(0, 3)).charAt(0) == '+') {
                        string3 = string3.substring(1);
                    }
                    n2 = (Integer.parseInt(string3) * 60 * 60 + Integer.parseInt(string4) * 60) * 1000;
                    TimeZone timeZone = TimeZone.getDefault();
                    n2 -= timeZone.getRawOffset();
                    if (!(timeZone instanceof SimpleTimeZone) || !((SimpleTimeZone)timeZone).inDaylightTime(date)) break block11;
                    n2 -= ((SimpleTimeZone)timeZone).getDSTSavings();
                }
                date = new Date(date.getTime() - (long)n2);
            }
            if (parsePosition.getIndex() != string2.length()) {
                date = null;
            }
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

