/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import org.faceless.graph.AbstractLineGraph;
import org.faceless.graph.AreaGraph;
import org.faceless.graph.AxesGraph;
import org.faceless.graph.Graph;
import org.faceless.graph.math.Curve;
import org.faceless.graph.output.PDF2Output;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.GraphCurve;
import org.faceless.report.Node;
import org.faceless.report.PieGraph;
import org.xml.sax.SAXException;

class LineGraph
extends AbstractBlock {
    AbstractLineGraph s;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LineGraph(Map map) throws SAXException {
        super(map);
        if (this.getTag().equals("linegraph")) {
            this.s = new org.faceless.graph.LineGraph();
        } else if (this.getTag().equals("areagraph")) {
            this.s = new AreaGraph();
        }
        if (this.getAttribute(Atts.WIDTH) != null) {
            if (this.getAttribute(Atts.HEIGHT) != null) return;
        }
        this.document.error("Must specify width and height for <" + this.getTag() + ">");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setWidth(float f2) throws SAXException {
        this.setEdges(f2);
        this.w = this.getNumAttribute(Atts.WIDTH, f2 - this.edgew());
        if (this.hasAttribute(Atts.MIN_WIDTH)) {
            this.w = Math.max(this.w, this.getNumAttribute(Atts.MIN_WIDTH, f2 - this.edgew()));
        }
        this.h = this.getNumAttribute(Atts.HEIGHT, this.getParent() instanceof AbstractBlock ? Math.max(0.0f, this.getParent().getNumAttribute(Atts.HEIGHT, 0.0f) - ((AbstractBlock)this.getParent()).edgeh()) : 0.0f);
        if (this.w == 0.0f || this.h == 0.0f) {
            this.document.error("Must specify width and height for <" + this.getTag() + ">");
        }
        this.w += this.edgew();
        this.h += this.edgeh();
        this.h = Math.max(this.h, this.getNumAttribute(Atts.MIN_HEIGHT, 0.0f));
        return this.w;
    }

    public float setHeight() {
        return this.h;
    }

    public float getMCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public float getOCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public AbstractBlock split(float f2) {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void draw() throws SAXException {
        if (this.debug) {
            this.a("in LineGraph.draw: " + this.kids.size() + " kids");
        }
        Locale locale = this.getLocale();
        Locale locale2 = null;
        if (locale != null) {
            locale2 = this.document.getPDF().getLocale();
            this.document.getPDF().setLocale(locale);
        }
        if (this.drawBackground()) {
            int n2 = (int)(this.x + this.ml + this.pl + this.bl);
            int n3 = (int)(this.y + this.mt + this.pt + this.bt);
            int n4 = (int)(this.x + this.w - this.edgew());
            int n5 = (int)(this.y + this.h - this.edgeh());
            this.m.setUnits(1.0f, 0);
            PDF2Output pDF2Output = new PDF2Output(this.m, n2, this.m.getHeight() - n3, n4, this.m.getHeight() - n5);
            PieGraph.a((Node)this, (Graph)this.s, pDF2Output);
            PieGraph.a((Node)this, (AxesGraph)this.s, pDF2Output);
            PieGraph.a((Node)this, this.s, pDF2Output);
            if (this.s instanceof AreaGraph) {
                if (this.hasAttribute(Atts.CUMULATIVE)) {
                    ((AreaGraph)this.s).optionCumulative(this.getBooleanAttribute(Atts.CUMULATIVE));
                }
                if (this.hasAttribute(Atts.DRAW_SEGMENTS)) {
                    ((AreaGraph)this.s).optionSegments(this.getBooleanAttribute(Atts.DRAW_SEGMENTS));
                }
            } else if (this.hasAttribute(Atts.LINE_THICKNESS)) {
                ((org.faceless.graph.LineGraph)this.s).optionLineThickness(this.getNumAttribute(Atts.LINE_THICKNESS));
            }
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                GraphCurve graphCurve = (GraphCurve)this.kids.get(i2);
                String string = graphCurve.getName();
                Color color = graphCurve.getColor();
                Curve curve = graphCurve.getCurve();
                if (curve == null) continue;
                if (color == null) {
                    this.s.setCurve(string, curve);
                } else {
                    this.s.setCurve(string, curve, color);
                }
                if (!(this.s instanceof org.faceless.graph.LineGraph)) continue;
                ((org.faceless.graph.LineGraph)this.s).setCurveMarker(string, graphCurve.getMarker());
            }
            pDF2Output.render(this.s);
            this.m.setUnits(1.0f, 1);
        }
        this.postDrawBackground();
        if (locale2 != null) {
            this.document.getPDF().setLocale(locale2);
        }
        if (!this.debug) return;
        this.a("out LineGraph.draw");
    }
}

