/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.faceless.pdf2.DiskCache;
import org.faceless.pdf2.PDF;
import org.faceless.report.MetaHandler;
import org.faceless.report.ReportParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PDFFilter
implements Filter,
ErrorHandler {
    private FilterConfig a = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        this.a = filterConfig;
        String string2 = this.a.getInitParameter("license");
        if (string2 == null) {
            string2 = this.a.getInitParameter("License");
        }
        if (string2 != null) {
            ReportParser.setLicenseKey(string2);
        }
        String string3 = this.a.getInitParameter("cache-prefix");
        if (string3 == null) {
            string3 = this.a.getInitParameter("Cache-prefix");
        }
        if (string3 == null) {
            string3 = this.a.getInitParameter("Cache-Prefix");
        }
        if ((string = this.a.getInitParameter("cache-minsize")) == null) {
            string = this.a.getInitParameter("Cache-minsize");
        }
        if (string == null) {
            string = this.a.getInitParameter("Cache-Minsize");
        }
        if (string == null) {
            string = "8192";
        }
        if (string3 != null) {
            string3 = string3.trim();
            if (string3.length() > 0) {
                PDF.setCache(new DiskCache(string3, Integer.parseInt(string)));
            }
        }
    }

    public void destroy() {
        this.a = null;
    }

    public FilterConfig getFilterConfig() {
        return this.a;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.a = filterConfig;
        String string = filterConfig.getInitParameter("license");
        if (string != null) {
            ReportParser.setLicenseKey(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.a == null) return;
        if (!(servletRequest instanceof HttpServletRequest)) return;
        if (!(servletResponse instanceof HttpServletResponse)) {
            return;
        }
        boolean bl = "contype".equals(((HttpServletRequest)servletRequest).getHeader("User-Agent"));
        CharResponseWrapper charResponseWrapper = new CharResponseWrapper((HttpServletResponse)servletResponse);
        filterChain.doFilter((ServletRequest)((HttpServletRequest)servletRequest), (ServletResponse)charResponseWrapper);
        if (charResponseWrapper.getStatus() >= 200 && charResponseWrapper.getStatus() <= 299 && charResponseWrapper.getContentType() != null && charResponseWrapper.getContentType().startsWith("text/xml")) {
            Object object;
            Object object2;
            if (bl) {
                servletResponse.setContentType("application/pdf");
                return;
            }
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(charResponseWrapper.getString().trim()));
            String string = ((HttpServletRequest)servletRequest).getRequestURL().toString();
            if (string != null && string.toLowerCase().startsWith("https:")) {
                try {
                    object2 = new URL(string);
                }
                catch (Throwable throwable) {
                    System.err.println("WARNING: HTTPS protocol not recognized by webserver (error is " + throwable.toString() + "). Switching to HTTP");
                    string = "http:" + string.substring(6);
                }
            }
            inputSource.setSystemId(string);
            object2 = null;
            try {
                object = ReportParser.getInstance(this.a.getInitParameter("org.xml.sax.driver"));
                ((ReportParser)object).setMetaHandler(new MetaCallback((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this));
                if ("false".equalsIgnoreCase(this.a.getInitParameter("org.faceless.report.flag.WarningUnknownTag"))) {
                    ((ReportParser)object).setFlag(0, false);
                }
                if ("false".equalsIgnoreCase(this.a.getInitParameter("org.faceless.report.flag.WarningUnknownAttribute"))) {
                    ((ReportParser)object).setFlag(3, false);
                }
                if ("false".equalsIgnoreCase(this.a.getInitParameter("org.faceless.report.flag.WarningMisplacedText"))) {
                    ((ReportParser)object).setFlag(1, false);
                }
                if ("true".equalsIgnoreCase(this.a.getInitParameter("org.faceless.report.flag.Debug"))) {
                    ((ReportParser)object).setFlag(2, true);
                }
                object2 = ((ReportParser)object).parse(inputSource);
            }
            catch (SAXException sAXException) {
                if (sAXException.getException() == null) throw new ServletException((Throwable)sAXException);
                throw new ServletException((Throwable)sAXException.getException());
            }
            this.modifyPDF((PDF)object2);
            object = new ByteArrayOutputStream();
            ((PDF)object2).render((OutputStream)object);
            servletResponse.setContentType("application/pdf");
            servletResponse.setContentLength(((ByteArrayOutputStream)object).size());
            ((ByteArrayOutputStream)object).writeTo((OutputStream)servletResponse.getOutputStream());
            servletResponse.getOutputStream().close();
            return;
        }
        if (charResponseWrapper.getContentType() != null) {
            servletResponse.setContentType(charResponseWrapper.getContentType());
        }
        servletResponse.getWriter().print(charResponseWrapper.getString());
    }

    protected void modifyPDF(PDF pDF) {
    }

    public void metaTag(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws ServletException, IOException {
        block6: {
            block5: {
                if (!string.startsWith("HTTP-")) break block5;
                httpServletResponse.setHeader(string.substring(5), string2);
                break block6;
            }
            if (string.equalsIgnoreCase("Servlet-FileName")) {
                httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + string2 + "\"");
            }
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder().append("PDF WARNING");
        String string = sAXParseException.getLineNumber() >= 0 ? " AT " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() : "";
        System.err.println(stringBuilder.append(string).append(": ").append(sAXParseException.getMessage()).toString());
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder().append("PDF ERROR");
        String string = sAXParseException.getLineNumber() >= 0 ? " AT " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() : "";
        System.err.println(stringBuilder.append(string).append(": ").append(sAXParseException.getMessage()).toString());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder().append("PDF FATAL ERROR");
        String string = sAXParseException.getLineNumber() >= 0 ? " AT " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() : "";
        System.err.println(stringBuilder.append(string).append(": ").append(sAXParseException.getMessage()).toString());
        throw sAXParseException;
    }

    private class MetaCallback
    implements MetaHandler {
        private HttpServletRequest a;
        private HttpServletResponse b;
        private PDFFilter c;

        public MetaCallback(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PDFFilter pDFFilter2) {
            this.a = httpServletRequest;
            this.b = httpServletResponse;
            this.c = pDFFilter2;
        }

        public void handleMetaTag(String string, String string2) throws SAXException {
            try {
                this.c.metaTag(this.a, this.b, string, string2);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    private class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private OutputStreamWrapper a;
        private PrintWriter b;
        private CharArrayWriter c;
        private int d;
        private String e;

        public CharResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this.d = 200;
        }

        public String getString() throws IOException {
            if (this.a != null) {
                return this.a.getString(this.getCharacterEncoding());
            }
            if (this.c != null) {
                return this.c.toString();
            }
            return "";
        }

        public PrintWriter getWriter() throws IOException {
            if (this.a != null) {
                throw new IllegalStateException("Already called getOutputStream");
            }
            if (this.c == null) {
                this.c = new CharArrayWriter();
                this.b = new PrintWriter(this.c);
            }
            return this.b;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.c != null) {
                throw new IllegalStateException("Already called getWriter");
            }
            if (this.a == null) {
                this.a = new OutputStreamWrapper();
            }
            return this.a;
        }

        public void flushBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() throws IllegalStateException {
            this.c = null;
            this.a = null;
            super.reset();
        }

        public void resetBuffer() {
            this.c = null;
            this.a = null;
        }

        public void sendError(int n2, String string) throws IOException {
            this.d = n2;
            super.sendError(n2, string);
        }

        public void sendError(int n2) throws IOException {
            this.d = n2;
            super.sendError(n2);
        }

        public void setStatus(int n2) {
            this.d = n2;
            super.setStatus(n2);
        }

        public void sendRedirect(String string) throws IOException {
            this.d = 302;
            super.sendRedirect(string);
        }

        public int getStatus() {
            return this.d;
        }

        public void setContentType(String string) {
            block3: {
                this.e = string;
                String string2 = PDFFilter.this.getFilterConfig().getServletContext().getServerInfo();
                if (string == null || string2.startsWith("Oracle Application Server")) break block3;
                int n2 = string.indexOf(59);
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
            }
            super.setContentType(string);
        }

        public void setHeader(String string, String string2) {
            block3: {
                block2: {
                    if (!"Content-Type".equalsIgnoreCase(string)) break block2;
                    this.setContentType(string2);
                    break block3;
                }
                super.setHeader(string, string2);
            }
        }

        public void setLocale(Locale locale) {
            super.setLocale(locale);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getCharacterEncoding() {
            String string = "";
            if (this.e != null && this.e.indexOf(";") > 0 && this.e.indexOf("charset") > 0) {
                int n2 = this.e.indexOf("charset") + 8;
                string = this.e.substring(n2).trim();
                if (string.charAt(0) == '=') {
                    string = string.substring(1).trim();
                }
                if (string.indexOf(";") >= 0) {
                    string = string.substring(0, string.indexOf(";")).trim();
                }
            }
            if (string.length() != 0) return string;
            return super.getCharacterEncoding();
        }

        public String getContentType() {
            return this.e;
        }

        private class OutputStreamWrapper
        extends ServletOutputStream {
            ByteArrayOutputStream a = new ByteArrayOutputStream();

            public void write(int n2) {
                this.a.write(n2);
            }

            public String getString(String string) throws IOException {
                String string2 = new String(this.a.toByteArray(), string);
                return string2;
            }
        }
    }
}

