/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.faceless.pdf2.PDF;
import org.faceless.report.MetaHandler;
import org.faceless.report.ReportParser;
import org.faceless.util.HttpProxyServlet;
import org.faceless.util.HttpRequestReader;
import org.faceless.util.HttpRequestWriter;
import org.faceless.util.HttpResponseReader;
import org.faceless.util.HttpResponseWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class PDFProxyServlet
extends HttpProxyServlet
implements ErrorHandler {
    public void init() throws ServletException {
        super.init();
        String string = this.getServletConfig().getInitParameter("license");
        if (string != null) {
            ReportParser.setLicenseKey(string);
        }
    }

    public HttpRequestWriter getRequest(HttpRequestReader httpRequestReader, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpRequestWriter httpRequestWriter = null;
        String string = this.getProxyURL(httpRequestReader.getUnderlyingRequest(), httpServletResponse);
        if (string != null) {
            httpRequestWriter = new HttpRequestWriter(httpRequestReader);
            httpRequestWriter.setURL(string);
            httpRequestWriter.clearHeader("Accept-Encoding");
        }
        return httpRequestWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponseWriter getResponse(HttpResponseReader httpResponseReader) throws ServletException, IOException {
        HttpResponseWriter httpResponseWriter = null;
        if (httpResponseReader.getStatus() < 200) return new HttpResponseWriter(httpResponseReader);
        if (httpResponseReader.getStatus() > 299) return new HttpResponseWriter(httpResponseReader);
        if (httpResponseReader.getStatus() == 204) return new HttpResponseWriter(httpResponseReader);
        httpResponseWriter = new HttpResponseWriter();
        httpResponseWriter.setStatus(httpResponseReader.getStatus(), httpResponseReader.getStatusMessage());
        httpResponseWriter.setHeader("Content-Type", "application/pdf");
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(httpResponseReader.getInputStream());
        inputSource.setSystemId(httpResponseReader.getURL());
        PDF pDF = null;
        try {
            ReportParser reportParser = ReportParser.getInstance(this.getServletConfig().getInitParameter("org.xml.sax.driver"));
            this.initParser(reportParser);
            reportParser.setMetaHandler(new MetaCallback(httpResponseReader, httpResponseWriter, this));
            pDF = reportParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() == null) throw new ServletException((Throwable)sAXException);
            throw new ServletException((Throwable)sAXException.getException());
        }
        this.modifyPDF(pDF);
        pDF.render(httpResponseWriter.getOutputStream());
        return httpResponseWriter;
    }

    public void metaTag(HttpResponseReader httpResponseReader, HttpResponseWriter httpResponseWriter, String string, String string2) throws ServletException, IOException {
        block11: {
            block12: {
                block10: {
                    if (!string.toUpperCase().startsWith("HTTP-")) break block10;
                    httpResponseWriter.setHeader(string.substring(5), string2);
                    break block11;
                }
                if (!string.equalsIgnoreCase("Servlet-FileName")) break block12;
                httpResponseWriter.setHeader("Content-Disposition", "attachment; filename=\"" + string2 + "\"");
                break block11;
            }
            if (string.equalsIgnoreCase("Servlet-Cache")) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int[] nArray = new int[]{86400, 3600, 60, 1};
                if (Character.isDigit(string2.charAt(string2.length() - 1))) {
                    string2 = string2 + "s";
                }
                try {
                    while (n4 < string2.length()) {
                        int n5 = "dhms".indexOf(string2.charAt(n4));
                        if (n5 >= 0) {
                            n2 += Integer.parseInt(string2.substring(n3, n4)) * nArray[n5];
                            n3 = n4 + 1;
                        }
                        ++n4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                httpResponseWriter.setHeader("X-Proxy-Cache-Control", "max-age=" + n2);
                httpResponseWriter.setHeader("Cache-Control", "max-age=" + n2);
            }
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder().append("PDF WARNING");
        String string = sAXParseException.getLineNumber() >= 0 ? " AT " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() : "";
        System.err.println(stringBuilder.append(string).append(": ").append(sAXParseException.getMessage()).toString());
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder().append("PDF ERROR");
        String string = sAXParseException.getLineNumber() >= 0 ? " AT " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() : "";
        System.err.println(stringBuilder.append(string).append(": ").append(sAXParseException.getMessage()).toString());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder().append("PDF FATAL ERROR");
        String string = sAXParseException.getLineNumber() >= 0 ? " AT " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() : "";
        System.err.println(stringBuilder.append(string).append(": ").append(sAXParseException.getMessage()).toString());
        throw sAXParseException;
    }

    public void initParser(ReportParser reportParser) {
    }

    public void modifyPDF(PDF pDF) {
    }

    public abstract String getProxyURL(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    private class MetaCallback
    implements MetaHandler {
        private HttpResponseReader a;
        private HttpResponseWriter b;
        private PDFProxyServlet c;

        public MetaCallback(HttpResponseReader httpResponseReader, HttpResponseWriter httpResponseWriter, PDFProxyServlet pDFProxyServlet2) {
            this.a = httpResponseReader;
            this.b = httpResponseWriter;
            this.c = pDFProxyServlet2;
        }

        public void handleMetaTag(String string, String string2) throws SAXException {
            try {
                this.c.metaTag(this.a, this.b, string, string2);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }
}

