/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.ArrayList;
import java.util.Map;
import org.faceless.pdf2.LayoutBox;
import org.faceless.pdf2.PDFStyle;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.Break;
import org.faceless.report.CData;
import org.faceless.report.Node;
import org.faceless.report.Span;
import org.faceless.report.VisibleInlineNode;
import org.xml.sax.SAXException;

final class Paragraph
extends AbstractBlock {
    private PDFStyle s;
    private LayoutBox t;
    private float u;

    public Paragraph(Map map) throws SAXException {
        super(map);
    }

    final LayoutBox b() {
        return this.t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addKid(Node node) throws SAXException {
        boolean bl = true;
        if (node instanceof CData && this.getAttribute(Atts.FONT_VARIANT) == "small-caps") {
            bl = ((CData)node).c();
        }
        if (!bl) return;
        if (this.kids.size() > 0 && node instanceof CData && !(node instanceof Break)) {
            Node node2 = (Node)this.kids.get(this.kids.size() - 1);
            if (node2 instanceof CData && !(node2 instanceof Break) && !((CData)node).isVoodoo() && !((CData)node2).isVoodoo()) {
                ((CData)node2).append((CData)node);
                return;
            }
            super.addKid(node);
            return;
        }
        if (!(node instanceof CData) && node.getAttribute(Atts.DISPLAY) != "inline" && node.getAttribute(Atts.DISPLAY) != "none") {
            node.setAttribute(Atts.DISPLAY, (Object)"inline");
            node.setAttribute(Atts.FLOAT, (Object)"_block");
            super.addKid(node);
            return;
        }
        super.addKid(node);
    }

    public PDFStyle getTextStyle(float f2) throws SAXException {
        if (this.s == null) {
            this.s = super.getTextStyle(this.w);
        }
        this.a(this.s);
        return this.s;
    }

    void draw() throws SAXException {
        if (this.debug) {
            this.a("in Paragraph.draw " + this.thisrect() + " style=" + this.getTextStyle(0.0f));
        }
        if (this.drawBackground()) {
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                Node node = (Node)this.kids.get(i2);
                node.draw();
            }
            LayoutBox.Box[] boxArray = this.t.getBoxes();
            float f2 = boxArray.length > 0 ? boxArray[0].getTop() : 0.0f;
            float f3 = f2;
            this.m.drawLayoutBox(this.t, this.x + this.pl + this.ml + this.bl, this.y + this.pt + this.mt + this.bt - this.u);
            this.u = f3;
        } else {
            this.u = 0.0f;
        }
        this.postDrawBackground();
        this.t = null;
        this.s = null;
        if (this.debug) {
            this.a("out Paragraph.draw");
        }
    }

    float c() {
        return this.u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setWidth(float f2) throws SAXException {
        if (this.w != 0.0f) {
            return this.w;
        }
        if (this.debug) {
            this.a("in Paragraph.setWidth max=" + f2);
        }
        f2 = this.setEdges(f2);
        float f3 = this.w = this.hasAttribute(Atts.WIDTH) ? f2 : Math.min(f2, this.getOCW(f2));
        if (this.hasAttribute(Atts.MIN_WIDTH)) {
            this.w = Math.max(this.w, this.getNumAttribute(Atts.MIN_WIDTH, f2));
        }
        if (!Double.isNaN(this.mcw) && this.w < this.mcw) {
            this.w = this.mcw;
        }
        int n2 = this.kids.size();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                if (!this.debug) return this.w;
                this.a("out Paragraph.setWidth w=" + this.w);
                return this.w;
            }
            Node node = (Node)this.kids.get(n3);
            if (node instanceof AbstractBlock) {
                AbstractBlock abstractBlock = (AbstractBlock)node;
                float f4 = this.w - this.edgew();
                String string = node.getStringAttribute(Atts.FLOAT);
                if (string != null) {
                    abstractBlock.getMCW(f2);
                    if (!(string != "left" && string != "right" || node.hasAttribute(Atts.WIDTH))) {
                        f4 /= 2.0f;
                    }
                }
                abstractBlock.setWidth(f4);
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setHeight() throws SAXException {
        Node node;
        Node node2;
        int n2;
        if (this.t != null) {
            return this.h;
        }
        if (this.debug) {
            this.a("in Paragraph.setHeight: w=" + this.w);
        }
        this.h = 0.0f;
        this.t = new LayoutBox(this.w - this.edgew() + 0.1f, this.getLocale());
        this.t.setStyle(this.getTextStyle(0.0f));
        int n3 = this.kids.size();
        if (this.getStringAttribute(Atts.WHITESPACE) == "pre" && this.document.getBooleanAttribute(Atts._BFG_TRIM_TRAILING_PRE_NEWLINE)) {
            if (n3 > 0 && this.kids.get(n3 - 1) instanceof Break) {
                this.kids.remove(--n3);
            }
            if (n3 > 0 && this.kids.get(n3 - 1) instanceof Break) {
                this.kids.remove(--n3);
            }
        }
        boolean bl = true;
        for (n2 = 0; n2 < n3; ++n2) {
            node2 = (Node)this.kids.get(n2);
            if (node2 instanceof CData) {
                bl |= ((CData)node2).addToParagraph(this);
                continue;
            }
            if (!(node2 instanceof VisibleInlineNode)) continue;
            if (node2 instanceof AbstractBlock) {
                ((AbstractBlock)node2).setHeight();
            }
            bl |= ((VisibleInlineNode)((Object)node2)).addToParagraph(this);
        }
        this.t.flush();
        this.h = this.t.getHeight() + this.edgeh() + 0.05f;
        if (this.document.getBooleanAttribute(Atts._BFG_BUGGY_PRE_HEIGHT_CALC) && "pre".equals(this.getTag()) && this.hasAttribute(Atts.WIDTH) && !((node = (Node)this.kids.get(n3 - 1)) instanceof Break) && node instanceof CData && ((CData)node).toLongString().length() == 0) {
            this.h -= this.s.getFontLeading();
        }
        if (this.document.getBooleanAttribute(Atts._BFG_TRIM_INITIAL_LEADING)) {
            Node node3;
            this.u = Math.max(0.0f, this.getTextStyle(0.0f).getFontLeading() - this.getTextStyle(0.0f).getFontSize());
            Node node4 = node3 = this.kids.size() == 0 ? null : (Node)this.kids.get(this.kids.size() - 1);
            while (node3 != null && node3 instanceof Span) {
                node3 = node3.kids.size() == 0 ? null : node3.kids.get(node3.kids.size() - 1);
            }
            if (this.debug) {
                this.a("Report10 break adjustment: whitespace=" + this.getStringAttribute(Atts.WHITESPACE) + " n=" + node3);
            }
            if (node3 == null) {
                this.h += this.getTextStyle(0.0f).getFontLeading();
            } else {
                if (this.getStringAttribute(Atts.WHITESPACE) == "pre") {
                    while (node3 != null && node3 instanceof CData && ((CData)node3).toLongString().trim().length() == 0) {
                        node3 = node3.getPrevSibling();
                    }
                }
                if (node3 != null && node3 instanceof Break) {
                    this.h += ((Break)node3).getParent().getTextStyle(0.0f).getFontLeading();
                }
            }
            this.h -= this.u;
        }
        if (bl) {
            for (n2 = 0; n2 < this.kids.size(); ++n2) {
                node2 = (Node)this.kids.get(n2);
                if (!(node2 instanceof Span)) continue;
                ((Span)node2).sizeAndSplitInlines();
                ((Span)node2).layoutbox.getLeft();
            }
        }
        if (this.debug) {
            this.a("out Paragraph.setHeight leading=" + this.getTextStyle(0.0f).getTextLineSpacing() + " h=" + this.h);
        }
        this.h = Math.max(this.h, this.getNumAttribute(Atts.MIN_HEIGHT));
        return this.h;
    }

    public float getOCW(float f2) throws SAXException {
        if (this.debug) {
            this.a("in Paragraph.getOCW(" + f2 + ")");
        }
        this.getTextStyle(0.0f);
        this.a(f2);
        float f3 = this.ocw + this.edgew();
        if (this.debug) {
            this.a("out Paragraph.getOCW() - returning " + this.ocw + "+edge=" + f3);
        }
        return f3;
    }

    public float getMCW(float f2) throws SAXException {
        if (this.debug) {
            this.a("in Paragraph.getMCW(" + f2 + ")");
        }
        this.b(f2);
        float f3 = this.edgew();
        if (this.debug) {
            this.a("out Paragraph.getMCW() - returning " + this.mcw + "+" + f3 + "=" + (this.mcw + f3));
        }
        return this.mcw + f3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(float f2) throws SAXException {
        this.getTextStyle(0.0f);
        if (this.debug) {
            this.a("in Paragraph._getOCW()");
        }
        if (Float.isNaN(this.ocw)) {
            this.setEdges(f2);
            this.ocw = 0.0f;
            float f3 = 0.0f;
            int n2 = this.kids.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                VisibleInlineNode visibleInlineNode = (VisibleInlineNode)this.kids.get(i2);
                if (visibleInlineNode instanceof Break) {
                    if (f3 > this.ocw) {
                        this.ocw = f3;
                    }
                    f3 = 0.0f;
                    continue;
                }
                f3 += visibleInlineNode.getOCW(0.0f);
            }
            if (f3 > this.ocw) {
                this.ocw = f3;
            }
            this.ocw = (float)((double)this.ocw + ((double)Math.max(0.0f, this.getTextStyle(0.0f).getTextIndent()) + 0.1));
        }
        if (!this.debug) return;
        this.a("out Paragraph._getOCW(): " + this.ocw);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(float f2) throws SAXException {
        if (this.debug) {
            this.a("in Paragraph._getMCW()");
        }
        if (Float.isNaN(this.mcw)) {
            this.setEdges(f2);
            this.mcw = 0.0f;
            String string = this.getStringAttribute(Atts.WHITESPACE);
            if (string == "nowrap" || string == "pre") {
                this.a(f2);
                this.mcw = this.ocw;
            } else {
                int n2 = this.kids.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    float f3 = ((VisibleInlineNode)this.kids.get(i2)).getMCW(0.0f) + (i2 == 0 ? Math.max(0.0f, this.getTextStyle(0.0f).getTextIndent()) : 0.0f);
                    if (!(f3 > this.mcw)) continue;
                    this.mcw = f3;
                }
                this.mcw = (float)((double)this.mcw + 0.1);
            }
        }
        if (!this.debug) return;
        this.a("out Paragraph._getMCW(): " + this.mcw);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractBlock split(float f2) throws SAXException {
        int n2;
        int n3;
        float f3 = f2;
        int n4 = (int)this.getNumAttribute(Atts.ORPHANS);
        int n5 = (int)this.getNumAttribute(Atts.WIDOWS);
        int n6 = this.t.getNumberOfLines();
        if (this.debug) {
            this.a("in Paragraph.split(" + f2 + "): orphans=" + n4 + " widows=" + n5 + " numlines=" + n6 + " height=" + this.t.getHeight() + " edge=" + this.edgeh());
        }
        if (n5 + n4 > n6) {
            if (!this.debug) return this;
            this.a("out Paragraph.split - failed everything!");
            return this;
        }
        f2 -= this.edgeh() - this.mb;
        float f4 = this.t.getHeight();
        for (int i2 = 0; i2 < this.kids.size(); ++i2) {
            if (!(this.kids.get(i2) instanceof AbstractBlock)) continue;
            ((AbstractBlock)this.kids.get((int)i2)).layoutbox.getLeft();
        }
        LayoutBox.Box[] boxArray = this.t.getBoxes();
        for (n3 = 0; n3 < boxArray.length; ++n3) {
            n2 = boxArray[n3].getLineNumber();
            if (n2 != n4 - 1) continue;
            if (this.debug) {
                this.a("checking orphan - boxline " + n2 + " has top " + boxArray[n3].getLineBottom() + " remaining=" + f2);
            }
            if (!(-boxArray[n3].getLineBottom() > f2)) break;
            if (!this.debug) return this;
            this.a("out Paragraph.split - failed orphans test (box on line " + n2 + " has bottom of " + -boxArray[n3].getLineBottom());
            return this;
        }
        for (n3 = boxArray.length - 1; n3 >= 0; --n3) {
            n2 = boxArray[n3].getLineNumber();
            if (n2 != n6 - n5) continue;
            if (this.debug) {
                this.a("checking widow - boxline " + n2 + " has top " + boxArray[n3].getLineTop() + " remaining=" + f2);
            }
            if (!(-boxArray[n3].getLineTop() < f2)) break;
            f2 = -boxArray[n3].getLineTop() + 0.5f;
            if (!this.debug) break;
            this.a("adjusting split point to " + f2 + " to satisfy widows");
            break;
        }
        ArrayList arrayList = new ArrayList(this.kids);
        this.kids.clear();
        Paragraph paragraph = (Paragraph)this.clone();
        paragraph.s = this.s;
        paragraph.u = this.u;
        paragraph.t = this.t.splitAt(f2);
        int n7 = this.t.getNumberOfLines() + 1;
        this.h = this.edgeh() + this.t.getHeight();
        paragraph.h = this.edgeh() + paragraph.t.getHeight();
        int n8 = 0;
        while (true) {
            if (n8 >= arrayList.size()) {
                this.h += Math.max(0.0f, f3 - this.h - paragraph.h + 0.1f);
                this.addNodeAfter(paragraph);
                if (!this.debug) return this;
                this.a("out Paragraph.split - original paragraph is " + this.t.getHeight() + "pt, " + this.t.getNumberOfLines() + " lines, new one is " + paragraph.t.getHeight() + "pt and " + paragraph.t.getNumberOfLines() + " lines" + " padded to =" + this.h);
                return this;
            }
            if (arrayList.get(n8) instanceof AbstractBlock) {
                AbstractBlock abstractBlock = (AbstractBlock)arrayList.get(n8);
                if (this.debug) {
                    this.a("kid " + n8 + "/" + arrayList.size() + " kid=" + abstractBlock + " layout=" + abstractBlock.layoutbox);
                }
                if (abstractBlock.layoutbox.getLineNumber() >= (float)n7) {
                    abstractBlock.moveLayoutBox(0.0f, f4 - paragraph.t.getHeight(), n7);
                    abstractBlock.paragraph = paragraph;
                    abstractBlock.m = null;
                    paragraph.addKid(abstractBlock);
                } else {
                    this.addKid(abstractBlock);
                }
            }
            ++n8;
        }
    }
}

