/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.faceless.graph.AbstractBarGraph;
import org.faceless.graph.AbstractLineGraph;
import org.faceless.graph.AxesGraph;
import org.faceless.graph.Graph;
import org.faceless.graph.LineGraph;
import org.faceless.graph.Style;
import org.faceless.graph.formatter.CurrencyFormatter;
import org.faceless.graph.formatter.DateFormatter;
import org.faceless.graph.formatter.FloatingPointFormatter;
import org.faceless.graph.formatter.Formatter;
import org.faceless.graph.formatter.IntegerFormatter;
import org.faceless.graph.formatter.NullFormatter;
import org.faceless.graph.formatter.PercentageFormatter;
import org.faceless.graph.formatter.SimpleFormatter;
import org.faceless.graph.output.PDF2Output;
import org.faceless.pdf2.PDFFont;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.GraphData;
import org.faceless.report.Node;
import org.faceless.util.MethodString;
import org.xml.sax.SAXException;

class PieGraph
extends AbstractBlock {
    org.faceless.graph.PieGraph s = new org.faceless.graph.PieGraph();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PieGraph(Map map) throws SAXException {
        super(map);
        this.s.setPieEdgeDegrees(1.0);
        if (this.getAttribute(Atts.WIDTH) != null) {
            if (this.getAttribute(Atts.HEIGHT) != null) return;
        }
        this.document.error("Must specify width and height for <" + this.getTag() + ">");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setWidth(float f2) throws SAXException {
        this.setEdges(f2);
        this.w = this.getNumAttribute(Atts.WIDTH, f2 - this.edgew());
        if (this.hasAttribute(Atts.MIN_WIDTH)) {
            this.w = Math.max(this.w, this.getNumAttribute(Atts.MIN_WIDTH, f2));
        }
        this.h = this.getNumAttribute(Atts.HEIGHT, this.getParent() instanceof AbstractBlock ? Math.max(0.0f, this.getParent().getNumAttribute(Atts.HEIGHT, 0.0f) - ((AbstractBlock)this.getParent()).edgeh()) : 0.0f);
        if (this.w == 0.0f || this.h == 0.0f) {
            this.document.error("Must specify width and height for <" + this.getTag() + ">");
        }
        this.w += this.edgew();
        this.h += this.edgeh();
        this.h = Math.max(this.h, this.getNumAttribute(Atts.MIN_HEIGHT, 0.0f));
        return this.w;
    }

    public float setHeight() {
        return this.h;
    }

    public float getMCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public float getOCW(float f2) throws SAXException {
        return this.setWidth(f2);
    }

    public AbstractBlock split(float f2) {
        return this;
    }

    void draw() throws SAXException {
        if (this.debug) {
            this.a("in PieGraph.draw: " + this.kids.size() + " kids");
        }
        if (this.drawBackground()) {
            int n2 = (int)(this.x + this.ml + this.pl + this.bl);
            int n3 = (int)(this.y + this.mt + this.pt + this.bt);
            int n4 = (int)(this.x + this.w - this.edgew());
            int n5 = (int)(this.y + this.h - this.edgeh());
            this.m.setUnits(1.0f, 0);
            PDF2Output pDF2Output = new PDF2Output(this.m, n2, this.m.getHeight() - n3, n4, this.m.getHeight() - n5);
            PieGraph.a((Node)this, this.s, pDF2Output);
            if (this.hasAttribute(Atts.DISPLAY_ZEROS)) {
                this.s.optionDisplayZeros(this.getBooleanAttribute(Atts.DISPLAY_ZEROS));
            }
            if (this.hasAttribute(Atts.PIE_HEIGHT)) {
                this.s.optionHeight(this.getNumAttribute(Atts.PIE_HEIGHT));
            }
            if (this.hasAttribute(Atts.OTHER_PERCENTAGE)) {
                this.s.optionOtherPercentage(this.getNumAttribute(Atts.OTHER_PERCENTAGE));
            }
            if (this.hasAttribute(Atts.OTHER_LABEL)) {
                this.s.optionOtherLabel(this.getStringAttribute(Atts.OTHER_LABEL));
            }
            if (this.hasAttribute(Atts.OUTER_KEY_PERCENTAGE)) {
                this.s.optionOuterKeyPercentage(this.getNumAttribute(Atts.OUTER_KEY_PERCENTAGE));
            }
            if (this.hasAttribute(Atts.DISPLAY_PERCENTAGE)) {
                int n6;
                int n7;
                String string;
                block36: {
                    string = this.getStringAttribute(Atts.DISPLAY_PERCENTAGE);
                    n7 = 0;
                    n6 = 1;
                    if (string.charAt(string.length() - 1) != ')' || string.charAt(string.length() - 3) != '(') break block36;
                    n6 = string.charAt(string.length() - 2) - 48;
                    string = string.substring(0, string.length() - 3);
                }
                if (string.equals("inline")) {
                    n7 = 16 + n6;
                }
                if (string.equals("with-key")) {
                    n7 = 8 + n6;
                }
                this.s.optionDisplayPercentage(n7);
            }
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                GraphData graphData = (GraphData)this.kids.get(i2);
                String string = graphData.getStringAttribute(Atts.NAME);
                if (graphData.hasAttribute(Atts.COLOR)) {
                    this.s.setColor(string, graphData.getPaintAttribute(Atts.COLOR));
                }
                if (graphData.hasAttribute(Atts.VALUE)) {
                    this.s.set(string, Double.parseDouble(graphData.getStringAttribute(Atts.VALUE)));
                }
                if (!graphData.hasAttribute(Atts.EXTEND)) continue;
                this.s.extendSlice(string, graphData.getNumAttribute(Atts.EXTEND, 100.0f));
                continue;
            }
            pDF2Output.render(this.s);
            this.m.setUnits(1.0f, 1);
        }
        this.postDrawBackground();
        if (this.debug) {
            this.a("out PieGraph.draw");
        }
    }

    static Style a(Node node, Graph graph, PDF2Output pDF2Output, int n2, int n3) throws SAXException {
        String string;
        Style style;
        block14: {
            style = null;
            if (node.getAttribute(n2) == null && node.getAttribute(n3) == null) break block14;
            style = new Style(node.getPaintAttribute(n2), node.getColorAttribute(n3));
        }
        int n4 = -1;
        if (n2 == Atts.ZWALL_COLOR) {
            n4 = Atts.ZWALL_GRID;
        } else if (n2 == Atts.YWALL_COLOR) {
            n4 = Atts.YWALL_GRID;
        } else if (n2 == Atts.FLOOR_COLOR) {
            n4 = Atts.FLOOR_GRID;
        }
        if (n4 != -1 && (string = node.getStringAttribute(n4)) != null) {
            string = string.toLowerCase();
            int n5 = 0;
            if (string.indexOf("horiz") >= 0) {
                n5 += 5;
            }
            if (string.indexOf("vert") >= 0) {
                n5 += 10;
            }
            style.setGrid(n5);
        }
        return style;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Style a(Node node, Graph graph, PDF2Output pDF2Output, int n2, int n3, int n4) throws SAXException {
        Style style = new Style(node.getPaintAttribute(n4));
        String string = node.getStringAttribute(n3 + 0);
        String string2 = node.getStringAttribute(n3 + 1);
        int n5 = (string2.indexOf("italic") >= 0 || string2.indexOf("oblique") >= 0 ? 2 : 0) + (node.getStringAttribute(n3 + 2).indexOf("bold") >= 0 ? 1 : 0);
        float f2 = node.getNumAttribute(n2 + 1, node.getNumAttribute(Atts.FONT_SIZE, node.m.getStyle().getFontSize()));
        PDFFont pDFFont = node.document.getFont(string, n5);
        if (pDFFont == null) {
            node.document.error("No such font '" + string + "'");
        }
        pDF2Output.setFontMap(string, n5, pDFFont);
        style.setFont(string, n5, f2);
        String string3 = node.getStringAttribute(n3 + 3);
        String string4 = node.getStringAttribute(n3 + 4);
        if (string3 != null || string4 != null) {
            int n6;
            int n7 = "CENTER".equalsIgnoreCase(string3) ? 32 : (n6 = "RIGHT".equalsIgnoreCase(string3) ? 2 : 8);
            style.setAlign(n6 |= "BOTTOM".equalsIgnoreCase(string4) ? 4 : ("MIDDLE".equalsIgnoreCase(string4) ? 16 : 1));
        }
        if (node.getAttribute(n2 + 0) == null) return style;
        style.setRotate(node.getNumAttribute(n2 + 0));
        return style;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void a(Node node, Graph graph, PDF2Output pDF2Output) throws SAXException {
        int n2;
        int n3;
        Object object;
        if (node.hasAttribute(Atts.DEFAULT_COLORS)) {
            graph.setDefaultColors((Paint[])node.getAttribute(Atts.DEFAULT_COLORS));
        }
        if (graph instanceof org.faceless.graph.PieGraph) {
            if (node.hasAttribute(Atts.YROTATION)) {
                graph.optionXRotation(node.getNumAttribute(Atts.YROTATION, 360.0f));
            }
            if (node.hasAttribute(Atts.XROTATION)) {
                graph.optionYRotation(node.getNumAttribute(Atts.XROTATION, 360.0f));
            }
        } else {
            if (node.hasAttribute(Atts.XROTATION)) {
                graph.optionXRotation(node.getNumAttribute(Atts.XROTATION, 360.0f));
            }
            if (node.hasAttribute(Atts.YROTATION)) {
                graph.optionYRotation(node.getNumAttribute(Atts.YROTATION, 360.0f));
            }
        }
        if (node.hasAttribute(Atts.ZROTATION)) {
            graph.optionZRotation(node.getNumAttribute(Atts.ZROTATION, 360.0f));
        }
        if (node.hasAttribute(Atts.OUTLINE_COLOR)) {
            graph.setDefaultBorderColor(node.getColorAttribute(Atts.OUTLINE_COLOR));
        }
        if (node.hasAttribute(Atts.OUTLINE_WIDTH)) {
            graph.setDefaultLineThickness(node.getNumAttribute(Atts.OUTLINE_WIDTH));
        }
        if (node.hasAttribute(Atts.DISPLAY_KEY)) {
            object = node.getStringAttribute(Atts.DISPLAY_KEY).intern();
            n3 = 128;
            n2 = 0;
            if (((String)object).endsWith("-with-markers")) {
                object = ((String)object).substring(0, ((String)object).length() - 13).intern();
                n2 = graph instanceof LineGraph;
            }
            if (object == "none") {
                n3 = 0;
            }
            if (object == "boxed-bottom" || object == "bottom") {
                n3 = 128;
            }
            if (object == "boxed-right" || object == "right") {
                n3 = 256;
            }
            if (object == "boxed-left" || object == "left") {
                n3 = 512;
            }
            if (object == "boxed-top" || object == "top") {
                n3 = 1024;
            }
            if (graph instanceof org.faceless.graph.PieGraph) {
                if (object == "flat-outer") {
                    n3 = 8;
                }
                if (object == "rotated-outer") {
                    n3 = 10;
                }
                if (object == "rotated-inner-flat-outer") {
                    n3 = 5;
                }
                if (object == "rotated-inner-rotated-outer") {
                    n3 = 7;
                }
                if (object == "flat-inner-rotated-outer") {
                    n3 = 6;
                }
                if (object == "flat-inner-flat-outer") {
                    n3 = 4;
                }
            }
            graph.optionDisplayKey(n3 + (n2 != 0 ? 1 : 0));
        }
        graph.optionKeyStyle(PieGraph.a(node, graph, pDF2Output, Atts.KEY_ROTATE, Atts.KEY_FONT_FAMILY, Atts.KEY_COLOR));
        graph.optionKeyBoxStyle(PieGraph.a(node, graph, pDF2Output, Atts.KEYBOX_COLOR, Atts.KEYBOX_BORDER_COLOR));
        if (node.hasAttribute(Atts.LIGHT_LEVEL)) {
            graph.setLightLevel(node.getIntAttribute(Atts.LIGHT_LEVEL));
        }
        if (!node.hasAttribute(Atts.LIGHT_VECTOR)) return;
        try {
            object = new StringTokenizer(node.getStringAttribute(Atts.LIGHT_VECTOR));
            n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
            graph.setLightVector(n3, n2, n4);
            return;
        }
        catch (Exception exception) {
            node.document.warning("Illegal light vector \"" + node.getStringAttribute(Atts.LIGHT_VECTOR) + "\": ignored");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void a(Node node, AxesGraph axesGraph, PDF2Output pDF2Output) throws SAXException {
        int n2;
        if (node.hasAttribute(Atts.XAXIS_AT_ZERO)) {
            axesGraph.optionXAxisAtZero(node.getBooleanAttribute(Atts.XAXIS_AT_ZERO));
        }
        if (node.hasAttribute(Atts.YAXIS_AT_ZERO)) {
            axesGraph.optionYAxisAtZero(node.getBooleanAttribute(Atts.YAXIS_AT_ZERO));
        }
        if (!(axesGraph instanceof AbstractBarGraph)) {
            if (node.hasAttribute(Atts.X_STRETCH_TO_ZERO)) {
                axesGraph.optionXStretchToZero(node.getBooleanAttribute(Atts.X_STRETCH_TO_ZERO));
            }
            if (node.hasAttribute(Atts.Y_STRETCH_TO_ZERO)) {
                axesGraph.optionYStretchToZero(node.getBooleanAttribute(Atts.Y_STRETCH_TO_ZERO));
            }
        }
        if (node.hasAttribute(Atts.MIN_Y)) {
            axesGraph.optionMinY(node.getNumAttribute(Atts.MIN_Y));
        }
        if (node.hasAttribute(Atts.MAX_Y)) {
            axesGraph.optionMaxY(node.getNumAttribute(Atts.MAX_Y));
        }
        axesGraph.optionFloorStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.FLOOR_COLOR, Atts.FLOOR_BORDER_COLOR));
        axesGraph.optionYWallStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.YWALL_COLOR, Atts.YWALL_BORDER_COLOR));
        axesGraph.optionZWallStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.ZWALL_COLOR, Atts.ZWALL_BORDER_COLOR));
        axesGraph.optionAxisStyle(new Style(node.getColorAttribute(Atts.AXES_COLOR)));
        axesGraph.optionBoxColor(node.getColorAttribute(Atts.BOX_COLOR));
        if (node.hasAttribute(Atts.XAXIS_LABEL)) {
            axesGraph.optionXAxisLabel(node.getStringAttribute(Atts.XAXIS_LABEL));
        }
        if (node.hasAttribute(Atts.YAXIS_LABEL)) {
            axesGraph.optionYAxisLabel(node.getStringAttribute(Atts.YAXIS_LABEL));
        }
        axesGraph.optionXAxisLabelStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.XAXIS_LABEL_ROTATE, Atts.XAXIS_LABEL_FONT_FAMILY, Atts.XAXIS_LABEL_COLOR));
        axesGraph.optionYAxisLabelStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.YAXIS_LABEL_ROTATE, Atts.YAXIS_LABEL_FONT_FAMILY, Atts.YAXIS_LABEL_COLOR));
        axesGraph.optionXAxisStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.XAXIS_ROTATE, Atts.XAXIS_FONT_FAMILY, Atts.XAXIS_COLOR));
        axesGraph.optionYAxisStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.YAXIS_ROTATE, Atts.YAXIS_FONT_FAMILY, Atts.YAXIS_COLOR));
        axesGraph.optionZAxisStyle(PieGraph.a(node, axesGraph, pDF2Output, Atts.ZAXIS_ROTATE, Atts.ZAXIS_FONT_FAMILY, Atts.ZAXIS_COLOR));
        Formatter formatter = PieGraph.a(node.getStringAttribute(Atts.YAXIS_FORMATTER), node);
        if (formatter != null) {
            axesGraph.optionYFormatter(formatter);
            try {
                n2 = Integer.parseInt(node.getStringAttribute(Atts.YAXIS_FORMATTER_DENSITY));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = "minimal".equals(node.getStringAttribute(Atts.YAXIS_FORMATTER_DENSITY)) ? 2 : ("sparse".equals(node.getStringAttribute(Atts.YAXIS_FORMATTER_DENSITY)) ? 5 : 10);
            }
            formatter.setDensity(n2);
        }
        if ((formatter = PieGraph.a(node.getStringAttribute(Atts.XAXIS_FORMATTER), node)) != null) {
            axesGraph.optionXFormatter(formatter);
            try {
                n2 = Integer.parseInt(node.getStringAttribute(Atts.XAXIS_FORMATTER_DENSITY));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = "minimal".equals(node.getStringAttribute(Atts.XAXIS_FORMATTER_DENSITY)) ? 2 : ("sparse".equals(node.getStringAttribute(Atts.XAXIS_FORMATTER_DENSITY)) ? 5 : 10);
            }
            formatter.setDensity(n2);
        }
        if ((formatter = PieGraph.a(node.getStringAttribute(Atts.ZAXIS_FORMATTER), node)) == null) return;
        axesGraph.optionZFormatter(formatter);
    }

    private static Formatter a(String string, Node node) throws SAXException {
        Formatter formatter;
        block20: {
            formatter = null;
            if (string == null || string.length() <= 0) break block20;
            Locale locale = node.document.getPDF().getLocale();
            try {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                block21: {
                                    block22: {
                                        if (string.startsWith("currency(")) {
                                            formatter = string.equals("currency()") ? new CurrencyFormatter(locale) : new CurrencyFormatter(Node.a(string.substring(9, string.length() - 1), node.getLocale()));
                                            break block20;
                                        }
                                        if (string.equals("integer()")) {
                                            formatter = new IntegerFormatter();
                                            break block20;
                                        }
                                        if (string.startsWith("simple(")) {
                                            formatter = new SimpleFormatter(new DecimalFormat(string.substring(7, string.length() - 1), new DecimalFormatSymbols(locale)));
                                            break block20;
                                        }
                                        if (!string.startsWith("percentage(")) break block21;
                                        if (!string.equals("percentage()")) break block22;
                                        formatter = new PercentageFormatter();
                                        break block20;
                                    }
                                    formatter = new PercentageFormatter(Integer.parseInt(string.substring(11, string.length() - 1)));
                                    break block20;
                                }
                                if (!string.startsWith("floatingpoint(")) break block23;
                                if (!string.equals("floatingpoint()")) break block24;
                                formatter = new FloatingPointFormatter();
                                break block20;
                            }
                            formatter = new FloatingPointFormatter(Integer.parseInt(string.substring(14, string.indexOf(44))), Integer.parseInt(string.substring(string.indexOf(44) + 1, string.length() - 1)));
                            break block20;
                        }
                        if (!string.startsWith("date(")) break block25;
                        if (!string.equals("date()")) break block26;
                        string = "date(dd MMM yyyy)";
                    }
                    formatter = new DateFormatter(new SimpleDateFormat(string.substring(5, string.length() - 1), locale));
                    break block20;
                }
                if (string.equals("none")) {
                    formatter = new NullFormatter();
                    break block20;
                }
                try {
                    formatter = (Formatter)MethodString.parseConstructor(string);
                    if (formatter == null) {
                        throw new Exception("No constructor matching \"" + string + "\"");
                    }
                }
                catch (Exception exception) {
                    node.document.warning("Unknown formatter", exception);
                }
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                node.document.warning("Illegal formatter: \"" + string + "\"");
            }
        }
        return formatter;
    }

    static void a(Node node, AbstractBarGraph abstractBarGraph, PDF2Output pDF2Output) throws SAXException {
        block17: {
            if (node.hasAttribute(Atts.ROUND_BARS)) {
                abstractBarGraph.optionRoundBars(node.getBooleanAttribute(Atts.ROUND_BARS));
            }
            if (node.hasAttribute(Atts.BAR_DEPTH)) {
                abstractBarGraph.optionBarDepth(node.getNumAttribute(Atts.BAR_DEPTH, 1.0f));
            }
            if (node.hasAttribute(Atts.BAR_WIDTH)) {
                abstractBarGraph.optionBarWidth(node.getNumAttribute(Atts.BAR_WIDTH, 1.0f));
            }
            if (node.hasAttribute(Atts.DISPLAY_BARVALUES)) {
                block19: {
                    String string;
                    block18: {
                        block16: {
                            string = node.getStringAttribute(Atts.DISPLAY_BARVALUES).toLowerCase();
                            if (!string.equals("top")) break block16;
                            abstractBarGraph.optionDisplayValue(2);
                            break block17;
                        }
                        if (!string.equals("middle")) break block18;
                        abstractBarGraph.optionDisplayValue(1);
                        break block17;
                    }
                    if (!string.equals("insidetop")) break block19;
                    abstractBarGraph.optionDisplayValue(3);
                    break block17;
                }
                abstractBarGraph.optionDisplayValue(0);
            }
        }
    }

    static void a(Node node, AbstractLineGraph abstractLineGraph, PDF2Output pDF2Output) throws SAXException {
        if (node.hasAttribute(Atts.MIN_X)) {
            abstractLineGraph.optionMinX(node.getNumAttribute(Atts.MIN_X));
        }
        if (node.hasAttribute(Atts.MAX_X)) {
            abstractLineGraph.optionMaxX(node.getNumAttribute(Atts.MAX_X));
        }
        if (node.hasAttribute(Atts.MAX_DATA_POINTS)) {
            abstractLineGraph.optionMaxDataPoints(node.getIntAttribute(Atts.MAX_DATA_POINTS));
        }
        if (node.hasAttribute(Atts.FUNCTION_SMOOTHNESS)) {
            abstractLineGraph.optionFunctionSmoothness(node.getNumAttribute(Atts.FUNCTION_SMOOTHNESS));
        }
        if (node.hasAttribute(Atts.CURVE_DEPTH)) {
            abstractLineGraph.optionCurveDepth(node.getNumAttribute(Atts.CURVE_DEPTH));
        }
    }
}

