/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faceless.graph.Graph;
import org.faceless.pdf2.PDF;
import org.faceless.report.MetaHandler;
import org.faceless.report.ReportHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class ReportParser {
    public static final String VERSION;
    public static final int WARNING_UNKNOWN_TAG = 0;
    public static final int WARNING_UNKNOWN_ATTRIBUTE = 3;
    public static final int WARNING_MISPLACED_TEXT = 1;
    public static final int DEBUG_TO_STDOUT = 2;
    private XMLReader a;
    private ErrorHandler b;
    private MetaHandler c;
    private boolean[] d;

    public static ReportParser getInstance() throws SAXException {
        return ReportParser.getInstance(null);
    }

    public static ReportParser getInstance(String string) throws SAXException {
        return new ReportParser(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReportParser(String string) throws SAXException {
        block27: {
            block26: {
                this.d = new boolean[10];
                this.setFlag(0, true);
                this.setFlag(1, true);
                this.setFlag(3, true);
                if (string != null) break block26;
                if (System.getProperty("org.xml.sax.driver") != null) {
                    try {
                        this.a = XMLReaderFactory.createXMLReader();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.a == null) {
                    int n2 = 0;
                    try {
                        Class<?> clazz = Class.forName("javax.xml.parsers.SAXParserFactory");
                        n2 = 1;
                        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                        try {
                            Method method = sAXParser.getClass().getMethod("getXMLReader", new Class[0]);
                            if (method != null) {
                                n2 = 11;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (n2 == 11) {
                        try {
                            this.a = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                        }
                        catch (Throwable throwable) {
                            System.err.println("WARNING: JAXP 1.1 failed with " + throwable.toString() + ". Fallback to JAXP 1.0");
                            n2 = 1;
                        }
                    }
                    if (n2 == 1) {
                        System.err.println("WARNING: SAX2.0 installed but only JAXP 1.0 - ignoring JAXP (upgrade your JAXP version!)");
                    }
                }
                if (this.a == null) {
                    try {
                        if (this.a == null) {
                            this.a = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.a == null) {
                            this.a = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.a != null) {
                        System.err.println("WARNING: Using SAX2 parser from " + this.a.getClass() + " - should set org.xml.sax.driver");
                    }
                }
                break block27;
            }
            this.a = XMLReaderFactory.createXMLReader(string);
        }
        if (this.a == null) {
            throw new SAXException("Can't find SAX2 parser");
        }
        this.a.setFeature("http://xml.org/sax/features/validation", false);
        this.a.setFeature("http://xml.org/sax/features/namespaces", true);
        this.a.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFlag(int n2, boolean bl) {
        if (n2 < 0) return;
        if (n2 >= this.d.length) return;
        this.d[n2] = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFlag(int n2) {
        if (n2 < 0) return false;
        if (n2 >= this.d.length) return false;
        boolean bl = this.d[n2];
        return bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) throws SAXException {
        this.b = errorHandler;
    }

    public void setMetaHandler(MetaHandler metaHandler) {
        this.c = metaHandler;
    }

    public synchronized PDF parse(String string) throws IOException, SAXException {
        if (string == null) {
            throw new NullPointerException("Can't parse null URL");
        }
        return this.parse(new InputSource(string));
    }

    public synchronized PDF parse(File file) throws IOException, SAXException {
        if (file == null) {
            throw new NullPointerException("Can't parse null File");
        }
        return this.parse(new InputSource(file.toURI().toString()));
    }

    public synchronized PDF parse(InputSource inputSource) throws IOException, SAXException {
        if (inputSource == null) {
            throw new NullPointerException("Can't parse null InputSource");
        }
        ReportHandler reportHandler = new ReportHandler();
        if (this.c != null) {
            reportHandler.setMetaHandler(this.c);
        }
        if (this.b != null) {
            reportHandler.setErrorHandler(this.b);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            reportHandler.setFlag(i2, this.getFlag(i2));
        }
        this.a.setContentHandler(reportHandler);
        this.a.setEntityResolver(reportHandler);
        if (this.b != null) {
            this.a.setErrorHandler(this.b);
        }
        this.a.parse(inputSource);
        return reportHandler.getPDF();
    }

    public synchronized PDF parse(XMLReader xMLReader, InputSource inputSource) throws SAXException, IOException {
        if (xMLReader == null) {
            throw new NullPointerException("XMLReader is null");
        }
        if (inputSource == null) {
            throw new NullPointerException("Can't parse null InputSource");
        }
        ReportHandler reportHandler = new ReportHandler();
        if (this.c != null) {
            reportHandler.setMetaHandler(this.c);
        }
        if (this.b != null) {
            reportHandler.setErrorHandler(this.b);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            reportHandler.setFlag(i2, this.getFlag(i2));
        }
        XMLFilterImpl xMLFilterImpl = new XMLFilterImpl(xMLReader);
        xMLFilterImpl.setContentHandler(reportHandler);
        xMLFilterImpl.setEntityResolver(reportHandler);
        if (this.b != null) {
            xMLFilterImpl.setErrorHandler(reportHandler);
        }
        xMLFilterImpl.parse(inputSource);
        return reportHandler.getPDF();
    }

    public static synchronized void setLicenseKey(String string) {
        PDF.setLicenseKey(string);
    }

    static {
        Package package_ = Package.getPackage("org.faceless.report");
        String string = package_ == null ? "unknown" : package_.getImplementationVersion();
        VERSION = string;
        Graph.setLicenseKey("HGAF5H80D0121BF");
    }
}

