/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.Map;
import org.faceless.pdf2.PDFPage;
import org.faceless.report.Atts;
import org.faceless.report.Node;
import org.faceless.report.Shape;
import org.xml.sax.SAXException;

class ShapeElement
extends Node {
    public ShapeElement(Map map) throws SAXException {
        super(map);
    }

    public void addKid(Node node) throws SAXException {
        this.document.warning("<" + this.getTag() + "> can have no children: Ignoring <" + node.getTag() + ">");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(Shape shape) throws SAXException {
        if (this.debug) {
            this.a("in ShapeElement.draw (tag=" + this.getTag() + ")");
        }
        PDFPage pDFPage = shape.m;
        if (this.getTag().equals("moveto")) {
            if (!this.hasAttribute(Atts.X) || !this.hasAttribute(Atts.Y)) {
                this.document.error("Missing x or y attribute on <" + this.getTag() + ">");
            } else {
                pDFPage.pathMove(shape.cx + this.getNumAttribute(Atts.X, shape.cw), shape.cy + this.getNumAttribute(Atts.Y, shape.ch));
            }
        } else if (this.getTag().equals("lineto")) {
            if (!this.hasAttribute(Atts.X) || !this.hasAttribute(Atts.Y)) {
                this.document.error("Missing x or y attribute on <" + this.getTag() + ">");
            } else {
                pDFPage.pathLine(shape.cx + this.getNumAttribute(Atts.X, shape.cw), shape.cy + this.getNumAttribute(Atts.Y, shape.ch));
            }
        } else if (this.getTag().equals("bezierto")) {
            if (!this.hasAttribute(Atts.X) || !this.hasAttribute(Atts.Y) || this.getAttribute(Atts.CX1) == null || this.getAttribute(Atts.CY1) == null || this.getAttribute(Atts.CX2) == null || this.getAttribute(Atts.CY2) == null) {
                this.document.error("Missing cx1, cy1, cx2, cy2, x or y attribute on <" + this.getTag() + ">");
            } else {
                pDFPage.pathBezier(shape.cx + this.getNumAttribute(Atts.CX1, shape.cw), shape.cy + this.getNumAttribute(Atts.CY1, shape.ch), shape.cx + this.getNumAttribute(Atts.CX2, shape.cw), shape.cy + this.getNumAttribute(Atts.CY2, shape.ch), shape.cx + this.getNumAttribute(Atts.X, shape.cw), shape.cy + this.getNumAttribute(Atts.Y, shape.ch));
            }
        } else if (this.getTag().equals("arcto")) {
            if (this.getAttribute(Atts.WIDTH) == null || this.getAttribute(Atts.HEIGHT) == null || this.getAttribute(Atts.STARTANGLE) == null || this.getAttribute(Atts.ENDANGLE) == null) {
                this.document.error("Missing width, height, startangle or endangle attribute on <" + this.getTag() + ">");
            } else {
                pDFPage.pathArc(this.getNumAttribute(Atts.WIDTH, shape.cw), this.getNumAttribute(Atts.HEIGHT, shape.ch), this.getNumAttribute(Atts.STARTANGLE, 360.0f), this.getNumAttribute(Atts.ENDANGLE, 360.0f));
            }
        }
        if (!this.debug) return;
        this.a("out ShapeElement.draw");
    }
}

