/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.faceless.pdf2.PDFStyle;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.Break;
import org.faceless.report.CData;
import org.faceless.report.LayoutBoxWrapper;
import org.faceless.report.Node;
import org.faceless.report.Paragraph;
import org.faceless.report.VisibleInlineNode;
import org.xml.sax.SAXException;

final class Span
extends AbstractBlock {
    private float s;
    private float t;
    private PDFStyle u;

    public Span(Map map) throws SAXException {
        super(map);
        this.setAttribute(Atts.DISPLAY, (Object)"inline");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addKid(Node node) throws SAXException {
        if (!(node instanceof VisibleInlineNode)) {
            this.document.error("<" + this.getTag() + "> kid is <" + node.getTag() + ">, must be CDATA or inline block: ignored");
            return;
        }
        boolean bl = true;
        if (node instanceof CData && this.getAttribute(Atts.FONT_VARIANT) == "small-caps") {
            bl = ((CData)node).c();
        }
        if (!bl) return;
        if (node instanceof CData && this.kids.size() > 0 && !(node instanceof Break)) {
            Node node2 = (Node)this.kids.get(this.kids.size() - 1);
            if (node2 instanceof CData && !(node2 instanceof Break) && !((CData)node).isVoodoo() && !((CData)node2).isVoodoo()) {
                ((CData)node2).append((CData)node);
                return;
            }
            super.addKid(node);
            return;
        }
        super.addKid(node);
    }

    public float setWidth(float f2) throws SAXException {
        this.setEdges(f2 *= 2.0f);
        int n2 = this.kids.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = this.kids.get(i2);
            if (!(e2 instanceof Span)) continue;
            ((Span)e2).setWidth(f2);
            continue;
        }
        return 0.0f;
    }

    public float setHeight() {
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getOCW(float f2) throws SAXException {
        this.getStyle();
        if (this.s != 0.0f) return this.s;
        float f3 = 0.0f;
        int n2 = this.kids.size();
        int i2 = 0;
        while (true) {
            if (i2 >= n2) {
                if (!(f3 > this.s)) return this.s;
                this.s = f3;
                return this.s;
            }
            VisibleInlineNode visibleInlineNode = (VisibleInlineNode)this.kids.get(i2);
            if (visibleInlineNode instanceof Break) {
                if (f3 > this.s) {
                    this.s = f3;
                }
                f3 = 0.0f;
            } else {
                f3 += visibleInlineNode.getOCW(0.0f);
            }
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getMCW(float f2) throws SAXException {
        this.getStyle();
        if (this.t != 0.0f) return this.t;
        if (this.getStringAttribute(Atts.WHITESPACE) == "nowrap") {
            this.t = this.getOCW(0.0f);
            return this.t;
        }
        int n2 = this.kids.size();
        int i2 = 0;
        while (i2 < n2) {
            float f3 = ((VisibleInlineNode)this.kids.get(i2)).getMCW(0.0f);
            if (f3 > this.t) {
                this.t = f3;
            }
            ++i2;
        }
        return this.t;
    }

    public PDFStyle getStyle() throws SAXException {
        if (this.u == null) {
            Node node = this.getParent();
            while (!(node instanceof Paragraph)) {
                node = node.getParent();
            }
            this.u = super.getTextStyle(((Paragraph)node).w);
        }
        return this.u;
    }

    public LayoutBoxWrapper[] sizeAndSplitInlines() {
        LayoutBoxWrapper[] layoutBoxWrapperArray;
        if (this.debug) {
            this.a("in Span.sizeAndSplitInlines(): kids=" + this.kids.size());
        }
        for (int i2 = 0; i2 < this.kids.size(); ++i2) {
            Object object;
            int n2;
            VisibleInlineNode visibleInlineNode = (VisibleInlineNode)this.kids.get(i2);
            layoutBoxWrapperArray = visibleInlineNode.sizeAndSplitInlines();
            if (this.debug) {
                this.a("Kid " + i2 + "/" + this.kids.size() + ": kid=" + visibleInlineNode + " box=" + this.layoutbox);
                for (n2 = 0; layoutBoxWrapperArray != null && n2 < layoutBoxWrapperArray.length; ++n2) {
                    this.a("--> " + layoutBoxWrapperArray[n2]);
                }
            }
            n2 = -1;
            for (int i3 = 0; n2 < 0 && i3 < layoutBoxWrapperArray.length; ++i3) {
                object = LayoutBoxWrapper.union(this.layoutbox, layoutBoxWrapperArray[i3]);
                if (this.debug) {
                    this.a("  nbox[" + i3 + "/" + layoutBoxWrapperArray.length + "] = " + layoutBoxWrapperArray[i3] + ": union=" + object);
                }
                if (object == null) {
                    n2 = i3;
                    continue;
                }
                this.layoutbox = object;
            }
            if (n2 < 0) continue;
            if (this.debug) {
                this.a("  badbox=" + n2 + " layoutbox=" + this.layoutbox);
            }
            if (n2 > 0) {
                n2 = 1;
            }
            Object object2 = this;
            object = null;
            List list = this.kids;
            this.kids = new ArrayList(0);
            if (visibleInlineNode instanceof Span) {
                object = (Span)this.clone();
                ((Span)object).layoutbox = null;
                ((Node)object2).addNodeAfter((Node)object);
            } else {
                for (int i4 = n2; i4 < layoutBoxWrapperArray.length; ++i4) {
                    object = (Span)this.clone();
                    ((Span)object).layoutbox = layoutBoxWrapperArray[i4];
                    ((Node)object2).addNodeAfter((Node)object);
                    object2 = object;
                }
                if (layoutBoxWrapperArray.length > 1) {
                    n2 = 1;
                }
            }
            ((Span)object).kids = list.subList(i2 + n2, list.size());
            this.kids = list.subList(0, i2 + n2);
            break;
        }
        if (this.layoutbox == null) {
            layoutBoxWrapperArray = new LayoutBoxWrapper[]{};
            this.layoutbox = new LayoutBoxWrapper();
        } else {
            layoutBoxWrapperArray = new LayoutBoxWrapper[]{this.layoutbox};
        }
        if (this.debug) {
            this.a("out Span.sizeAndSplitInlines(): nbox.length=" + layoutBoxWrapperArray.length + " nbox[0]=" + (layoutBoxWrapperArray.length == 0 ? null : layoutBoxWrapperArray[0]));
        }
        return layoutBoxWrapperArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addToParagraph(Paragraph paragraph) throws SAXException {
        this.paragraph = paragraph;
        boolean bl = this.hasAttribute(Atts.BACKGROUND_COLOR) || this.hasAttribute(Atts.BORDER_LEFT_WIDTH) || this.hasAttribute(Atts.BORDER_RIGHT_WIDTH) || this.hasAttribute(Atts.BACKGROUND_IMAGE);
        int n2 = this.kids.size();
        if (this.pl + this.bl + this.ml > 0.0f) {
            paragraph.b().addBoxInline(this.pl + this.bl + this.ml, 0.0f, 0);
        }
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                if (!(this.pr + this.br + this.mr > 0.0f)) return bl;
                paragraph.b().addBoxInline(this.pr + this.br + this.mr, 0.0f, 0);
                return bl;
            }
            Node node = (Node)this.kids.get(n3);
            bl = node instanceof CData ? (bl |= ((CData)node).addToParagraph(paragraph)) : (bl |= ((VisibleInlineNode)((Object)node)).addToParagraph(paragraph));
            ++n3;
        }
    }
}

