/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.faceless.util.ByteBuffer;
import org.faceless.util.SeekableInputStream;
import org.faceless.util.a;
import org.faceless.util.b;
import org.faceless.util.c;
import org.faceless.util.d;
import org.faceless.util.e;

public abstract class BackedInputStream
extends SeekableInputStream {
    private static final boolean c;

    public BackedInputStream duplicate() {
        return this.createSubStream(0L, this.length());
    }

    public BackedInputStream sever() throws IOException {
        if (this.length() > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int n2 = (int)this.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        long l2 = this.tell();
        this.seek(0L);
        this.writeTo(byteArrayOutputStream);
        this.seek(l2);
        a a2 = new a(byteArrayOutputStream.toByteArray(), 0, n2);
        ((SeekableInputStream)a2).seek(l2);
        return a2;
    }

    public abstract BackedInputStream createSubStream(long var1, long var3);

    public ByteBuffer getByteBuffer() throws IOException {
        return this.getByteBuffer(0L, this.length());
    }

    public boolean isDamaged() {
        return false;
    }

    public abstract boolean isFileBased();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getByteBuffer(long l2, long l3) throws IOException {
        int n2;
        int n3;
        if (l3 == -1L) {
            l3 = this.length() - l2;
        }
        if (l2 < 0L || l2 + l3 > this.length()) {
            throw new IllegalArgumentException();
        }
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Buffer overflow");
        }
        byte[] byArray = new byte[n3];
        long l4 = this.tell();
        this.seek(l2);
        int n4 = 0;
        for (n3 = (int)l3; n3 > 0 && (n2 = this.read(byArray, n4, n3)) >= 0; n4 += n2, n3 -= n2) {
        }
        this.seek(l4);
        return new ByteBuffer(byArray);
    }

    public long skip(long l2) throws IOException {
        long l3 = this.tell();
        l2 = Math.min(l3 + l2, this.length());
        this.seek(l2);
        return this.tell() - l3;
    }

    public abstract long length();

    public void fetch(long l2, long l3) throws IOException {
    }

    public boolean supportsFetch() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BackedInputStream getInstance(InputStream inputStream, boolean bl) throws IOException {
        bl &= c;
        try {
            bl &= System.getProperty("org.faceless.util.BackedInputStream.nonio") == null || System.getProperty("org.faceless.util.BackedInputStream.nonio").equals("false");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream instanceof BackedInputStream) {
            return ((BackedInputStream)inputStream).duplicate();
        }
        if (c && bl && inputStream instanceof FileInputStream) {
            return new c((FileInputStream)inputStream);
        }
        return new a(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BackedInputStream getInstance(File file) throws IOException {
        boolean bl = c;
        try {
            bl &= System.getProperty("org.faceless.util.BackedInputStream.nonio") == null || System.getProperty("org.faceless.util.BackedInputStream.nonio").equals("false");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            return new c(file);
        }
        return new b(file);
    }

    public static final BackedInputStream getInstance(String string) {
        return new d(string);
    }

    public static final BackedInputStream getInstance(byte[] byArray, int n2, int n3) {
        return new a(byArray, n2, n3);
    }

    public static final BackedInputStream getInstance(byte[] byArray) {
        return BackedInputStream.getInstance(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BackedInputStream getInstance(URL uRL) throws IOException {
        String string = uRL.getProtocol();
        if ("http".equals(string)) return new e(uRL);
        if ("https".equals(string)) {
            return new e(uRL);
        }
        if ("file".equals(string)) {
            File file = new File(uRL.getFile());
            return BackedInputStream.getInstance(file);
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            a a2 = new a(inputStream);
            return a2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        boolean bl = false;
        try {
            Class.forName("java.nio.MappedByteBuffer");
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        c = bl;
    }
}

