/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitStreamInputStream
extends FilterInputStream {
    private int a;
    private int b;
    private int c;
    private int d;
    private final boolean e;

    public BitStreamInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public BitStreamInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.setBitFieldSize(8);
        this.a = 0;
        this.e = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBitFieldSize(int n2) throws IllegalArgumentException {
        if (n2 >= 1 && n2 <= 31) {
            this.b = n2;
            return;
        }
        throw new IllegalArgumentException("BitField size " + n2 + " not between 1 and 31");
    }

    public int getBitFieldSize() {
        return this.b;
    }

    public int readBitField() throws IOException {
        return this.readbits(this.b);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readbits(int n2) throws IOException {
        if (n2 < 1 || n2 > 31) {
            throw new IllegalArgumentException("numbits=" + n2);
        }
        int n3 = 0;
        int n4 = n2;
        while (true) {
            if (n4 <= 0) {
                this.d += n2;
                return n3;
            }
            if (this.a == 0) {
                this.c = this.in.read();
                if (this.c < 0) {
                    return -1;
                }
                this.a = 8;
            }
            int n5 = 0;
            int n6 = Math.min(n4, this.a);
            if (n6 == 8) {
                n5 = this.c;
            } else {
                int n7 = (1 << n6) - 1;
                int n9 = this.e ? 8 - this.a : this.a - n6;
                n5 = (this.c & n7 << n9) >> n9;
            }
            this.a -= n6;
            n3 |= (n5 & 0xFF) << (this.e ? n2 - n4 : n4 - n6);
            n4 -= n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readbitslong(int n2) throws IOException {
        if (n2 < 1 || n2 > 63) {
            throw new IllegalArgumentException("numbits=" + n2);
        }
        long l2 = 0L;
        int n3 = n2;
        while (true) {
            if (n3 <= 0) {
                this.d += n2;
                return l2;
            }
            if (this.a == 0) {
                this.c = this.in.read();
                if (this.c < 0) {
                    return -1L;
                }
                this.a = 8;
            }
            long l3 = 0L;
            int n4 = Math.min(n3, this.a);
            if (n4 == 8) {
                l3 = this.c;
            } else {
                int n5 = (1 << n4) - 1;
                int n7 = this.e ? 8 - this.a : this.a - n4;
                l3 = (this.c & n5 << n7) >> n7;
            }
            this.a -= n4;
            l2 |= (l3 & 0xFFL) << (this.e ? n2 - n3 : n3 - n4);
            n3 -= n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int n2;
        int n3 = this.getBitFieldSize();
        this.setBitFieldSize(8);
        try {
            n2 = this.readBitField();
        }
        finally {
            this.setBitFieldSize(n3);
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 <= 0) {
            return 0;
        }
        int n5 = this.read();
        if (n5 == -1) {
            return -1;
        }
        byArray[n2] = (byte)n5;
        for (n4 = 1; n4 < n3; ++n4) {
            n5 = this.read();
            if (n5 == -1) {
                break;
            }
            if (byArray == null) continue;
            byArray[n2 + n4] = (byte)n5;
            continue;
        }
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int tell() {
        return this.d;
    }

    public long skip(long l2) throws IOException {
        long l3 = 0L;
        while (true) {
            if (l3 >= l2 || this.read() < 0) break;
            ++l3;
        }
        return l3;
    }
}

