/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BitStreamOutputStream
extends FilterOutputStream {
    protected int bitsize;
    protected int bitsToGo;
    protected int buf;
    protected int bitlength;

    public BitStreamOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.setBitSize(8);
        this.bitsToGo = 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBitSize(int n2) throws IllegalArgumentException {
        if (n2 <= 32 && n2 >= 1) {
            this.bitsize = n2;
            return;
        }
        throw new IllegalArgumentException("BitField size " + n2 + " not between 1 and 32.");
    }

    public void write(boolean bl) throws IOException {
        int n2 = bl ? 1 : 0;
        this.write(n2, 1);
    }

    public void write(int n2) throws IOException {
        this.write(n2, this.bitsize);
    }

    public void write(int n2, int n3) throws IOException {
        block8: {
            block9: {
                block7: {
                    this.bitlength += n3;
                    if (n3 >= this.bitsToGo) break block7;
                    this.bitsToGo -= n3;
                    this.buf |= n2 << this.bitsToGo;
                    break block8;
                }
                if (n3 != this.bitsToGo) break block9;
                this.out.write(this.buf | n2);
                this.buf = 0;
                this.bitsToGo = 8;
                break block8;
            }
            this.out.write(this.buf | n2 >> (n3 -= this.bitsToGo));
            while (n3 >= 8) {
                this.out.write(n2 >> (n3 -= 8) & 0xFF);
            }
            this.bitsToGo = 8 - n3;
            this.buf = n2 << this.bitsToGo & 0xFF;
        }
    }

    public void flush() throws IOException {
        if (this.bitsToGo < 8) {
            this.write(0, this.bitsToGo);
        }
        super.flush();
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public int bitlength() {
        return this.bitlength;
    }
}

