/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class CountingOutputStream
extends BufferedOutputStream {
    protected MessageDigest digest;
    protected volatile long streamcount;

    public CountingOutputStream(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public CountingOutputStream(OutputStream outputStream, int n2) {
        super(outputStream, n2);
    }

    public void setMessageDigest(MessageDigest messageDigest) throws IOException {
        this.flush();
        this.digest = messageDigest;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void write(String string) throws IOException {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            int n3 = i2;
            byte by = (byte)(c2 > '\u00ff' ? 63 : (byte)c2);
            byArray[n3] = by;
        }
        this.write(byArray, 0, n2);
    }

    public void write(int n2) throws IOException {
        super.write(n2);
        if (this.digest != null) {
            this.digest.update((byte)n2);
        }
        ++this.streamcount;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        super.write(byArray, n2, n3);
        if (this.digest != null) {
            this.digest.update(byArray, n2, n3);
        }
        this.streamcount += (long)n3;
    }

    public long tell() {
        return this.streamcount;
    }

    public void flushBuffer() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.flush();
        this.out = outputStream;
    }

    public void incrementPosition(long l2) {
        this.streamcount += l2;
    }
}

