/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class GraphicsBase
extends Graphics2D
implements Cloneable {
    private AffineTransform a = new AffineTransform();
    private Area b;
    private Paint c;
    private Color d;
    private Color e;
    private Stroke f;
    private Font g;
    private Map h;
    private FontRenderContext i;
    private GraphicsConfiguration j;
    private static final GraphicsDevice k = new GraphicsDevice(){

        public int getType() {
            return 2;
        }

        public String getIDstring() {
            return "nulldevice";
        }

        public GraphicsConfiguration[] getConfigurations() {
            throw new UnsupportedOperationException();
        }

        public GraphicsConfiguration getDefaultConfiguration() {
            throw new UnsupportedOperationException();
        }

        public boolean isFullScreenSupported() {
            return false;
        }

        public boolean isDisplayChangeSupported() {
            return false;
        }

        public int getAvailableAcceleratedMemory() {
            throw new UnsupportedOperationException();
        }

        public DisplayMode getDisplayMode() {
            throw new UnsupportedOperationException();
        }

        public DisplayMode[] getDisplayModes() {
            throw new UnsupportedOperationException();
        }

        public void setDisplayMode(DisplayMode displayMode) {
            throw new UnsupportedOperationException();
        }

        public void setFullScreenWindow(Window window) {
            throw new UnsupportedOperationException();
        }

        public Window getFullScreenWindow() {
            throw new UnsupportedOperationException();
        }
    };
    private static final GraphicsConfiguration l = new a_(null, null, null, k);

    public GraphicsBase() {
        this.j = l;
    }

    public Object clone() {
        try {
            GraphicsBase graphicsBase = (GraphicsBase)super.clone();
            if (this.a != null) {
                graphicsBase.a = (AffineTransform)this.a.clone();
            }
            if (this.b != null) {
                graphicsBase.b = (Area)this.b.clone();
            }
            if (this.h != null) {
                graphicsBase.h = new HashMap(this.h);
            }
            return graphicsBase;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public GraphicsBase(ColorModel colorModel, Rectangle rectangle, AffineTransform affineTransform) {
        this(colorModel, rectangle, affineTransform, k);
    }

    public GraphicsBase(ColorModel colorModel, Rectangle rectangle, AffineTransform affineTransform, GraphicsDevice graphicsDevice) {
        this.j = new a_(colorModel, rectangle, affineTransform, graphicsDevice);
    }

    public void addRenderingHints(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)entry.getKey(), entry.getValue());
        }
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clip(new Rectangle(n2, n3, n4, n5));
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new Arc2D.Float(n2, n3, n4, n5, n6, n7, 0));
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n2, n3, n4, n5, null, imageObserver);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        this.draw(new Line2D.Float(n2, n3, n4, n5));
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.draw(new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.fill(new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.draw(new Polygon(nArray, nArray2, n2));
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            this.drawLine(nArray[i2], nArray2[i2], nArray[i2 + 1], nArray2[i2 + 1]);
        }
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new Arc2D.Float(n2, n3, n4, n5, n6, n7, 1));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.fill(new Polygon(nArray, nArray2, n2));
    }

    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        this.fill(new Rectangle(n2, n3, n4, n5));
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        RenderingHints renderingHints = this.getRenderingHints();
        Object object = renderingHints == null ? null : renderingHints.get(key);
        return object;
    }

    public void rotate(double d2) {
        this.transform(AffineTransform.getRotateInstance(d2));
    }

    public void rotate(double d2, double d3, double d4) {
        this.transform(AffineTransform.getRotateInstance(d2, d3, d4));
    }

    public void scale(double d2, double d3) {
        this.transform(AffineTransform.getScaleInstance(d2, d3));
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void shear(double d2, double d3) {
        this.transform(AffineTransform.getShearInstance(d2, d3));
    }

    public void translate(double d2, double d3) {
        this.transform(AffineTransform.getTranslateInstance(d2, d3));
    }

    public void translate(int n2, int n3) {
        this.transform(AffineTransform.getTranslateInstance(n2, n3));
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.f.createStrokedShape(shape);
        }
        shape = this.a.createTransformedShape(shape);
        return shape.intersects(rectangle);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.concatenate(this.a);
        RenderContext renderContext = new RenderContext(affineTransform3);
        try {
            affineTransform2 = this.a.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            renderContext = new RenderContext(this.a);
            affineTransform2 = new AffineTransform();
        }
        this.drawRenderedImage(renderableImage.createRendering(renderContext), affineTransform2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (!(renderedImage instanceof BufferedImage)) {
            Raster raster = renderedImage.getData();
            WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null);
            int n3 = raster.getMinX();
            int n2 = raster.getMinY();
            int n7 = raster.getWidth();
            int n6 = raster.getHeight();
            int n5 = n3 - raster.getSampleModelTranslateX();
            int n4 = n2 - raster.getSampleModelTranslateY();
            if (n5 != 0 || n4 != 0 || n7 != writableRaster.getWidth() || n6 != writableRaster.getHeight()) {
                writableRaster = writableRaster.createWritableChild(n5, n4, n7, n6, 0, 0, null);
            }
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.translate(n3, n2);
            ColorModel colorModel = renderedImage.getColorModel();
            renderedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        }
        this.drawImage((BufferedImage)renderedImage, affineTransform, null);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        Object object;
        if (color != null) {
            object = this.getPaint();
            this.setPaint(color);
            GraphicsBase graphicsBase = this;
            int n10 = n2 < n4 ? n2 : n4;
            int n11 = n3 < n5 ? n3 : n5;
            int n12 = n2 < n4 ? n4 - n2 : n2 - n4;
            int n13 = n3 < n5 ? n5 - n3 : n3 - n5;
            graphicsBase.fillRect(n10, n11, n12, n13);
            this.setPaint((Paint)object);
        }
        object = new AffineTransform((double)(n4 - n2) / (double)(n8 - n6), 0.0, 0.0, (double)(n5 - n3) / (double)(n9 - n7), (double)(n2 - n6), (double)(n3 - n9));
        return this.drawImage(image, (AffineTransform)object, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        if (bufferedImageOp != null) {
            ColorModel colorModel;
            GraphicsConfiguration graphicsConfiguration = this.getDeviceConfiguration();
            ColorModel colorModel2 = colorModel = graphicsConfiguration != null ? graphicsConfiguration.getColorModel() : null;
            if (colorModel == null) {
                colorModel = bufferedImage.getColorModel();
            }
            bufferedImage = bufferedImageOp.filter(bufferedImage, bufferedImageOp.createCompatibleDestImage(bufferedImage, colorModel));
        }
        this.drawImage((Image)bufferedImage, n2, n3, null);
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(n2, n3, n4, n5);
        this.setPaint(paint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FontRenderContext getFontRenderContext() {
        if (this.i == null) {
            boolean bl2 = this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING) != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            this.i = new FontRenderContext(this.a, bl2, true);
        }
        return this.i;
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("AttributedCharacterIterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f2, f3));
        this.fill(shape);
    }

    public void drawString(String string, float f2, float f3) {
        TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f2, f3));
        this.fill(shape);
    }

    public void clip(Shape shape) {
        block3: {
            Area area;
            block2: {
                area = new Area(this.a.createTransformedShape(shape));
                if (this.b != null) break block2;
                this.b = area;
                break block3;
            }
            this.b.intersect(area);
        }
    }

    public void dispose() {
        this.h = null;
        this.i = null;
    }

    public Color getBackground() {
        return this.e;
    }

    public Shape getClip() {
        if (this.b == null) {
            return null;
        }
        try {
            AffineTransform affineTransform = this.a.createInverse();
            return affineTransform.createTransformedShape(this.b);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalStateException("Transform is non-invertible");
        }
    }

    public Rectangle getClipBounds() {
        return this.getClip().getBounds();
    }

    public Color getColor() {
        return this.d;
    }

    public Font getFont() {
        return this.g;
    }

    public Paint getPaint() {
        return this.c;
    }

    public RenderingHints getRenderingHints() {
        if (this.h == null) {
            this.h = new HashMap();
        }
        return new RenderingHints(this.h);
    }

    public Stroke getStroke() {
        return this.f;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.a);
    }

    public void setBackground(Color color) {
        this.e = color;
    }

    public void setClip(Shape shape) {
        Area area = shape == null ? null : new Area(this.a.createTransformedShape(shape));
        this.b = area;
    }

    public void setFont(Font font) {
        this.g = font;
    }

    public void setColor(Color color) {
        if (this.c != null) {
            this.d = color;
            this.c = this.d;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPaint(Paint paint) {
        if (paint != null) {
            if (paint instanceof Color) {
                this.d = (Color)paint;
            }
            this.c = paint;
        }
    }

    public void setRenderingHints(Map map) {
        this.h = new HashMap(map);
        this.i = null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (!key.isCompatibleValue(object)) {
            throw new IllegalArgumentException();
        }
        if (this.h == null) {
            this.h = new HashMap();
        }
        this.h.put(key, object);
        this.i = null;
    }

    public void setStroke(Stroke stroke) {
        this.f = stroke;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.a = new AffineTransform(affineTransform);
    }

    public void transform(AffineTransform affineTransform) {
        this.a.concatenate(affineTransform);
    }

    public void setComposite(Composite composite) {
    }

    public void setXORMode(Color color) {
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public void draw(Shape shape) {
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
    }

    public void fill(Shape shape) {
    }

    public Graphics create() {
        return (Graphics)this.clone();
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        throw new UnsupportedOperationException();
    }

    public Composite getComposite() {
        throw new UnsupportedOperationException();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.j;
    }

    public FontMetrics getFontMetrics(Font font) {
        throw new UnsupportedOperationException();
    }

    private static class a_
    extends GraphicsConfiguration {
        private final ColorModel a;
        private final Rectangle b;
        private final AffineTransform c;
        private final GraphicsDevice d;

        a_(ColorModel colorModel, Rectangle rectangle, AffineTransform affineTransform, GraphicsDevice graphicsDevice) {
            this.a = colorModel;
            this.b = rectangle;
            this.c = affineTransform;
            this.d = graphicsDevice;
        }

        public BufferedImage createCompatibleImage(int n2, int n3) {
            if (this.a == null) {
                throw new UnsupportedOperationException();
            }
            WritableRaster writableRaster = this.a.createCompatibleWritableRaster(n2, n3);
            return new BufferedImage(this.a, writableRaster, this.a.isAlphaPremultiplied(), null);
        }

        public BufferedImage createCompatibleImage(int n2, int n3, int n4) {
            if (this.a == null) {
                throw new UnsupportedOperationException();
            }
            if (this.a.getTransparency() == n4) {
                return this.createCompatibleImage(n2, n3);
            }
            ColorModel colorModel = this.getColorModel(n4);
            if (colorModel == null) {
                throw new IllegalArgumentException("Unknown transparency: " + n4);
            }
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
            return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        }

        public VolatileImage createCompatibleVolatileImage(int n2, int n3) {
            throw new UnsupportedOperationException();
        }

        public VolatileImage createCompatibleVolatileImage(int n2, int n3, int n4) {
            throw new UnsupportedOperationException();
        }

        public Rectangle getBounds() {
            if (this.b == null) {
                throw new UnsupportedOperationException();
            }
            return this.b;
        }

        public ColorModel getColorModel() {
            if (this.a == null) {
                throw new UnsupportedOperationException();
            }
            return this.a;
        }

        public ColorModel getColorModel(int n2) {
            if (this.a == null) {
                throw new UnsupportedOperationException();
            }
            return this.a;
        }

        public AffineTransform getDefaultTransform() {
            if (this.c == null) {
                throw new UnsupportedOperationException();
            }
            return this.c;
        }

        public GraphicsDevice getDevice() {
            return this.d;
        }

        public AffineTransform getNormalizingTransform() {
            return new AffineTransform();
        }
    }
}

