/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.faceless.util.HttpRequestReader;
import org.faceless.util.HttpResponseReader;
import org.faceless.util.TimedSocket;

public class HttpRequestWriter {
    private String a = "GET";
    private String b = "HTTP/1.0";
    private URL c;
    private URL d;
    private Map e = new HashMap();
    private Socket f;
    private boolean g;
    private static final DateFormat h = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);

    public HttpRequestWriter(String string) throws IOException {
        this();
        this.setURL(string);
    }

    private HttpRequestWriter() {
        this.setFollowRedirects(true);
    }

    public HttpRequestWriter(HttpRequestReader httpRequestReader) throws IOException {
        this();
        Iterator iterator = httpRequestReader.getHeaderNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = httpRequestReader.getHeaders(string);
            while (iterator2.hasNext()) {
                this.addHeader(string, (String)iterator2.next());
            }
        }
        try {
            this.setURL(httpRequestReader.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setURL(String string) throws IOException {
        URL uRL = new URL(string);
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            throw new MalformedURLException("Invalid protocol '" + uRL.getProtocol() + "'");
        }
        this.c = this.d = uRL;
        this.setHeader("Host", uRL.getHost() + (uRL.getPort() > 0 ? ":" + uRL.getPort() : ""));
    }

    public void setFollowRedirects(boolean bl) {
        this.g = bl;
    }

    public HttpResponseReader getResponse() throws IOException {
        return this.getResponse(30000);
    }

    public HttpResponseReader getResponse(int n2) throws IOException {
        HttpResponseReader httpResponseReader = this.b(n2);
        while (true) {
            if (!this.g || !this.a(httpResponseReader.getStatus())) break;
            this.c = new URL(this.c, httpResponseReader.getHeader("Location"));
            this.f.close();
            this.f = null;
            httpResponseReader = this.b(n2);
        }
        return httpResponseReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(int n2) {
        if (n2 == 301) return true;
        if (n2 == 302) return true;
        if (n2 == 303) return true;
        if (n2 == 305) return true;
        if (n2 == 307) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponseReader b(int n2) throws IOException {
        int n3;
        Object object2;
        InetAddress inetAddress = null;
        int n4 = this.c.getPort();
        if (n4 < 0) {
            n4 = 80;
        }
        try {
            inetAddress = InetAddress.getByName(this.c.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            throw new MalformedURLException("Unknown host: " + this.c.getHost());
        }
        if (this.f == null || this.f.getInetAddress() != inetAddress || this.f.getPort() != n4) {
            if (this.f != null) {
                this.f.close();
            }
            try {
                this.f = TimedSocket.getSocket(inetAddress, n4, n2);
                this.f.setSoTimeout(n2);
                this.f.setTcpNoDelay(true);
            }
            catch (SecurityException securityException) {
                throw new MalformedURLException("Security exception for host: " + this.c.getHost());
            }
            catch (IOException iOException) {
                System.err.println("Requested URL was \"" + this.c + "\"");
                throw (IOException)iOException.fillInStackTrace();
            }
        }
        OutputStream outputStream = this.f.getOutputStream();
        outputStream.write((this.a + " " + (this.c.getFile().equals("") ? "/" : this.c.getFile()) + " " + this.b + "\r\n").getBytes("ISO-8859-1"));
        for (Object object2 : this.e.keySet()) {
            Object object3;
            if (((String)object2).equals("Cookie") || ((String)object2).equals("Cookie2")) {
                object3 = ((List)this.e.get(object2)).iterator();
                while (object3.hasNext()) {
                    outputStream.write(((String)object2 + ": " + object3.next() + "\r\n").getBytes("ISO-8859-1"));
                }
                continue;
            }
            object3 = "";
            Iterator iterator = ((List)this.e.get(object2)).iterator();
            while (iterator.hasNext()) {
                object3 = (String)object3 + iterator.next();
                if (!iterator.hasNext()) continue;
                object3 = (String)object3 + ", ";
            }
            outputStream.write(((String)object2 + ": " + (String)object3 + "\r\n").getBytes("ISO-8859-1"));
        }
        outputStream.write("\r\n".getBytes("ISO-8859-1"));
        outputStream.flush();
        InputStream inputStream = this.f.getInputStream();
        object2 = new ByteArrayOutputStream();
        int n5 = -1;
        while ((n3 = inputStream.read()) >= 0) {
            if (n3 == 13) continue;
            ((ByteArrayOutputStream)object2).write(n3);
            if (n3 == 10 && n5 == 10) break;
            n5 = n3;
        }
        HttpResponseReader httpResponseReader = new HttpResponseReader();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(((ByteArrayOutputStream)object2).toByteArray(), "ISO-8859-1")));
        String string = bufferedReader.readLine();
        if (!string.startsWith("HTTP/")) {
            throw new IOException("Not an HTTP response");
        }
        httpResponseReader.a(this, this.c, string.substring(0, string.indexOf(32)));
        string = string.substring(string.indexOf(32) + 1);
        httpResponseReader.a(Integer.parseInt(string.substring(0, string.indexOf(32))), string.substring(string.indexOf(32) + 1));
        while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
            int n6 = string.indexOf(58);
            String string2 = string.substring(0, n6++);
            while (string.charAt(n6) == ' ' || string.charAt(n6) == '\t') {
                ++n6;
            }
            String string3 = string.substring(n6);
            Iterator iterator = this.a(string3, this.a(string2, string3)).iterator();
            while (iterator.hasNext()) {
                httpResponseReader.a(string2, (String)iterator.next());
            }
        }
        httpResponseReader.a(inputStream);
        return httpResponseReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(String string, String string2) {
        if (string.equalsIgnoreCase("Cookie")) return false;
        if (string.equalsIgnoreCase("Set-Cookie")) return false;
        if (string2.indexOf(44) != 3) return true;
        if (string2.startsWith("Mon")) return false;
        if (string2.startsWith("Tue")) return false;
        if (string2.startsWith("Wed")) return false;
        if (string2.startsWith("Thu")) return false;
        if (string2.startsWith("Fri")) return false;
        if (string2.startsWith("Sat")) return false;
        if (string2.startsWith("Sun")) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List a(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            arrayList.add(string);
            return arrayList;
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= string.length()) {
                arrayList.add(string.substring(n2, string.length()));
                return arrayList;
            }
            if (string.charAt(n3) == '\"') {
                int n4;
                for (n4 = n3 + 1; n4 < string.length() && string.charAt(n4) != '\"'; ++n4) {
                    if (string.charAt(n4) != '\\') continue;
                    ++n4;
                }
                if (string.charAt(n4) == '\"') {
                    n3 = n4;
                }
            } else if (string.charAt(n3) == ',') {
                arrayList.add(string.substring(n2, n3));
                bl2 = true;
                ++n3;
                while (n3 < string.length() && string.charAt(n3) == ' ' || string.charAt(n3) == '\t') {
                    ++n3;
                }
                n2 = n3;
            }
            ++n3;
        }
    }

    public String getURL() {
        return this.d.toString();
    }

    public void close() {
        try {
            this.f.close();
            this.f = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    private String a(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.toLowerCase());
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        int n2 = 1;
        while (n2 < stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n2++) != '-') continue;
            stringBuffer.setCharAt(n2, Character.toUpperCase(stringBuffer.charAt(n2)));
        }
        return stringBuffer.toString();
    }

    public void setHeader(String string, String string2) {
        string = this.a(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string2);
        this.e.put(string, linkedList);
    }

    public String getHeader(String string) {
        string = this.a(string);
        if (this.containsHeader(string)) {
            return (String)((List)this.e.get(string)).get(0);
        }
        return null;
    }

    public void addHeader(String string, String string2) {
        block3: {
            block2: {
                string = this.a(string);
                if (!this.containsHeader(string)) break block2;
                ((List)this.e.get(string)).add(string2);
                break block3;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string2);
            this.e.put(string, linkedList);
        }
    }

    public void clearHeader(String string) {
        this.e.remove(this.a(string));
    }

    public boolean containsHeader(String string) {
        return this.e.containsKey(this.a(string));
    }

    public void setDateHeader(String string, long l2) {
        this.setHeader(string, h.format(new Date(l2)) + " GMT");
    }

    public void addDateHeader(String string, long l2) {
        this.addHeader(string, h.format(new Date(l2) + " GMT"));
    }

    public void addIntHeader(String string, int n2) {
        this.addHeader(string, "" + n2);
    }

    public void setIntHeader(String string, int n2) {
        this.setHeader(string, "" + n2);
    }

    static {
        h.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

