/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.color.ColorSpace;

public class PaintMixer {
    private static final ColorSpace a = Color.red.getColorSpace();

    public static Color adjustColorBrightness(Color color, float f2, float f3, float f4) {
        float[] fArray = new float[3];
        int n2 = color.getAlpha();
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        fArray[2] = fArray[2] + f2;
        fArray[2] = Math.min(Math.min(1.0f, f4), fArray[2]);
        fArray[2] = Math.max(Math.max(0.0f, f3), fArray[2]);
        int n3 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
        Color color2 = null;
        try {
            ColorSpace colorSpace = color.getColorSpace();
            if (colorSpace != a) {
                fArray[0] = (float)(n3 >> 16 & 0xFF) / 255.0f;
                fArray[1] = (float)(n3 >> 8 & 0xFF) / 255.0f;
                fArray[2] = (float)(n3 & 0xFF) / 255.0f;
                float[] fArray2 = colorSpace.fromRGB(fArray);
                color2 = new Color(colorSpace, fArray2, (float)n2 / 255.0f);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (color2 == null) {
            color2 = new Color((n3 & 0xFFFFFF) + (n2 << 24), true);
        }
        return color;
    }

    public static Paint adjustBrightness(Paint paint, float f2, float f3, float f4) {
        if (paint instanceof Color) {
            return PaintMixer.adjustColorBrightness((Color)paint, f2, f3, f4);
        }
        if (paint instanceof GradientPaint) {
            Color color = PaintMixer.adjustColorBrightness(((GradientPaint)paint).getColor1(), f2, f3, f4);
            Color color2 = PaintMixer.adjustColorBrightness(((GradientPaint)paint).getColor2(), f2, f3, f4);
            GradientPaint gradientPaint = new GradientPaint(((GradientPaint)paint).getPoint1(), color, ((GradientPaint)paint).getPoint2(), color2, ((GradientPaint)paint).isCyclic());
            return gradientPaint;
        }
        return paint;
    }

    public static Color colorClone(Color color) {
        Color color2 = null;
        if (color.getColorSpace() != a) {
            try {
                ColorSpace colorSpace = color.getColorSpace();
                float[] fArray = color.getColorComponents(null);
                color2 = new Color(colorSpace, fArray, (float)color.getAlpha() / 255.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (color2 == null) {
            color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return color2;
    }

    public static Color getColorAt(GradientPaint gradientPaint, double d2) {
        int n2;
        Color color;
        Color color2;
        Color color3;
        block8: {
            color3 = gradientPaint.getColor1();
            color2 = gradientPaint.getColor2();
            color = null;
            d2 = Math.max(0.0, Math.min(1.0, d2));
            if (color3.getColorSpace() == a || color3.getColorSpace() != color2.getColorSpace()) break block8;
            try {
                float[] fArray = color3.getColorComponents(null);
                float[] fArray2 = color2.getColorComponents(null);
                for (n2 = 0; n2 < fArray.length; ++n2) {
                    int n3 = n2;
                    fArray[n3] = (float)((double)fArray[n3] + (double)(fArray2[n2] - fArray[n2]) * d2);
                }
                color = new Color(color3.getColorSpace(), fArray, (float)((double)color3.getAlpha() + (double)(color2.getAlpha() - color3.getAlpha()) * d2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (color == null) {
            int n4 = (int)((double)(color2.getRed() - color3.getRed()) * d2);
            int n5 = (int)((double)(color2.getGreen() - color3.getGreen()) * d2);
            n2 = (int)((double)(color2.getBlue() - color3.getBlue()) * d2);
            int n6 = (int)((double)(color2.getAlpha() - color3.getAlpha()) * d2);
            color = new Color(color3.getRed() + n4, color3.getGreen() + n5, color3.getBlue() + n2, color3.getAlpha() + n6);
        }
        return color;
    }
}

