/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;

public abstract class Quantizer {
    private static final int[] a = new int[9];
    private byte[] b;
    private int[] c;
    private c_ d;
    private int e;
    private int f;
    private int g;
    private final int h;
    private final int i;
    private final int j;
    private final int k;
    private final int l;

    public static BufferedImage quantizeImage(BufferedImage bufferedImage, Color color, int n2) {
        if (!bufferedImage.getColorModel().getColorSpace().isCS_sRGB()) {
            throw new IllegalArgumentException("Must be sRGB image");
        }
        Quantizer quantizer = Quantizer.getQuantizer(bufferedImage, color, n2);
        byte[] byArray = quantizer.quantize();
        IndexColorModel indexColorModel = new IndexColorModel(8, byArray.length / 3, byArray, 0, false);
        int n3 = bufferedImage.getWidth();
        bufferedImage = new BufferedImage(n3, bufferedImage.getHeight(), 13, indexColorModel);
        byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            block6: {
                if (n6 >= byArray2.length) break;
                byArray2[n6] = (byte)quantizer.getIndex(n4, n5);
                if (++n4 != n3) break block6;
                n4 = 0;
                ++n5;
            }
            ++n6;
        }
        return bufferedImage;
    }

    public static Quantizer getQuantizer(BufferedImage bufferedImage, Color color, int n2) {
        ColorModel colorModel = bufferedImage.getColorModel();
        final boolean bl = colorModel.hasAlpha();
        if (colorModel instanceof IndexColorModel) {
            throw new IllegalArgumentException("Already indexed");
        }
        if (colorModel instanceof DirectColorModel) {
            final int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            final int n3 = bufferedImage.getWidth();
            int n4 = color == null ? 0 : color.getRed();
            final int n5 = n4;
            int n6 = color == null ? 0 : color.getGreen();
            final int n7 = n6;
            int n8 = color == null ? 0 : color.getBlue();
            final int n9 = n8;
            return new Quantizer(n3, bufferedImage.getHeight(), colorModel.getNumColorComponents(), n2){

                public void getPixel(int n2, int n32, int[] nArray2) {
                    int n4 = nArray[n32 * n3 + n2];
                    if (bl && (n4 & 0xFF000000) != -16777216) {
                        int n52 = n4 >> 24;
                        int n6 = 255 - n52;
                        nArray2[0] = ((n4 >> 16 & 0xFF) * n52 + n5 * n6) / 255;
                        nArray2[1] = ((n4 >> 8 & 0xFF) * n52 + n7 * n6) / 255;
                        nArray2[2] = ((n4 & 0xFF) * n52 + n9 * n6) / 255;
                    } else {
                        nArray2[0] = n4 >> 16 & 0xFF;
                        nArray2[1] = n4 >> 8 & 0xFF;
                        nArray2[2] = n4 & 0xFF;
                    }
                }
            };
        }
        final WritableRaster writableRaster = bufferedImage.getRaster();
        final int n10 = colorModel.getNumColorComponents();
        float[] fArray = color == null ? new float[n10] : color.getColorComponents(null);
        float[] fArray2 = fArray;
        final int[] nArray = new int[n10];
        for (int i2 = 0; i2 < n10; ++i2) {
            nArray[i2] = Math.round(fArray2[i2] * 255.0f);
        }
        return new Quantizer(bufferedImage.getWidth(), bufferedImage.getHeight(), n10, n2){

            public void getPixel(int n2, int n3, int[] nArray2) {
                int n4;
                writableRaster.getPixel(n2, n3, nArray2);
                if (bl && (n4 = nArray2[n10]) != 255) {
                    int n5 = 255 - n4;
                    for (int i2 = 0; i2 < n10; ++i2) {
                        nArray2[i2] = (nArray2[i2] * n4 + nArray[i2] * n5) / 255;
                    }
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Quantizer(int n2, int n3, int n4, int n5) {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("width or height < 0");
        }
        if (n4 > 4) {
            throw new IllegalArgumentException("numc must be <= 4");
        }
        if (n5 < 2 || n5 > 256) {
            throw new IllegalArgumentException("numcolors must be between 2 and 256");
        }
        this.l = n5;
        this.h = n2;
        this.i = n3;
        this.j = n4;
        this.c = new int[n4 + 1];
        this.k = 1 << n4;
        int n8 = n4 <= 2 ? 3 : (n4 <= 4 ? 4 : 5);
        this.e = 1;
        for (int n9 = this.l; n9 != 0; n9 /= n8, ++this.e) {
        }
        this.e = this.e < 4 ? 2 : (this.e > 9 ? 8 : this.e - 1);
        this.d = new c_();
    }

    protected abstract void getPixel(int var1, int var2, int[] var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setColorMap(int n2, int[] nArray) {
        n2 = (n2 + 1) * this.j - 1;
        switch (this.j) {
            case 4: {
                this.b[n2--] = (byte)nArray[3];
            }
            case 3: {
                this.b[n2--] = (byte)nArray[2];
            }
            case 2: {
                this.b[n2--] = (byte)nArray[1];
            }
            case 1: {
                this.b[n2--] = (byte)nArray[0];
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] quantize() {
        int n2 = 0;
        block16: while (true) {
            if (n2 >= this.i) {
                long l2 = 1L;
                while (true) {
                    if (this.f <= this.l) {
                        this.b = new byte[this.f * this.j];
                        this.f = 0;
                        this.d.c();
                        return this.b;
                    }
                    this.f = 0;
                    l2 = this.d.a(l2, Long.MAX_VALUE);
                }
            }
            int n3 = 0;
            while (true) {
                int n4;
                c_ c_2;
                if (n3 < this.h) {
                    this.getPixel(n3, n2, this.c);
                    if (this.g > 299593) {
                        this.d.b();
                        --this.e;
                    }
                    c_2 = this.d;
                } else {
                    ++n2;
                    continue block16;
                }
                for (int n5 = 1; n5 <= this.e; c_2 = c_2.a(n4, n5), ++n5) {
                    n4 = 0;
                    switch (this.j) {
                        case 4: {
                            if (this.c[3] > c_2.g) {
                                n4 |= 8;
                            }
                        }
                        case 3: {
                            if (this.c[2] > c_2.f) {
                                n4 |= 4;
                            }
                        }
                        case 2: {
                            if (this.c[1] > c_2.e) {
                                n4 |= 2;
                            }
                        }
                        case 1: {
                            if (this.c[0] <= c_2.d) break;
                            n4 |= 1;
                            break;
                        }
                    }
                    c_2.l += Quantizer.a[n5];
                }
                c_2.m++;
                switch (this.j) {
                    case 4: {
                        c_2.k += this.c[3];
                    }
                    case 3: {
                        c_2.j += this.c[2];
                    }
                    case 2: {
                        c_2.i += this.c[1];
                    }
                    case 1: {
                        c_2.h += this.c[0];
                        break;
                    }
                }
                ++n3;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIndex(int n2, int n3) {
        this.getPixel(n2, n3, this.c);
        c_ c_2 = this.d;
        while (true) {
            int n4 = 0;
            switch (this.j) {
                case 4: {
                    if (this.c[3] > c_2.g) {
                        n4 |= 8;
                    }
                }
                case 3: {
                    if (this.c[2] > c_2.f) {
                        n4 |= 4;
                    }
                }
                case 2: {
                    if (this.c[1] > c_2.e) {
                        n4 |= 2;
                    }
                }
                case 1: {
                    if (this.c[0] <= c_2.d) break;
                    n4 |= 1;
                    break;
                }
            }
            if (c_2.b == null) return c_2.d();
            if (c_2.b[n4] == null) {
                return c_2.d();
            }
            c_2 = c_2.b[n4];
        }
    }

    public void dispose() {
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        System.out.println("read");
        bufferedImage = Quantizer.quantizeImage(bufferedImage, null, 256);
        System.out.println("write");
        ImageIO.write((RenderedImage)bufferedImage, "PNG", new File("out.png"));
    }

    static {
        for (int i2 = 0; i2 <= 8; ++i2) {
            Quantizer.a[i2] = 1 << 15 - i2;
        }
    }

    private class c_ {
        private final c_ a;
        private c_[] b;
        private int c;
        private int d;
        private int e;
        private int f;
        private int g;
        private int h;
        private int i;
        private int j;
        private int k;
        private long l;
        private int m;

        private c_(c_ c_2, int n2, int n3) {
            this.a = c_2;
            this.c = (n2 << 8) + n3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        c_() {
            this(null, 0, 0);
            this.l = Long.MAX_VALUE;
            int n2 = 128;
            switch (quantizer.j) {
                case 4: {
                    this.g = n2;
                }
                case 3: {
                    this.f = n2;
                }
                case 2: {
                    this.e = n2;
                }
                case 1: {
                    this.d = n2;
                    return;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        c_ a(int n2, int n3) {
            c_ c_2;
            if (this.b == null) {
                this.b = new c_[Quantizer.this.k];
            }
            if (this.b[n2] != null) return this.b[n2];
            this.b[n2] = c_2 = new c_(this, n2, n3);
            this.c += 0x1000000;
            Quantizer.this.g++;
            if (n3 == Quantizer.this.e) {
                Quantizer.this.f++;
            }
            int n4 = 1 << 8 - n3 >> 1;
            switch (Quantizer.this.j) {
                case 4: {
                    c_2.g = this.g + ((n2 & 8) != 0 ? n4 : -n4);
                }
                case 3: {
                    c_2.f = this.f + ((n2 & 4) != 0 ? n4 : -n4);
                }
                case 2: {
                    c_2.e = this.e + ((n2 & 2) != 0 ? n4 : -n4);
                }
                case 1: {
                    c_2.d = this.d + ((n2 & 1) != 0 ? n4 : -n4);
                    return this.b[n2];
                }
            }
            return this.b[n2];
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void a() {
            if (this.c > 0xFFFFFF) {
                throw new IllegalStateException("Pruning kid with children");
            }
            this.a.m += this.m;
            switch (Quantizer.this.j) {
                case 4: {
                    this.a.k += this.k;
                }
                case 3: {
                    this.a.j += this.j;
                }
                case 2: {
                    this.a.i += this.i;
                }
                case 1: {
                    this.a.h += this.h;
                    break;
                }
            }
            this.a.b[this.c >> 8 & 0xFF] = null;
            Quantizer.this.g--;
            this.a.c -= 0x1000000;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void b() {
            int n2;
            if (this.c > 0xFFFFFF) {
                for (n2 = 0; n2 < Quantizer.this.k; ++n2) {
                    if (this.b[n2] == null) continue;
                    this.b[n2].b();
                }
            }
            if ((n2 = this.c & 0xFF) != Quantizer.this.e) return;
            this.a();
        }

        long a(long l2, long l3) {
            block12: {
                block11: {
                    if (this.c > 0xFFFFFF) {
                        int n2 = 0;
                        while (true) {
                            block10: {
                                if (n2 >= Quantizer.this.k) break;
                                if (this.b[n2] == null) break block10;
                                l3 = this.b[n2].a(l2, l3);
                            }
                            ++n2;
                        }
                    }
                    if (this.l > l2) break block11;
                    this.a();
                    break block12;
                }
                if (this.m != 0) {
                    Quantizer.this.f++;
                }
                if (this.l < l3) {
                    l3 = this.l;
                }
            }
            return l3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void c() {
            int n2;
            if (this.c > 0xFFFFFF) {
                for (n2 = 0; n2 < Quantizer.this.k; ++n2) {
                    if (this.b[n2] == null) continue;
                    this.b[n2].c();
                }
            }
            if (this.m != 0) {
                n2 = this.m >> 1;
                switch (Quantizer.this.j) {
                    case 4: {
                        ((Quantizer)Quantizer.this).c[3] = (this.k + n2) / this.m;
                    }
                    case 3: {
                        ((Quantizer)Quantizer.this).c[2] = (this.j + n2) / this.m;
                    }
                    case 2: {
                        ((Quantizer)Quantizer.this).c[1] = (this.i + n2) / this.m;
                    }
                    case 1: {
                        ((Quantizer)Quantizer.this).c[0] = (this.h + n2) / this.m;
                        break;
                    }
                }
                Quantizer.this.setColorMap(Quantizer.this.f, Quantizer.this.c);
                this.c |= Quantizer.this.f++ << 16;
            }
        }

        int d() {
            return this.c >> 16 & 0xFF;
        }

        public String toString() {
            StringBuffer stringBuffer;
            block3: {
                block2: {
                    stringBuffer = new StringBuffer();
                    if (this.a != null) break block2;
                    stringBuffer.append("root");
                    break block3;
                }
                stringBuffer.append("node");
            }
            stringBuffer.append(' ');
            stringBuffer.append(this.c & 0xFF);
            stringBuffer.append(" [");
            stringBuffer.append(this.g);
            stringBuffer.append(',');
            stringBuffer.append(this.e);
            stringBuffer.append(',');
            stringBuffer.append(this.e);
            stringBuffer.append(',');
            stringBuffer.append(this.d);
            stringBuffer.append(']');
            stringBuffer.append(this.m);
            return stringBuffer.toString();
        }
    }
}

