/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.faceless.util.DamageSensing;

public abstract class SeekableInputStream
extends InputStream
implements DamageSensing {
    private long a;
    private boolean b;

    public abstract int read() throws IOException;

    public abstract void close() throws IOException;

    public abstract int available() throws IOException;

    public abstract long tell();

    public abstract void seek(long var1) throws IOException;

    public long skip(long l2) throws IOException {
        long l3 = l2;
        while (true) {
            if (l2 <= 0L || this.read() < 0) break;
            --l2;
        }
        return l3 - l2;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n2) {
        this.a = this.tell();
    }

    public void reset() throws IOException {
        this.seek(this.a);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public boolean search(byte[] byArray) throws IOException {
        return this.search(byArray, Long.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean search(byte[] byArray, long l2) throws IOException {
        if (byArray.length == 0) {
            return true;
        }
        long l3 = 0L;
        long l4 = this.tell();
        do {
            int n2;
            this.seek(l4 + l3);
            int n3 = 0;
            for (n2 = 0; n2 < byArray.length && (n3 = this.read()) == (byArray[n2] & 0xFF); ++n2) {
            }
            if (n3 == -1) {
                return false;
            }
            if (n2 == byArray.length) {
                this.seek(this.tell() - (long)n2);
                return true;
            }
            if ((l3 += l2 < 0L ? -1L : 1L) == l2) return false;
        } while (l4 + l3 >= 0L);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(byte[] byArray) throws IOException {
        boolean bl = true;
        long l2 = this.tell();
        for (int n2 = 0; bl && n2 < byArray.length; ++n2) {
            bl = this.read() == (byArray[n2] & 0xFF);
        }
        this.seek(l2);
        return bl;
    }

    public void unread() throws IOException {
        this.seek(this.tell() - 1L);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(outputStream, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(OutputStream outputStream, long l2) throws IOException {
        int n4;
        byte[] byArray = new byte[8192];
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        while (l2 > 0L && (n4 = this.read(byArray, 0, l2 > (long)byArray.length ? byArray.length : (int)l2)) >= 0) {
            outputStream.write(byArray, 0, n4);
            l2 -= (long)n4;
        }
    }

    public final int readeof() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        while (n3 > 0 && (n4 = this.read(byArray, n2, n3)) >= 0) {
            n2 += n4;
            n3 -= n4;
        }
        if (n3 < 0) {
            throw new EOFException();
        }
    }

    public final void setBigEndian(boolean bl) {
        this.b = !bl;
    }

    public final int readUShort() throws IOException {
        if (this.b) {
            return this.readeof() | this.readeof() << 8;
        }
        return this.readeof() << 8 | this.readeof();
    }

    public final int readShort() throws IOException {
        if (this.b) {
            return (short)(this.readeof() | this.readeof() << 8);
        }
        return (short)(this.readeof() << 8 | this.readeof());
    }

    public final int readInt() throws IOException {
        if (this.b) {
            return this.readeof() | this.readeof() << 8 | this.readeof() << 16 | this.readeof() << 24;
        }
        return this.readeof() << 24 | this.readeof() << 16 | this.readeof() << 8 | this.readeof();
    }

    public final long readLong() throws IOException {
        if (this.b) {
            return (long)this.readInt() | (long)this.readInt() << 32;
        }
        return (long)this.readInt() << 32 | (long)this.readInt();
    }

    public final String readZeroString(String string) throws IOException {
        int n2;
        block8: {
            int n3;
            if (string != null && !"ISO-8859-1".equals(string)) break block8;
            char[] cArray = new char[256];
            int n4 = 0;
            while ((n3 = this.readeof()) > 0) {
                block9: {
                    if (n4 != cArray.length - 1) break block9;
                    char[] cArray2 = new char[cArray.length + (cArray.length >> 1)];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                cArray[n4++] = (char)n3;
            }
            return new String(cArray, 0, n4);
        }
        byte[] byArray = new byte[256];
        int n5 = 0;
        while ((n2 = this.readeof()) > 0) {
            block10: {
                if (n5 != byArray.length - 1) break block10;
                byte[] byArray2 = new byte[byArray.length + (byArray.length >> 1)];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            byArray[n5++] = (byte)n2;
        }
        return new String(byArray, 0, n5, string);
    }

    public String readPascalString() throws IOException {
        return this.readFixedString(this.readeof(), null);
    }

    public String readFixedString(int n2, String string) throws IOException {
        block16: {
            if (string != null && !string.equals("ISO-8859-1")) break block16;
            char[] cArray = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                cArray[i2] = (char)this.readeof();
            }
            return new String(cArray, 0, n2);
        }
        if (string == "UTF-16BE") {
            char[] cArray = new char[n2 >> 1];
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                cArray[i3] = (char)((this.readeof() << 8) + this.readeof());
            }
            return new String(cArray, 0, cArray.length);
        }
        if (string == "UTF-16LE") {
            char[] cArray = new char[n2 >> 1];
            for (int i4 = 0; i4 < cArray.length; ++i4) {
                cArray[i4] = (char)(this.readeof() + (this.readeof() << 8));
            }
            return new String(cArray, 0, cArray.length);
        }
        byte[] byArray = new byte[n2];
        for (int i5 = 0; i5 < n2; ++i5) {
            byArray[i5] = (byte)this.readeof();
        }
        return new String(byArray, 0, n2, string);
    }

    public double readIEEEDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readIEEEFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readFixedDouble() throws IOException {
        return (double)this.readShort() + (double)this.readUShort() / 65536.0;
    }

    public double readIntFraction() throws IOException {
        return (double)this.readInt() / (double)this.readInt();
    }

    public double readShortFraction() throws IOException {
        return (double)this.readShort() / (double)this.readShort();
    }

    public double read2Fraction14() throws IOException {
        int n2 = this.readShort();
        return (double)(n2 >> 14) + (double)(n2 & 0x3FFF) / 16384.0;
    }
}

