/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.faceless.util.DamageSensing;
import org.faceless.util.SeekableInputStream;

public class SemiSeekableInputStream
extends SeekableInputStream {
    private byte[] c;
    private final InputStream d;
    private long e;
    private int f;
    private int g;
    private boolean h;

    public SemiSeekableInputStream(InputStream inputStream) {
        this(inputStream, 1024);
    }

    public SemiSeekableInputStream(InputStream inputStream, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("bufsize=" + n2);
        }
        this.d = inputStream;
        this.c = new byte[n2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDamaged() {
        if (!(this.d instanceof DamageSensing)) return false;
        if (!((DamageSensing)((Object)this.d)).isDamaged()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        int n2;
        if (this.h) {
            throw new IOException("Stream is closed");
        }
        if (this.g > 0) {
            int n3 = this.f - this.g;
            if (n3 < 0) {
                n3 += this.c.length;
            }
            n2 = this.c[n3] & 0xFF;
            --this.g;
            return n2;
        }
        n2 = this.d.read();
        if (n2 < 0) return n2;
        this.c[this.f++] = (byte)n2;
        if (this.f == this.c.length) {
            this.f = 0;
        }
        ++this.e;
        return n2;
    }

    public long skip(long l2) throws IOException {
        long l3 = 0L;
        if (this.g > 0) {
            l3 = Math.min(l2, (long)this.g);
            this.g = (int)((long)this.g - l3);
            l2 -= l3;
        }
        if (l2 > 0L) {
            this.e += (l3 += this.d.skip(l2));
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (this.h) {
            throw new IOException("Stream is closed");
        }
        int n6 = 0;
        if (n3 <= 0) return n6;
        while (this.g > 0) {
            n5 = this.f - this.g;
            if (n5 < 0) {
                n4 = -n5;
                n5 += this.c.length;
            } else {
                n4 = this.g;
            }
            if (n3 < n4) {
                n4 = n3;
            }
            System.arraycopy(this.c, n5, byArray, n2, n4);
            n2 += n4;
            n6 += n4;
            n3 -= n4;
            this.g -= n4;
        }
        if (n3 <= 0) return n6;
        n5 = this.d.read(byArray, n2, n3);
        if (n5 < 0) {
            if (n6 != 0) return n6;
            return -1;
        }
        n6 += n5;
        this.e += (long)n5;
        if (n5 >= this.c.length) {
            System.arraycopy(byArray, n2 + n5 - this.c.length, this.c, 0, this.c.length);
            this.f = 0;
            return n6;
        }
        if (n5 < this.c.length - this.f) {
            System.arraycopy(byArray, n2, this.c, this.f, n5);
            this.f += n5;
            return n6;
        }
        n4 = this.c.length - this.f;
        System.arraycopy(byArray, n2, this.c, this.f, n4);
        System.arraycopy(byArray, n2 + n4, this.c, 0, n5 - n4);
        this.f = n5 - n4;
        return n6;
    }

    public long tell() {
        return this.e - (long)this.g;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void seek(long l2) throws IOException {
        if (this.h) {
            throw new IOException("Stream is closed");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException(Long.toString(l2));
        }
        long l3 = l2 - this.tell();
        if (l3 <= (long)this.g) {
            this.g = (int)((long)this.g - l3);
            if ((long)this.g <= (long)this.c.length) return;
            throw new IOException("Seek of -" + (this.e - l2) + " outruns buffer " + this.c.length);
        } else {
            long l4;
            l3 -= (long)this.g;
            this.g = 0;
            while (l3 > (long)this.c.length && (l4 = this.d.skip(l3 - (long)this.c.length)) != 0L) {
                l3 -= l4;
                this.e += l4;
            }
            if (l3 > (long)this.c.length) {
                throw new EOFException("Unable to skip");
            }
            if (l3 <= 0L) return;
            int n2 = 0;
            byte[] byArray = new byte[(int)l3];
            while (l3 > 0L && (n2 = this.read(byArray, 0, (int)l3 < byArray.length ? (int)l3 : byArray.length)) >= 0) {
                l3 -= (long)n2;
            }
        }
    }

    public void close() throws IOException {
        this.h = true;
        this.d.close();
    }

    public int available() throws IOException {
        return this.d.available() + this.g;
    }
}

