/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;

public final class SparseArray
implements Serializable,
Cloneable {
    private transient a_[] a;
    private float factor;
    private transient int b;
    private transient int c;
    private transient int d;
    private transient int e;
    public static final SparseArray EMPTY = new SparseArray(false);
    static final long serialVersionUID = -806555017536554509L;

    private SparseArray(boolean bl) {
        this.a = new a_[1];
        this.e = 0;
        this.factor = 0.0f;
        this.d = 0;
        this.c = 0;
    }

    public SparseArray() {
        this(64);
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            block3: {
                if (n3 >= this.a.length) break;
                if (this.a[n3] == null) break block3;
                n2 ^= this.a[n3].b;
                n2 ^= this.a[n3].c.hashCode();
            }
            ++n3;
        }
        return n2;
    }

    public boolean equals(Object object) {
        block8: {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SparseArray) || this.size() != ((SparseArray)object).size()) break block8;
            Iterator iterator = ((SparseArray)object).iterator();
            while (iterator.next()) {
                long l2 = iterator.getKey();
                Object object2 = iterator.getValue();
                if (object2.equals(this.get(l2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public SparseArray(int n2) {
        this(n2, 0.75);
    }

    public SparseArray(int n2, double d2) {
        this.a(n2, (float)d2);
    }

    private void a(int n2, float f2) {
        int n3;
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.a = new a_[n3];
        this.factor = f2;
        this.e = n3 - 1;
        this.d = (int)((float)n3 * f2);
        this.c = 0;
    }

    public SparseArray(SparseArray sparseArray) {
        this.factor = sparseArray.factor;
        this.a((int)Math.ceil((float)sparseArray.size() / this.factor), this.factor);
        this.putAll(sparseArray);
    }

    public void putAll(SparseArray sparseArray) {
        Iterator iterator = sparseArray.iterator();
        while (iterator.next()) {
            this.put(iterator.getKey(), iterator.getValue());
        }
    }

    private static final int a(long l2) {
        int n2 = (int)(l2 ^ (long)((int)(l2 >> 16)) ^ (long)((int)(l2 >> 48)));
        n2 = ~n2 + (n2 << 15);
        n2 ^= n2 >> 11;
        n2 += n2 << 3;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(long l2) {
        int n2 = SparseArray.a(l2) & this.e;
        a_ a_2 = this.a[n2];
        while (a_2 != null) {
            if (a_2.a == l2) {
                return a_2.c;
            }
            a_2 = a_2.d;
        }
        return null;
    }

    public boolean containsKey(long l2) {
        boolean bl = this.get(l2) != null;
        return bl;
    }

    public Object set(long l2, Object object) {
        return this.put(l2, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object put(long l2, Object object) {
        if (this == EMPTY) {
            throw new UnsupportedOperationException();
        }
        if (object == null) {
            return this.remove(l2);
        }
        int n2 = SparseArray.a(l2);
        int n3 = n2 & this.e;
        a_ a_2 = this.a[n3];
        if (a_2 == null) {
            ++this.c;
            ++this.b;
            this.a[n3] = new a_(l2, object, n2);
            return null;
        }
        while (true) {
            if (a_2.a == l2) {
                Object object2 = a_2.c;
                a_2.c = object;
                return object2;
            }
            if (a_2.d == null) {
                ++this.c;
                ++this.b;
                a_2.d = new a_(l2, object, n2);
                if (this.b > this.d) {
                    this.a();
                }
                return null;
            }
            a_2 = a_2.d;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove(long l2) {
        int n2 = SparseArray.a(l2);
        int n3 = n2 & this.e;
        a_ a_2 = this.a[n3];
        if (a_2 != null) {
            if (a_2.a == l2) {
                this.a[n3] = a_2.d;
                --this.b;
                ++this.c;
                return a_2.c;
            }
            a_ a_3 = a_2.d;
            while (a_3 != null) {
                if (a_3.a == l2) {
                    a_2.d = a_3.d;
                    --this.b;
                    ++this.c;
                    return a_3.c;
                }
                a_2 = a_2.d;
                a_3 = a_2.d;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a() {
        a_[] a_Array = this.a;
        int n2 = a_Array.length;
        a_[] a_Array2 = new a_[n2 << 1];
        int n3 = a_Array2.length - 1;
        int n4 = 0;
        while (true) {
            if (n4 >= n2) {
                this.a = a_Array2;
                this.e = n3;
                this.d = (int)((float)a_Array2.length * this.factor);
                return;
            }
            a_ a_2 = a_Array[n4];
            if (a_2 != null) {
                a_ a_3;
                a_Array[n4] = null;
                do {
                    a_3 = a_2.d;
                    int n5 = a_2.b & n3;
                    a_2.d = a_Array2[n5];
                    a_Array2[n5] = a_2;
                } while ((a_2 = a_3) != null);
            }
            ++n4;
        }
    }

    public void close() {
    }

    public int size() {
        return this.b;
    }

    public boolean isEmpty() {
        boolean bl = this.b == 0;
        return bl;
    }

    public void clear() {
        for (int i2 = 0; i2 <= this.e; ++i2) {
            this.a[i2] = null;
        }
        this.b = 0;
        ++this.c;
    }

    public long[] keyArray() {
        long[] lArray = new long[this.size()];
        int n2 = 0;
        Iterator iterator = this.iterator();
        while (iterator.next()) {
            lArray[n2++] = iterator.getKey();
        }
        return lArray;
    }

    public Set keySet() {
        long[] lArray = this.keyArray();
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            hashSet.add(new Long(lArray[i2]));
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        long[] lArray = this.keyArray();
        if (lArray.length == 0) {
            return "{}";
        }
        Arrays.sort(lArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int n2 = 0; n2 < lArray.length; ++n2) {
            stringBuffer.append(lArray[n2] + "=" + this.get(lArray[n2]) + (n2 == lArray.length - 1 ? "}" : " "));
        }
        if (lArray.length == 0) {
            return "{}";
        }
        String string = stringBuffer.toString();
        return string;
    }

    public Object clone() {
        return new SparseArray(this);
    }

    public Iterator iterator() {
        return new Iterator(this.c);
    }

    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.size());
        Iterator iterator = this.iterator();
        while (iterator.next()) {
            arrayList.add(iterator.getValue());
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n2;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.a.length);
        objectOutputStream.writeInt(this.b);
        long[] lArray = this.keyArray();
        Arrays.sort(lArray);
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        int[] nArray = new int[lArray.length];
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            if (lArray[n2] < l3) {
                l3 = lArray[n2];
            }
            if (lArray[n2] > l2) {
                l2 = lArray[n2];
            }
            n4 = n2 > 0 && n4 < 254 && lArray[n2] == lArray[n2 - 1] + 1L ? ++n4 : 0;
            int n5 = n2 - n4;
            nArray[n5] = nArray[n5] + 1;
            Object object = this.get(lArray[n2]);
            if (object.getClass() == String.class) {
                n3 |= 1;
                continue;
            }
            if (object.getClass() == Integer.class) {
                n3 |= 2;
                continue;
            }
            if (object.getClass() == Character.class) {
                n3 |= 4;
                continue;
            }
            if (object.getClass().isArray() && object.getClass().getComponentType() == Integer.TYPE && Array.getLength(object) < 255) {
                n3 |= 8;
                continue;
            }
            n3 = 255;
        }
        for (n2 = 0; n2 < lArray.length; ++n2) {
        }
        n2 = l3 >= 0L && l2 <= 255L ? 1 : (l3 >= 0L && l2 <= 65535L ? 2 : ((long)((int)l3) == l3 && (long)((int)l2) == l2 ? 4 : 8));
        objectOutputStream.writeByte(n2);
        objectOutputStream.writeByte(n3);
        int n6 = 0;
        block25: while (true) {
            if (n6 >= lArray.length) {
                objectOutputStream.writeByte(0);
                return;
            }
            n4 = nArray[n6];
            long l4 = lArray[n6];
            objectOutputStream.writeByte(n4);
            switch (n2) {
                case 1: {
                    objectOutputStream.writeByte((int)l4);
                    break;
                }
                case 2: {
                    objectOutputStream.writeShort((int)l4);
                    break;
                }
                case 4: {
                    objectOutputStream.writeInt((int)l4);
                    break;
                }
                default: {
                    objectOutputStream.writeLong(l4);
                }
            }
            block26: while (true) {
                if (n4-- <= 0) continue block25;
                l4 = lArray[n6++];
                Object object = this.get(l4);
                if (n3 == 1) {
                    objectOutputStream.writeUTF((String)object);
                    continue;
                }
                if (n3 == 2) {
                    objectOutputStream.writeInt((Integer)object);
                    continue;
                }
                if (n3 == 4) {
                    objectOutputStream.writeChar(((Character)object).charValue());
                    continue;
                }
                if (n3 == 8) {
                    int[] nArray2 = (int[])object;
                    objectOutputStream.writeByte(nArray2.length);
                    int n7 = 0;
                    while (true) {
                        if (n7 >= nArray2.length) continue block26;
                        objectOutputStream.writeInt(nArray2[n7]);
                        ++n7;
                    }
                }
                objectOutputStream.writeObject(object);
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.a = new a_[n2];
        this.e = n2 - 1;
        this.d = (int)((float)n2 * this.factor);
        objectInputStream.readInt();
        int n3 = objectInputStream.readUnsignedByte();
        int n4 = objectInputStream.readUnsignedByte();
        int n5 = objectInputStream.readUnsignedByte();
        while (n5 > 0) {
            long l2;
            switch (n3) {
                case 1: {
                    l2 = objectInputStream.readUnsignedByte();
                    break;
                }
                case 2: {
                    l2 = objectInputStream.readUnsignedShort();
                    break;
                }
                case 4: {
                    l2 = objectInputStream.readInt();
                    break;
                }
                default: {
                    l2 = objectInputStream.readLong();
                }
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                Object object;
                if (n4 == 1) {
                    object = objectInputStream.readUTF();
                } else if (n4 == 2) {
                    object = new Integer(objectInputStream.readInt());
                } else if (n4 == 4) {
                    object = new Character(objectInputStream.readChar());
                } else if (n4 == 8) {
                    int n6 = objectInputStream.readUnsignedByte();
                    int[] nArray = new int[n6];
                    for (int i3 = 0; i3 < n6; ++i3) {
                        nArray[i3] = objectInputStream.readInt();
                    }
                    object = nArray;
                } else {
                    object = objectInputStream.readObject();
                }
                this.put(l2 + (long)i2, object);
            }
            n5 = objectInputStream.readUnsignedByte();
        }
        return;
    }

    public final class Iterator {
        private int a;
        private a_ b;
        private int c;

        Iterator(int n2) {
            this.a = n2;
            this.c = -1;
        }

        public long getKey() {
            return this.b.a;
        }

        public Object getValue() {
            return this.b.c;
        }

        public void setValue(Object object) {
            if (SparseArray.this.c != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b.c = object;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean next() {
            if (SparseArray.this.c != this.a) {
                throw new ConcurrentModificationException();
            }
            if (this.b != null) {
                this.b = this.b.d;
            }
            while (this.b == null) {
                if (this.c == SparseArray.this.e) {
                    return false;
                }
                ++this.c;
                this.b = SparseArray.this.a[this.c];
            }
            return true;
        }

        public void remove() {
            block4: {
                a_ a_2;
                block3: {
                    int n2 = this.b.b & SparseArray.this.e;
                    a_2 = SparseArray.this.a[n2];
                    if (a_2 != this.b) break block3;
                    ((SparseArray)SparseArray.this).a[n2] = this.b.d;
                    break block4;
                }
                while (a_2.d != this.b) {
                    a_2 = a_2.d;
                }
                a_2.d = this.b.d;
            }
            SparseArray.this.b--;
        }
    }

    private static class a_ {
        final long a;
        final int b;
        Object c;
        a_ d;

        a_(long l2, Object object, int n2) {
            this.a = l2;
            this.c = object;
            this.b = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(this.a);
            stringBuffer.append("=");
            stringBuffer.append(this.c);
            stringBuffer.append(" h=");
            stringBuffer.append(Integer.toHexString(this.b));
            stringBuffer.append(" next=");
            stringBuffer.append(this.d);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

