/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.util.Arrays;

public class SuperBitSet
implements Cloneable {
    private int a;
    private int[] c;

    public SuperBitSet(SuperBitSet superBitSet) {
        this(superBitSet.a);
        System.arraycopy(superBitSet.c, 0, this.c, 0, this.c.length);
    }

    public Object clone() {
        try {
            SuperBitSet superBitSet = (SuperBitSet)super.clone();
            superBitSet.c = (int[])this.c.clone();
            return superBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public SuperBitSet(int n2) {
        this.a = n2;
        this.c = new int[n2 + 32 - 1 >> 5];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(long l2) {
        int n2 = 0;
        while (n2 < this.a) {
            if ((l2 & 1L << n2) != 0L) {
                this.set(n2);
            }
            ++n2;
        }
        return;
    }

    public int size() {
        return this.a;
    }

    public void clearAll() {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = 0;
        }
    }

    public void setAll() {
        this.clearAll();
        this.invert();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(int n2) {
        if (n2 >= 0 && n2 < this.a) {
            int n3 = n2 >> 5;
            this.c[n3] = this.c[n3] | 1 << n2 % 32;
            return;
        }
        throw new ArrayIndexOutOfBoundsException("Bit " + n2 + " is outside range 0-" + (this.a - 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear(int n2) {
        if (n2 >= 0 && n2 < this.a) {
            int n3 = n2 >> 5;
            this.c[n3] = this.c[n3] & ~(1 << n2 % 32);
            return;
        }
        throw new ArrayIndexOutOfBoundsException("Bit " + n2 + " is outside range 0-" + (this.a - 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean get(int n2) {
        if (n2 < 0) throw new ArrayIndexOutOfBoundsException("Bit " + n2 + " is outside range 0-" + (this.a - 1));
        if (n2 >= this.a) {
            throw new ArrayIndexOutOfBoundsException("Bit " + n2 + " is outside range 0-" + (this.a - 1));
        }
        if ((this.c[n2 >> 5] & 1 << n2 % 32) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allSet() {
        int n2 = 0;
        while (n2 < this.a) {
            if (!this.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allClear() {
        int n2 = 0;
        while (n2 < this.a) {
            if (this.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void invert() {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = ~this.c[i2];
        }
    }

    public void and(SuperBitSet superBitSet) {
        int n2 = this.c.length < superBitSet.c.length ? this.c.length : superBitSet.c.length;
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            this.c[n4] = this.c[n4] & superBitSet.c[i2];
        }
    }

    public void andNot(SuperBitSet superBitSet) {
        int n2 = this.c.length < superBitSet.c.length ? this.c.length : superBitSet.c.length;
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            this.c[n4] = this.c[n4] & ~superBitSet.c[i2];
        }
    }

    public void or(SuperBitSet superBitSet) {
        int n2 = this.c.length < superBitSet.c.length ? this.c.length : superBitSet.c.length;
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            this.c[n4] = this.c[n4] | superBitSet.c[i2];
        }
    }

    public void xor(SuperBitSet superBitSet) {
        int n2 = this.c.length < superBitSet.c.length ? this.c.length : superBitSet.c.length;
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            this.c[n4] = this.c[n4] ^ superBitSet.c[i2];
        }
    }

    public void resize(int n2) {
        if (n2 == this.a) {
            return;
        }
        if (n2 >> 5 != this.a >> 5) {
            int[] nArray = new int[(n2 + 32 - 1 >> 5) + 1];
            int[] nArray2 = this.c;
            int n3 = 0;
            int[] nArray3 = nArray;
            int n4 = 0;
            int n5 = nArray.length < this.c.length ? nArray.length : this.c.length;
            System.arraycopy(nArray2, n3, nArray3, n4, n5);
            this.c = nArray;
        }
        this.a = n2;
        int n6 = this.a >> 5;
        this.c[n6] = this.c[n6] & (1 << this.a % 32) - 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rot(int n2) {
        n2 = n2 > 0 ? n2 % this.a : n2 + this.a - n2 / this.a * this.a;
        int[] nArray = new int[this.c.length];
        int n3 = 0;
        while (true) {
            if (n3 >= this.a) {
                this.c = nArray;
                return;
            }
            if (this.get(n3)) {
                int n4 = (n3 + n2) % this.a >> 5;
                nArray[n4] = nArray[n4] | 1 << (n3 + n2) % this.a % 32;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shift(int n2) {
        int[] nArray = new int[this.c.length];
        int n3 = n2 > 0 ? 0 : -n2;
        while (true) {
            if (n3 >= (n2 > 0 ? this.a - n2 : this.a)) {
                this.c = nArray;
                return;
            }
            if (this.get(n3)) {
                int n4 = n3 + n2 >> 5;
                nArray[n4] = nArray[n4] | 1 << (n3 + n2) % 32;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SuperBitSet copy(int n2, int n3) {
        if (n3 < n2 || n2 < 0 || n3 > this.a) {
            throw new ArrayIndexOutOfBoundsException("bits " + n2 + " to " + n3 + " are outside the range 0-" + this.a);
        }
        SuperBitSet superBitSet = new SuperBitSet(n3 - n2);
        int n4 = n2;
        while (n4 < n3) {
            if (this.get(n4)) {
                superBitSet.set(n4 - n2);
            }
            ++n4;
        }
        return superBitSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SuperBitSet cut(int n2, int n3) {
        if (n3 < n2 || n2 < 0 || n3 > this.a) {
            throw new ArrayIndexOutOfBoundsException("bits " + n2 + " to " + n3 + " are outside the range 0-" + this.a);
        }
        SuperBitSet superBitSet = new SuperBitSet(n3 - n2);
        int n4 = n2;
        while (true) {
            if (n4 >= this.a) {
                this.resize(this.a - (n3 - n2));
                return superBitSet;
            }
            if (n4 < n3 && this.get(n4)) {
                superBitSet.set(n4 - n2);
            }
            if (n4 + (n3 - n2) < this.a) {
                if (this.get(n4 + (n3 - n2))) {
                    this.set(n4);
                } else {
                    this.clear(n4);
                }
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paste(SuperBitSet superBitSet, int n2) {
        int n4;
        if (n2 < 0 || n2 > this.a) {
            throw new ArrayIndexOutOfBoundsException("bit " + n2 + " is outside the range 0-" + this.a);
        }
        int n3 = superBitSet.a;
        this.resize(this.a + n3);
        for (n4 = this.a - 1; n4 >= n2 + n3; --n4) {
            if (this.get(n4 - n3)) {
                this.set(n4);
                continue;
            }
            this.clear(n4);
        }
        n4 = 0;
        while (n4 < n3) {
            if (superBitSet.get(n4)) {
                this.set(n4 + n2);
            } else {
                this.clear(n4 + n2);
            }
            ++n4;
        }
        return;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            n2 ^= this.c[i2];
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (!(object instanceof SuperBitSet)) return false;
        if (((SuperBitSet)object).a != this.a) return false;
        if (!Arrays.equals(((SuperBitSet)object).c, this.c)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startsWith(SuperBitSet superBitSet) {
        if (superBitSet.a < this.a) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.a) {
            if (superBitSet.c[n2] != this.c[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        String string = "";
        int n2 = this.a - 1;
        while (true) {
            String string2;
            StringBuilder stringBuilder;
            block4: {
                block3: {
                    if (n2 < 0) break;
                    stringBuilder = new StringBuilder().append(string);
                    if (!this.get(n2)) break block3;
                    string2 = "1";
                    break block4;
                }
                string2 = "0";
            }
            string = stringBuilder.append(string2).toString();
            --n2;
        }
        return "(" + string + ")";
    }
}

